/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hGqe
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import net.hires.debug.Stats;
    
    [SWF(width=465, height=465, backgroundColor=0x0, frameRate=120)]
    
    public class FlashTest extends Sprite {
        private static const GRAVITY:Number = 20;
        private static const DRAG:Number = 0.3;
        
        private var _canvas:BitmapData;
        private var _glow:BitmapData;
        private var _glowMtx:Matrix;
        private var _forceMap:BitmapData;
        private var _snow:Array;
        
        public function FlashTest() {
            this._canvas = new BitmapData(465, 465, false, 0x0);
            this.addChild(new Bitmap(this._canvas)) as Bitmap;
            this._glow = new BitmapData(465/4, 465/4, false, 0x0);
            var bm:Bitmap = this.addChild(new Bitmap(this.glow, PixelSnapping.NEVER, true)) as Bitmap;
            bm.scaleX = bm.scaleY = 4;
            bm.blendMode = BlendMode.ADD;
            this._glowMtx = new Matrix(0.25,0,0,0.25);
            
            var tf:TextField = new TextField();
            tf.defaultTextFormat = new TextFormat('Verdana', 64, 0xffffff, true);
            tg.autoSize = TextFieldAutoSize.LEFT;
            tf.x = (465 - tf.width) / 2;
            tf.y = (465 - tf.height) / 2;
            this._forceMap = new BitmapData(465, 465, false, 0x0);
            this._forceMap.draw(tf, tf.transform.matrix);
            this._forceMap.applyFilter(this._forceMap, this._forceMap.rect, new Point(0,0), new BlurFilter(8,8));
            this.snow = [];
            this.addChild(new Stats());
            this.addEventListener()
            
        }
    }
}