/**
 * Copyright feeyar ( http://wonderfl.net/user/feeyar )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/hGpH
 */

// forked from rettuce's BeatDrawing
package
{
    import caurina.transitions.Tweener;
    
    import com.demonsters.debugger.MonsterDebugger;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.ProgressEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.utils.ByteArray;
    
    /**
     * ...
     * @author rettuce
     * 
     */
    
    [SWF(width = 465, height = 465, backgroundColor = 0xFFFFFF, frameRate = 60)]
    
    public class Main extends Sprite
    {
        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init );
        }        
        private function init(e:Event = null ):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init );
            setStage();
            
            
            // SoundMixer
            playSoundMixer();
            
                        
            loaderInfo.addEventListener(Event.UNLOAD, function(e:Event):void {
                stage.removeEventListener(Event.RESIZE, resizeEvent);
                loaderInfo.removeEventListener(Event.UNLOAD, arguments.callee );
            });
        }        
        
        
        
        
        /* Sound Mixer */
        ///////////////////////////////////////////////////////////////////////
        
        private var _bArr:ByteArray = new ByteArray();
        private var _pArr:Array = [];
        private var _stg:Sprite;
        private var _bg:Bitmap;
        private function playSoundMixer():void
        {            
            _bg = new Bitmap();
            _bg.bitmapData = new BitmapData(stage.stageWidth, stage.stageHeight );
            addChild(_bg);
            
            _stg = new Sprite();
            _stg.x = stage.stageWidth/2;
            _stg.y = stage.stageHeight/2;
            addChild(_stg);            
            
            for(var i:int=0; i<512; i++){
                _pArr[i] = new Point();
            }
            
            var sound:Sound = new Sound(new URLRequest('http://rettuce.com/src/wonderfl/kasana.mp3'), new SoundLoaderContext(1, true));
            sound.addEventListener(IOErrorEvent.IO_ERROR, errorHandler );
            sound.addEventListener ( ProgressEvent.PROGRESS, function(e:ProgressEvent):void {
                txt.text =  "Now loading... "+Math.floor(e.bytesLoaded / e.bytesTotal * 100) + "%";
            });
            sound.addEventListener(Event.COMPLETE, function(e:Event):void {
                sound.removeEventListener(ProgressEvent.PROGRESS, function(e:ProgressEvent):void {
                    txt.text =  Math.floor(e.bytesLoaded / e.bytesTotal * 100) + "%";
                });
                removeChild(txt);                
                sound.play();
                addEventListener( Event.ENTER_FRAME, beatCheck2 );
            });
            
            var txt:TextField = new TextField();
            txt.width = 120;
            txt.x = stage.stageWidth / 2 -60;
            txt.y = stage.stageHeight / 2-20;
            addChild(txt);
        }
        
        private function beatCheck2(e:Event):void
        {
            SoundMixer.computeSpectrum(_bArr, false, 0);    //　byteArr(length=512), FFT, rate 0->44.1 KHz, 1->22.05KHz...
            _bArr.position = 0;
            
            var byteTotal:Number = 0;    // 両音
            var totalR:Number    = 0;    // 右パン
            var totalL:Number    = 0;    // 左パン
            var byte:Number      = 0;
            
            for(var i:int = 0; i < 512; i++)
            {
                byte = Math.abs(_bArr.readFloat());
                byteTotal += byte;
                
                if(i<256) totalR += byte;
                else totalL += byte;
                                
                if(byte>0.1)
                {
                    Tweener.addTween( _pArr[i], { 
                        x:Math.cos((i*360/512-90)*Math.PI/180)*400*(byte-0.05),
                        y:Math.sin((i*360/512-90)*Math.PI/180)*400*(byte-0.05),
                        time:0.2, transition:'easeOutQuad'
                    });
                };
            };            
            
            _stg.graphics.clear();
            _stg.graphics.lineStyle(0.5,0x000000 );
            _stg.graphics.beginFill(0xFFFFFF*Math.random());
            _stg.graphics.moveTo(_pArr[0].x,_pArr[0].y);
            for(var m:int=0; m<_pArr.length-1; m++){
                var px:Number = (_pArr[m].x + _pArr[m+1].x)/2;
                var py:Number = (_pArr[m].y + _pArr[m+1].y)/2;                
                _stg.graphics.curveTo(_pArr[m].x, _pArr[m].y, px, py);
            }
            _stg.graphics.lineTo(_pArr[_pArr.length-1].x, _pArr[_pArr.length-1].y );
            _stg.graphics.lineTo(_pArr[0].x,_pArr[0].y);            
            _stg.graphics.endFill();
            
            // 音の平均値
            byteTotal /= 512;
            
            // 左右パン平均値
            totalR /= 256; 
            totalL /= 256;             

            if(byteTotal>0.1){
                _bg.bitmapData.draw( stage );
            }
            
            var bmd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x11FFFFFF );
            _bg.bitmapData.draw( bmd );            
        }
        
        
        
        
        
        
            
        
        
        
        
        
        
        
        
        
        /* Error Handler */
        //////////////////////////////////////////////////////////////////
        
        private function errorHandler(e:IOErrorEvent):void
        {
            MonsterDebugger.trace( 'Error...', e );
        }
        
        
        /* stage set */
        //////////////////////////////////////////////////////////////////
        
        private function setStage():void
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.RESIZE, resizeEvent);
            resizeHandler();
        }
        private function resizeEvent(e:Event = null):void
        {
            resizeHandler();
        }        
        public function resizeHandler():void
        {
            
        }

    }
}