/**
 * Copyright plus-tic ( http://wonderfl.net/user/plus-tic )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hGgX
 */

// forked from TFB's Box2D練習
//ActionScript入門Wiki@rsakaneで真似しながら勉強させていただきました。
package {
	import Box2D.Collision.Shapes.b2CircleDef;
	import Box2D.Collision.Shapes.b2PolygonDef;
	import Box2D.Dynamics.b2Body;
	import Box2D.Dynamics.b2BodyDef;
    import flash.display.Sprite;
	import flash.events.Event;
	import Box2D.Collision.b2AABB;
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Collision.b2AABB;
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2DebugDraw;
	import Box2D.Dynamics.b2World;
	//目がチカチカしないように背景の色変える。
	[SWF(backgroundColor="0x333333")]
	
    public class Main extends Sprite {
		private var world:b2World;
		
        public function Main() {
			//物理演算を適用する範囲を指定
			var worldAABB:b2AABB = new b2AABB();
			//左上位置x,y(やや大きめに範囲を取る)
			worldAABB.lowerBound.Set( -100, -100);
			//右下位置x, y(やや大きめに範囲を取る)
			worldAABB.upperBound.Set(stage.stageWidth +100, stage.stageHeight +100);
			
			//重力(加速度)の設定
			var gravity:b2Vec2 = new b2Vec2(0, 100);
			//範囲と重力を適用させるために、b2Wroldのコンストラクタに値を指定
			world = new b2World(worldAABB, gravity, true);
			
			//描画
			var draw:b2DebugDraw = new b2DebugDraw();
			//Mainクラスに描画したいのでthis
			draw.m_sprite = this;
			//m_drawScale　1メートル = 何pxになるのかを比率で指定します。 
			draw.m_drawScale = 1;
            draw.m_drawFlags = b2DebugDraw.e_shapeBit;
			world.SetDebugDraw(draw);
			
			//床の設定
			var floorDef:b2BodyDef = new b2BodyDef();
			floorDef.position.Set(stage.stageWidth / 2, stage.stageHeight / 2);
			
			var floorShape:b2PolygonDef = new b2PolygonDef();
			floorShape.SetAsBox(100, 10);
			
			var floorBody:b2Body = world.CreateBody(floorDef);
			floorBody.CreateShape(floorShape);
			//床の設定終わり
			
			//重力で動くボールの設定
			var circleDef:b2BodyDef = new b2BodyDef();
			circleDef.position.Set(stage.stageWidth / 2 , 0);
			
			var circleShape:b2CircleDef = new b2CircleDef();
			circleShape.radius = 10; //半径
			circleShape.density = 100; //密度（重さ）
			circleShape.restitution = 0.5; //反発係数
			
			var circleBody:b2Body = world.CreateBody(circleDef);
			circleBody.CreateShape(circleShape);
			circleBody.SetMassFromShapes(); //重力の影響を受ける設定
			
			addEventListener(Event.ENTER_FRAME, onEnter);
        }
		private function onEnter(e:Event):void {
			world.Step(1 / stage.frameRate, 10);
		}
    }
}