/**
 * Copyright djankey ( http://wonderfl.net/user/djankey )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hGfg
 */

package 
{
    import away3d.cameras.*;
    import away3d.containers.*;
    import away3d.materials.*;
    import away3d.primitives.*;
    import away3d.core.clip.*;
    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Vector3D;    
    
    import net.hires.debug.Stats;
    
    /**
     * ...
     * @author djankey
     */
    public class Main extends Sprite 
    {
        private var camera : Camera3D;
        protected var _view : View3D;
        protected var _cube1 : Cube;
        protected var _cube2 : Cube;

        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            _createView();
            _createScene();
            _createCamera();
            
            addChild(new Stats());
        }
                
        protected function _createView() : void
        {
            // Create view and add it to the stage
            _view = new View3D();
            addChild(_view);
            
            //Relocate center point of view
            _view.x = 230;
            _view.y = 230;            
            
            //call the view render method on every frame of the Flash movie
            addEventListener(Event.ENTER_FRAME, _onEnterFrame);
        }
        
        protected function _createScene() : void
        {
            // Create a new scene containing a trident and two cubes
            var scene : Scene3D = new Scene3D();
            
            var trident : Trident = new Trident(250, true);
            
            _cube1 = new Cube();
            _cube1.x = -100;
            _cube1.material = new WireColorMaterial(0xFFFFFF);            
                    
            _cube2 = new Cube();
            _cube2.x = 100;
            _cube2.material = new WireColorMaterial(0x888888);
            
            scene.addChild(trident);
            scene.addChild(_cube1);
            scene.addChild(_cube2);
            
            
            //Assign the new scene to the view
            _view.scene = scene;
        }
        
        protected function _createCamera() : void
        {
            // BASIC CAMERA
            // Create a new camera object
            camera = new Camera3D();
            camera.x = 0;
            camera.y = 0;
            camera.z = -1000;
            
            //set the zoom and focus properties
            camera.zoom = 10;
            camera.focus = 100;
            
            //Use lookAt() to point the camera towards the center of the scene
            //camera.lookAt(new Vector3D(0, 0, 0));
            
            //Assign the new camera to the view
            _view.camera = camera;
        }
        
        protected function _onEnterFrame(ev : Event) : void
        {
            _cube1.rotationX += 1;
            
            // mouse camera
            _view.camera.y = -(stage.mouseY - stage.stageHeight/2);
            _view.camera.x = stage.mouseX - stage.stageWidth / 2;
            
            _view.render();
        }
        
    }
    
}