/**
 * Copyright bioRex21 ( http://wonderfl.net/user/bioRex21 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hGRU
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class PixelTrail extends Sprite 
    {
        // Sprite to draw on
        private var _canvas:Canvas;
        
        public function PixelTrail() 
        {
             _canvas = new Canvas();
            addChild(_canvas);
            
            _canvas.addMovingPixel(100, 100);
            
            this.addEventListener(Event.ENTER_FRAME, update);
            
            stage.addEventListener(MouseEvent.CLICK, onClick);
            
            
        }
        
        //adds three MovingPixel's 
        private function onClick(e:MouseEvent):void 
        {
            _canvas.addMovingPixel(e.stageX, e.stageY);
            
        }
        
        private function update(e:Event):void 
        {
            
            _canvas.update();
        }
        
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.geom.ColorTransform;
import flash.geom.Point;
import flash.geom.Rectangle;
    
   
class Canvas extends Bitmap 
{
        
    private var _movingPixelsVec:Vector.<MovingPixel> = new Vector.<MovingPixel>();
    private var _totalAgents:Number;
        
    private var bmData:BitmapData;
        
        
    public function Canvas() 
    {
       super();
           
        bmData = new BitmapData(800, 600, false, 0x000000);
        this.bitmapData = bmData;
            
    }
    
        
    public function addMovingPixel(xCoord:Number, yCoord:Number, color:uint = 0xfff00f):void 
    {
        _movingPixelsVec.push( new MovingPixel(xCoord, yCoord, Math.random() * 0xFFFFFF) );
        _movingPixelsVec.push( new MovingPixel(xCoord, yCoord, Math.random() * 0xFFFFFF) );
        _movingPixelsVec.push( new MovingPixel(xCoord, yCoord, Math.random() * 0xFFFFFF) );
        _totalAgents = _movingPixelsVec.length;
    }
        
    public function update():void 
    {
        bmData.lock();
            
        for (var i:int = 0; i < _totalAgents; i++) 
        {
            _movingPixelsVec[i].update();
                
                
            bmData.setPixel(_movingPixelsVec[i].x, _movingPixelsVec[i].y, _movingPixelsVec[i].color);
                
        }
        
        bmData.unlock();
            
            
            
    }
        
}

    
class MovingPixel 
{
    private var _x:Number;
    private var _y:Number;
    private var _startY:Number;
    private var _color:uint;
    private var _direction:String;
        
    private var _propertyToUpdate:Number;
    private var _currentlyUpdated:Number;
    private var _currentlyUpdatedIsX:Boolean = true;
    private var _nextCounter:Number;
    private var _xIncrem:Number = 0;
    private var _yIncrem:Number = 0;
        
    public function MovingPixel(startX:Number, startYCoord:Number, pixelColor:uint) 
    {
        _x = startX;
        _y = startYCoord;
        _startY = startYCoord;
        _color = pixelColor;
            
        _currentlyUpdated  = _x;     
                
        _nextCounter = 0;
    }
        
    public function update():void 
    {
        // movement bounds, so the don't go offscreen
           
        if (_x < 465 && _y < 465)
        {    
                
            _nextCounter++;
            
            //every 21 frames randomly changes direction
            if (_nextCounter < 21)
            {
                if (_nextCounter == 1)
                    _xIncrem = getIncrem();
                        
                _x += _xIncrem;
            }
                
                
            if (_nextCounter >= 21)
            {
                if (_nextCounter == 21)
                    _yIncrem = getIncrem();
                        
                _y += _yIncrem;
                    
            }
                    
            if (_nextCounter == 41)
                _nextCounter = 0;
                    
                
        }
                    

            
    }
      
    //form choosing a random value to change direction  
    private function getIncrem():Number 
    {
        var val:Number = 1;
            
        if (Math.random() < 0.5)
            val = -1;
                
        return val;           
            
    }
        
    public function get color():uint 
    {
        return _color;
    }
        
    public function set color(value:uint):void 
    {
            _color = value;
    }
        
    public function get y():Number 
    {
        return _y;
    }
        
    public function set y(value:Number):void 
    {
        _y = value;
    }
        
    public function get x():Number 
    {
        return _x;
    }
        
    public function set x(value:Number):void 
    {
        _x = value;
    }
        
}