/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hGKy
 */

package {
//    import aquioux.display.colorUtil.CycleRGB;
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]
    /**
     * 蜘蛛のマンデルブロ集合の描画
     * @see    http://aquioux.net/blog/?p=1890
     * @author Aquioux(Yoshida, Akio)
     */
    public class Main extends Sprite {
        // マンデルブロ集合でない部分の色
        private var colors0_:Vector.<uint>;
        private var colors1_:Vector.<uint>;
        private var colors2_:Vector.<uint>;
        private var colors3_:Vector.<uint>;
        private var colors4_:Vector.<uint>;
        
        // 表示用 BitmapData
        private var bmd_:BitmapData;
        // 走査クラス
        private var scan_:Scan;
        // 計算クラス
        private var mandelbrot_:Mandelbrot;
        
        private var rect_:Rectangle;
        

        public function Main():void {
            // カラーセットパターン1
            colors0_ = new Vector.<uint>();
            for (var i:int = 0; i < 50; i++) colors0_[i] = i % 2 ? 0xFFFFFF : 0x0;
            colors0_.fixed = true;

            // カラーセットパターン2
            colors1_ = new Vector.<uint>();
            var degree:int = 0x33;
            var step:Number = 0xFF / degree;
            for (i = 0; i < degree; i++) {
                var c:uint = step * i;
                colors1_[i] = c << 16 | c << 8 | c;
            }
            colors1_.fixed = true;
            
            // カラーセットパターン3
            colors2_ = new Vector.<uint>();
            degree = 0x33;
            step = 0xFF / degree;
            for (i = 0; i < degree; i++) {
                c = step * i;
                colors2_[i] = 0xFF << 16 | c << 8 | c;
            }
            colors2_.fixed = true;
            
            // カラーセットパターン4
            var rgb:Vector.<uint> = Vector.<uint>([0xFFFF00, 0x00FFFF, 0xFF00FF]);
            colors3_ = new Vector.<uint>();
            degree = 51;
            for (i = 0; i < degree; i++) {
                colors3_[i] = rgb[i % 3];
            }
            colors3_.fixed = true;
            
            // カラーセットパターン5
            colors4_ = new Vector.<uint>();
            degree = 45;
            step = 360 / degree;
            for (i = 0; i < degree; i++) colors4_[i] = CycleRGB.getColor(i * step + 180);
            colors4_.reverse();
            colors4_.fixed = true;

            // ステージサイズ
            var w:int = stage.stageWidth;
            var h:int = stage.stageHeight;

            // Viewer の作成
            bmd_ = new BitmapData(w, h, false, 0x0);
            addChild(new Bitmap(bmd_));
            rect_ = new Rectangle(0, 0, w, h);
            
            // ボタンの作成
            var buttonWidth:int = 60;
            var button0:PushButton = new PushButton(this, 0,                0, "B/W",       button0Handler);
            var button1:PushButton = new PushButton(this, buttonWidth,      0, "monochome", button1Handler);
            var button2:PushButton = new PushButton(this, buttonWidth * 2,  0, "monotone",  button2Handler);
            var button3:PushButton = new PushButton(this, buttonWidth * 3,  0, "3 tone",    button3Handler);
            var button4:PushButton = new PushButton(this, buttonWidth * 4,  0, "colorful",  button4Handler);
            var button5:PushButton = new PushButton(this, 0,               20, "* 1",       button5Handler);
            var button6:PushButton = new PushButton(this, buttonWidth,     20, "* 2",       button6Handler);
            var button7:PushButton = new PushButton(this, buttonWidth * 2, 20, "* 10",      button7Handler);
            var button8:PushButton = new PushButton(this, buttonWidth * 3, 20, "* 25",      button8Handler);
            var button9:PushButton = new PushButton(this, buttonWidth * 4, 20, "* 50",      button9Handler);
            button0.width = buttonWidth;
            button1.width = buttonWidth;
            button2.width = buttonWidth;
            button3.width = buttonWidth;
            button4.width = buttonWidth;
            button5.width = buttonWidth;
            button6.width = buttonWidth;
            button7.width = buttonWidth;
            button8.width = buttonWidth;
            button9.width = buttonWidth;
            
            // MandelBrot クラスのセットアップ
            mandelbrot_ = new Mandelbrot();
            // Scan クラスのセットアップ
            scan_ = new Scan();
            scan_.minX = Mandelbrot.MIN_X;
            scan_.maxX = Mandelbrot.MAX_X;
            scan_.minY = Mandelbrot.MIN_Y;
            scan_.maxY = Mandelbrot.MAX_Y;
            scan_.calculator = mandelbrot_;
            scan_.setup(w, h);
            
            // 初回状態の表示
            button4Handler(null);
        }
        
        
        // 描画
        private function draw():void {
            bmd_.lock();
            bmd_.setVector(rect_, scan_.update());
            bmd_.unlock();
        }
        
        
        // ボタンハンドラ
        private function button0Handler(e:Event):void {
            mandelbrot_.colors = colors0_;
            draw();
        }
        private function button1Handler(e:Event):void {
            mandelbrot_.colors = colors1_;
            draw();
        }
        private function button2Handler(e:Event):void {
            mandelbrot_.colors = colors2_;
            draw();
        }
        private function button3Handler(e:Event):void {
            mandelbrot_.colors = colors3_;
            draw();
        }
        private function button4Handler(e:Event):void {
            mandelbrot_.colors = colors4_;
            draw();
        }
        private function button5Handler(e:Event):void {
            scan_.scale   = 1.0;
            scan_.offsetX = 0.0;
            scan_.offsetY = 0.0;
            draw();
        }
        private function button6Handler(e:Event):void {
            scan_.scale   = 2.0;
            scan_.offsetX = -0.5;
            scan_.offsetY = 0.0;
            draw();
        }
        private function button7Handler(e:Event):void {
            scan_.scale   = 10.0;
            scan_.offsetX = -0.8;
            scan_.offsetY = 0.12;
            draw();
        }
        private function button8Handler(e:Event):void {
            scan_.scale   = 25.0;
            scan_.offsetX = -0.9;
            scan_.offsetY = 0.15;
            draw();
        }
        private function button9Handler(e:Event):void {
            scan_.scale   = 50.0;
            scan_.offsetX = -0.92;
            scan_.offsetY = 0.2;
            draw();
        }
    }
}


//package {
    /**
     * 二次元走査クラス
     * @author Aquioux(Yoshida, Akio)
     */
    /*public*/ class Scan {
        /**
         * 計算クラス
         */
        private var _calculator:ICalculator;
        public function set calculator(value:ICalculator):void { _calculator = value; }
        
        // ----- 描画領域範囲 -----
        /**
         * 描画領域のX軸最小値（_scale = 1.0 における値）
         */
        private var _minX:Number;
        public function set minX(value:Number):void {
            _minX = value;
            calcWidth();
        }
        /**
         * 描画領域のX軸最大値（_scale = 1.0 における値）
         */
        private var _maxX:Number;
        public function set maxX(value:Number):void {
            _maxX = value;
            calcWidth();
        }
        /**
         * 描画領域のY軸最小値（_scale = 1.0 における値）
         */
        private var _minY:Number;
        public function set minY(value:Number):void {
            _minY = value;
            calcHeight();
        }
        /**
         * 描画領域のY軸最大値（_scale = 1.0 における値）
         */
        private var _maxY:Number;
        public function set maxY(value:Number):void {
            _maxY = value;
            calcHeight();
        }
        
        /**
         * スケール値
         */
        public function set scale(value:Number):void {
            _scale = value;
            calcValue();
        }
        private var _scale:Number = 1.0;

        /**
         * 表示位置オフセットX座標値
         */
        public function set offsetX(value:Number):void {
            _offsetX = value;
            calcStartX();
        }
        private var _offsetX:Number = 0.0;
        /**
         * 表示位置オフセットY座標値
         */
        public function set offsetY(value:Number):void {
            _offsetY = value;
            calcStartY();
        }
        private var _offsetY:Number = 0.0;
        

        // ----- その他変数 -----
        // 計算領域
        private var calculateWidth_:Number;    // 幅
        private var calculateHeight_:Number;// 高
        // 計算領域の中心
        private var centerX_:Number;        // X座標
        private var centerY_:Number;        // Y座標
        // 計算加算値
        private var stepX_:Number;            // X軸
        private var stepY_:Number;            // Y軸
        // 走査開始座標
        private var startX_:Number;            // X座標
        private var startY_:Number;            // Y座標

        // 表示領域
        private var displayWidth_:int;        // 幅
        private var displayHeight_:int;        // 高
        
        // ビューアへ渡すデータ
        private var data_:Vector.<uint>;
        // data_ のインデックス
        private var idx_:int;
        
        
        /**
         * 初期化
         * @param    width    表示幅
         * @param    height    表示高
         */
        public function setup(width:int, height:int):void {
            // 表示サイズ
            displayWidth_  = width;
            displayHeight_ = height;
            
            // data_ の生成
            data_ = new Vector.<uint>(width * height, true);

            // 複素数平面走査用の各変数を計算する
            calcValue();
            
            // 計算クラスのセットアップ
            if (!_calculator) new Error("setup 前に計算クラスを指定してください。");
            _calculator.setup();
        }

        /**
         * 複素数平面を走査し、その値を計算クラスの渡す
         * @return    計算クラスから返ってきた値を格納した Vector
         */
        public function update():Vector.<uint> {
            idx_ = 0;
            for (var y:int = 0; y < displayHeight_; y++) {
                for (var x:int = 0; x < displayWidth_; x++) {
                    data_[idx_++] = _calculator.calculate(startX_ + x * stepX_, startY_ + y * stepY_);
                }
            }
            return data_;
        }
        

        // 複素数平面走査用の変数を計算する
        private function calcValue():void {
            // 走査領域を計算する
            calcWidth();
            calcHeight();
            // 複素数平面走査のインクリメントステップを計算する
            calcStep();
            // 複素数平面の走査開始座標を計算する
            calcStartX();    // 実数座標
            calcStartY();    // 虚数座標
        }
        // _minX, _maxX から走査範囲幅を計算
        private function calcWidth():void {
            calculateWidth_ = _maxX - _minX;
            centerX_ = _minX + calculateWidth_ / 2;
        }
        // _minY, _maxY から走査範囲高を計算
        private function calcHeight():void {
            calculateHeight_ = _maxY - _minY;
            centerY_ = _minY + calculateHeight_ / 2;
        }
        // 複素数平面走査の計算加算値を計算する
        private function calcStep():void {
            stepX_ = calculateWidth_  / (_scale * (displayWidth_  - 1));
            stepY_ = calculateHeight_ / (_scale * (displayHeight_ - 1));
        }
        // 複素数平面の走査開始座標を計算する（実数部座標）
        private function calcStartX():void {
            startX_ = centerX_ - calculateWidth_ * 0.5 / _scale + _offsetX;
        }
        // 複素数平面の走査開始座標を計算する（虚数部座標）
        private function calcStartY():void {
            startY_ = centerY_ - calculateHeight_ * 0.5 / _scale - _offsetY;
        }
    }
//}


//package {
    /**
     * 蜘蛛のマンデルブロ集合描画クラス
     * _scale = 1.0 のとき (-2.5, -1.5) ～ (0.5, 1.5) の領域を対象に計算する
     * @author Aquioux(Yoshida, Akio)
     */
    /*public*/ class Mandelbrot implements ICalculator {
        // ----- 描画領域範囲 -----
        /**
         * 描画領域のX軸最小値
         */
        static public const MIN_X:Number = -2.5;
        /**
         * 描画領域のY軸最小値
         */
        static public const MIN_Y:Number = -1.5;
        /**
         * 描画領域のX軸最大値
         */
        static public const MAX_X:Number =  0.5;
        /**
         * 描画領域のY軸最大値
         */
        static public const MAX_Y:Number =  1.5;

        // ----- 色 -----
        /**
         * ジュリア集合に該当する部分の色（一般的には色なし＝黒）
         */
        public function set color(value:uint):void { _color = value; }
        private var _color:uint = 0x000000;
        /**
         * 発散部分の色階調
         */
        public function set colors(value:Vector.<uint>):void {
            _colors = value;
            degree_ = value.length;
        }
        private var _colors:Vector.<uint>;


        // 発散チェックループ回数（_colors.length の値）
        private var degree_:int;


        /**
         * 初期化
         */
        public function setup():void {
            // 発散時の色が外部から指定されていなければ設定する
            if (!_colors) {
                var len:int = 256;
                _colors = new Vector.<uint>(len, true);
                for (var i:int = 0; i < len; i++) _colors[i] = i << 16 | i << 8 | i;
                degree_ = len;
            }
        }


        /**
         * Scan クラスからの走査データを受け、計算をおこなう
         * @param    x    X座標値
         * @param    y    Y座標値
         * @return    計算結果
         */
        public function calculate(x:Number, y:Number):uint {
            var r:int = checkDivergence(0, 0, x, y);
            return (r >= 0) ? _colors[r] : _color;
        }
        /**
         * 漸化式 z ← z * z + c の評価
         * @param    zRl    複素数 z の実数部
         * @param    zIm    複素数 z の虚数部
         * @param    cRl    複素数 c の実数部
         * @param    cIm    複素数 c の虚数部
         * @return    発散評価値
         * @private
         */
        private function checkDivergence(zRl:Number, zIm:Number, cRl:Number, cIm:Number):int {
            // 漸化式の計算要素の複素数
            var zRlSqr:Number;        // 実数部の2乗
            var zImSqr:Number;        // 虚数部の2乗
            // 漸化式の計算結果の複素数
            var zRlNxt:Number;        // 実数部
            var zImNxt:Number;        // 虚数部
            
            var i:int = degree_;
            while (i--) {
                // 発散の評価（|z| > 2 = |z|^2 > 4）
                zRlSqr = zRl * zRl;
                zImSqr = zIm * zIm;
                if (zRlSqr + zImSqr > 4) break;
                
                // 発散していなかった場合、漸化式実行
                zRlNxt = zRlSqr - zImSqr + cRl;
                zImNxt = 2 * zRl * zIm   + cIm;
                zRl = zRlNxt;
                zIm = zImNxt;
                
                // 複素数 c の値を更新（c_n+1 ← c_n / 2 + z_n+1）
                cRl /= 2;
                cIm /= 2;
                cRl += zRl;
                cIm += zIm;
            }
            return i;
            // break で脱しなかった（発散しなかった）場合、while を回りきるので -1 になる
        }
    }
//}


//package {
    /**
     * interface
     * @author YOSHIDA, Akio (Aquioux)
     */
    /*public*/ interface ICalculator {
        function setup():void;
        function calculate(x:Number, y:Number):uint;
    }
    
//}


//package aquioux.display.colorUtil {
    /**
     * コサインカーブで色相環的な RGB を計算
     * @author Aquioux(YOSHIDA, Akio)
     */
    /*public*/ class CycleRGB {
        /**
         * 32bit カラーのためのアルファ値（0～255）
         */
        static public function get alpha():uint { return _alpha; }
        static public function set alpha(value:uint):void {
            _alpha = (value > 0xFF) ? 0xFF : value;
        }
        private static var _alpha:uint = 0xFF;
    
        private static const PI:Number = Math.PI;        // 円周率
        private static const DEGREE120:Number  = PI * 2 / 3;    // 120度（弧度法形式）
        
        /**
         * 角度に応じた RGB を得る
         * @param    angle    HSV のように角度（度数法）を指定
         * @return    色（0xNNNNNN）
         */
        public static function getColor(angle:Number):uint {
            var radian:Number = angle * PI / 180;
            var r:uint = (Math.cos(radian)             + 1) * 0xFF >> 1;
            var g:uint = (Math.cos(radian + DEGREE120) + 1) * 0xFF >> 1;
            var b:uint = (Math.cos(radian - DEGREE120) + 1) * 0xFF >> 1;
            return r << 16 | g << 8 | b;
        }
        
        /**
         * 角度に応じた RGB を得る（32bit カラー）
         * @param    angle    HSV のように角度（度数法）を指定
         * @return    色（0xNNNNNNNN）
         */
        public static function getColor32(angle:Number):uint {
            return _alpha << 24 | getColor(angle);
        }
    }
//}
