/**
 * Copyright kuma360 ( http://wonderfl.net/user/kuma360 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hFxo
 */

//マンデルブロ集合
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.getTimer;
                            
    [SWF(frameRate ="30")]
    public class Main extends Sprite 
    {
        /////////////////////////////
        private var _canvas:BitmapData;
        
        /////////////////////////////
        private var widthX:Number = 465;
        private var heightY:Number = 465;
        private var X:Number = 0;
        private var Y:Number = 0;
        private var REP:Number = 250;            //精度
        private var ZOOM:Number = 1;            //拡大率
        private var SCALE:Number = 3 / ZOOM;    //描画範囲
        private var step:Number = Math.abs(SCALE / widthX);
        private var offset:Number = 0 ;

        /////////////////////////////
        //複素数用
        private var CR:Number = -1.94;    //実数範囲
        private var CI:Number = -1.3;    //虚数範囲
        private var a:Number = CR;
        private var b:Number = CI;

        /////////////////////////////
        //計算回数
        private var n:Number = 0;
        
        public function Main():void 
        {
            _canvas = new BitmapData ( 465 , 465 , false , 0 ) ;
            addChild ( new Bitmap ( _canvas ) ) ;
            
            addEventListener ( 
                Event.ENTER_FRAME ,
                function ( e:Event ):void {
                    
                  var T:int = getTimer();
                    while ( getTimer() - T < 30 ) {
                    
                        if (Y > heightY) {
                            ZOOM *= 2 ;
                            SCALE = 2.6 / ZOOM;
                            step = Math.abs(SCALE / widthX);
                            CR *= 0.5 ;
                            CI *= 0.5 ;
                            a = CR ;
                            b = CI ;
                            n = 0;
                            X = 0 ;
                            Y = 0 ;
                            offset += CR ;
                        }
                        
                        if (X > widthX) {
                            X = 0;
                            Y ++;
                            a = CR;
                            b += step;
                        }
                        
                        X ++;
                        a += step;
                        
                        {
                            var tx:Number = 0;
                            var ty:Number = 0;
                            var zx:Number = 0;
                            var zy:Number = 0;
                            
                            n = 0;
                            do {
                                tx = zx*zx-zy*zy+a + offset ;
                                ty = 2*zx*zy+b ;
                                zx = tx;
                                zy = ty;
                                if ((zx*zx+zy*zy)>4) { break; }
                            } while ( ++ n < REP ) ;
                            
                            var R:uint = ( ( REP - n ) ) & 0xFF ;
                            var G:uint = ( ( REP - n ) ) & 0xFF ;
                            var B:uint = ( ( REP - n ) ) & 0xFF ;
                            var C:uint = ( R << 16 << 4 ) | ( G << 8 << 3 ) | ( B << 2 ) ;
                            _canvas.setPixel( X, Y, C );
                        }
                        
                    }
                                        
                }
            );
            
        }
    }
    
}
