/**
 * Copyright shunnakamura ( http://wonderfl.net/user/shunnakamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hFkH
 */

// forked from esukei's HighSpeed Dog RGB Separator
// forked from yanbaka's Dog RGB Separator
// forked from clockmaker's RGB Separater
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.display.Loader;
        import flash.system.LoaderContext;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.Security;
    
    
    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "60")]
    /**
     * 結構前に投稿されたのをほじくり返して勉強用に作成。
     * ↓参考にさせていただきました。
     * http://wonderfl.net/code/381f195b4aad8c2a14fc00ad03f638df25568a5d
     * 
         * @author esukei
         * 回転速度を上げてみた。
         * カーソルを中央付近に持ってくると陽炎っぽい。
         */
    public class DogRGBSeparator extends Sprite
    {
        private const WIDTH:Number = stage.stageWidth;
        private const HEIGHT:Number = stage.stageHeight;
        private const IMG_PATH:String = "http://farm6.static.flickr.com/5046/5354793595_53c2df531a_z.jpg";
        
        private var max:Number;
        private var bmps:Array = [];
        private var speeds:Array = [];
        private var flg:Boolean = false;
        
        public function DogRGBSeparator()
        {
   
                        Security.loadPolicyFile("http://5ivestar.org/proxy/crossdomain.xml");
            var dx:Number = WIDTH - WIDTH/2;
            var dy:Number = HEIGHT - HEIGHT/2;
            max = Math.sqrt(dy*dy+dx*dx);            
             
            loadImage();
        }
        
        private function loadImage():void
        {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
                        var context:LoaderContext = new LoaderContext(true);
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
            loader.load(new URLRequest("http://5ivestar.org/proxy/"+IMG_PATH),context);
        }
        
        private function onComplete(e:Event):void
        {
            var loader:Loader = Loader(e.target.loader);
            var rgb:Array = createRGB(Bitmap(loader.content));
            
            var l:int = rgb.length;
            for (var i:int=0; i<l; i++)
            {
                var radius:Number = i/l*Math.PI*2;
                speeds.push(radius);
                
                var bmp:Bitmap = new Bitmap(rgb[i]);
                bmp.blendMode = BlendMode.SCREEN;
                bmp.scaleX = bmp.scaleY = 0.5;
                addChild(bmp);
                bmps.push(bmp);
            }
            
            var center:Shape = new Shape();
            center.graphics.lineStyle(1, 0xFF0000);
            center.graphics.moveTo(-5, -5);
            center.graphics.lineTo(5, 5);
            center.graphics.moveTo(5, -5);
            center.graphics.lineTo(-5, 5);
            center.graphics.endFill();
            center.x = WIDTH/2;
            center.y = HEIGHT/2;
            addChild(center);
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void
        {
            var dx:Number = mouseX - WIDTH/2;
            var dy:Number = mouseY - HEIGHT/2;
            var dist:Number = Math.sqrt(dy*dy+dx*dx);
            var spd:Number = WIDTH/2 - dist;
            var radius:Number = dist;
            var sc:Number = 1-dist/max;
            
            var l:int = bmps.length;
            for(var i:int=0; i<l; i++)
            {
                var bmp:Bitmap = bmps[i];
                bmp.scaleX = bmp.scaleY = sc;
                speeds[i] += spd;
                var xx:Number = (WIDTH-bmp.width)/2;
                var yy:Number = (HEIGHT-bmp.height)/2;
                bmp.x = Math.cos(speeds[i])*radius+xx;
                bmp.y = Math.sin(speeds[i])*radius+yy;
            }
        }
        
        private function createRGB(bmp:Bitmap):Array
        {
            var r:BitmapData = new BitmapData(bmp.width, bmp.height, true, 0xFF000000);
            var g:BitmapData = new BitmapData(bmp.width, bmp.height, true, 0xFF000000);
            var b:BitmapData = new BitmapData(bmp.width, bmp.height, true, 0xFF000000);
            r.copyChannel(bmp.bitmapData, bmp.bitmapData.rect, new Point(), BitmapDataChannel.RED, BitmapDataChannel.RED);
            g.copyChannel(bmp.bitmapData, bmp.bitmapData.rect, new Point(), BitmapDataChannel.GREEN, BitmapDataChannel.GREEN);
            b.copyChannel(bmp.bitmapData, bmp.bitmapData.rect, new Point(), BitmapDataChannel.BLUE, BitmapDataChannel.BLUE);
            
            return [r, g, b];
        }
    }
}