/**
 * Copyright esukei ( http://wonderfl.net/user/esukei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hFb8
 */

// forked from KonKiKi's バネる
// 動きがとても気に入ったのでForkしながら分析してみる。
package{
    import flash.display.*;
    
    public class BaneBane extends Sprite{
        
        //ボールのかず
        private var n:uint = 1000;
        //きっとバネ定数
        private var springConst:Number = 0.3;
        //コレは何だろう？抵抗とかかな？1.0で止まらなくなるし
        private var damp:Number = 0.8;
        
        function BaneBane(){
            for(var i:uint=0; i<n; i++){
                var myX:Number = Math.random() * stage.stageWidth;
                var myY:Number = Math.random() * stage.stageHeight;
            
                var ball:Ball = new Ball(springConst,damp,myX,myY)
                stage.addChild(ball);
            }
        }
    }     
}

import flash.display.*;
import flash.events.*;
class Ball extends Sprite{
    
    private var _sp:Number;
    private var _damp:Number;
    //
    private var _myX:Number;
    private var _myY:Number;
    //初期位置
    private var _tagX:Number;
    private var _tagY:Number;
    //
    private var _xVal:Number;
    private var _yVal:Number;
    //閾値追加
    private var threshold:Number = 160;
    
    function Ball(s:Number,d:Number,tx:Number,ty:Number){
        _sp = s;
        _damp = d;
        this.x = _myX = _tagX = tx;
        this.y = _myY = _tagY = ty;
        _xVal = _yVal = 0;
        
        this.graphics.beginFill(0x00CCFF,1);
        this.graphics.drawCircle(0,0,.5);
        this.graphics.endFill();
        
        this.addEventListener(Event.ENTER_FRAME,onLoop,false,0,true);
    }
    
    private function onLoop(eventObj:Event):void {
        //初期位置からマウスまでの距離検出
        var xx:Number = _tagX - stage.mouseX;
        var yy:Number = _tagY - stage.mouseY;
        var DIST:Number = Math.sqrt( xx * xx + yy * yy );
        
        //距離が閾値未満の処理
        if(DIST < threshold){
            //マウスに対しての角度
            var ANGLE:Number = Math.atan2( yy, xx );
            //ここはなんだろう？-今日の解析ここまで！
            var LENG:Number = (50/ (150 * 150)) * (DIST - 150) * (DIST - 150);
            //LENG = DIST;
            
            _myX = _tagX + LENG * Math.cos(ANGLE);
            _myY = _tagY + LENG * Math.sin(ANGLE);
            
            //this.scaleX = this.scaleY = LENG / 50 * 10 + 1;
            this.scaleX = this.scaleY = 10;
        }else {
            this.scaleX = this.scaleY = 10;
            _myX = _tagX;
            _myY = _tagY;
        }
        _xVal = valElastic(this.x,_myX,_xVal);
        _yVal = valElastic(this.y,_myY,_yVal);
        this.x += _xVal;
        this.y += _yVal;
    }
    
    private function valElastic(orig:Number,dist:Number,elas:Number):Number {
        elas += -_sp * (orig - dist);
        return elas *= _damp;
    }
    
}