/**
 * Copyright k__ ( http://wonderfl.net/user/k__ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hFRY
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.utils.*;
	
	public class Main extends Sprite {
		private var bg:Shape;
		private var canvas:Vector.<Shape>;
		private var colors:Array = [0xff0000, 0x3399ff];
		private var cx:Number,cy:Number;
		private var verts:Vector.<Number>;
		private var pVerts:Vector.<Number>;
		private var uvts:Vector.<Number>;
		private var pmtx:Matrix3D;
		private var pers:PerspectiveProjection;
		private var xr:Number = 0, yr:Number = 0;
		private var points:Array = 
		[[-50,-50, -50], [50,-50,-50], [50,50,-50], [-50, 50, -50], [-50,-50, 50], [50,-50, 50], [50,50, 50], [-50, 50, 50]];
		private var lines:Array =
		[[0,1],[1,2],[2,3],[3,0],[4,5],[5,6],[6,7],[7,4],[0,4],[1,5],[2,6],[3,7]];
		
		
		public function Main() {
			cx = stage.stageWidth / 2;
			cy = stage.stageWidth / 2;
			verts = new Vector.<Number>();
			pVerts = new Vector.<Number>();
			pmtx = new Matrix3D();
			pers = new PerspectiveProjection();
			uvts = new Vector.<Number>();
			
			addChild(bg = new Shape);
			bg.graphics.beginFill(0x000000);
			//bg.graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
			bg.graphics.endFill();
			canvas = new Vector.<Shape>;
			canvas.push(new Shape());
			canvas.push(new Shape());
			addChild(canvas[0]);
			addChild(canvas[1]);
			addEventListener(Event.ENTER_FRAME, h_enterframe);
		}
		
		private function h_enterframe(evt:Event):void {
			yr += (cx - mouseX) / 100;
			xr += (cy - mouseY) / 100;
			render();
		}
		
		private function render():void {
			verts = new Vector.<Number>();
			for (var i:uint = 0; i < points.length; i ++) {
				verts.push(points[i][0]);
				verts.push(points[i][1]);
				verts.push(points[i][2]);
			}
			
			pers.fieldOfView = 100;
			pmtx.identity();
			pmtx.appendRotation(xr, Vector3D.X_AXIS);
			pmtx.appendRotation(yr - 3, Vector3D.Y_AXIS);
			pmtx.appendTranslation(0, 0, pers.focalLength);
			pmtx.append(pers.toMatrix3D());
			bugfix(pmtx);
			Utils3D.projectVectors(pmtx, verts, pVerts, uvts);
			drawGraphics(canvas[0].graphics, colors[0], pVerts);
			
			pmtx.identity();
			pmtx.appendRotation(xr, Vector3D.X_AXIS);
			pmtx.appendRotation(yr + 3, Vector3D.Y_AXIS);
			pmtx.appendTranslation(0, 0, pers.focalLength);
			pmtx.append(pers.toMatrix3D());
			bugfix(pmtx);
			Utils3D.projectVectors(pmtx, verts, pVerts, uvts);
			drawGraphics(canvas[1].graphics, colors[1], pVerts);
		}
		
		private function drawGraphics(g:Graphics, c:uint, vt:Vector.<Number>):void {
			g.clear();
			g.lineStyle(0, c, 0.3);
			for (var i:uint = 0; i < lines.length; i ++) {
				
				g.moveTo(vt[lines[i][0] * 2] + cx, vt[lines[i][0] * 2 + 1] + cy);
				g.lineTo(vt[lines[i][1] * 2] + cx ,vt[lines[i][1] * 2 + 1] + cy);
				
			}
		}
		
		
		private function bugfix(matrix:Matrix3D):void {
			var m1:Matrix3D = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 1, 0 ]));
			var m2:Matrix3D = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 1,  0, 0, 0, 0 ]));
			m1.append(m2);
			if (m1.rawData[15] == 20) {
				var rawData:Vector.<Number> = matrix.rawData;
				rawData[15] /= 20;
				matrix.rawData = rawData;
			}
		}
		
	}
}