/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hFEN
 */

// forked from break's 羽ばたく蝶々のテクスチャーが上下反転する問題を回避
package {
	import alternativ5.engine3d.core.Mesh;
	import alternativ5.engine3d.core.Object3D;
	import alternativ5.engine3d.materials.*;
	import alternativ5.engine3d.primitives.*;
	import alternativ5.types.*;
	import flash.display.*;
	import flash.events.*;
	import flash.geom.Point;

	import flash.geom.Matrix;
	import flash.geom.Rectangle;

	import flash.utils.*;
	
	import flash.system.LoaderContext;
	import flash.display.Loader;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.display.BitmapData;
	import flash.display.Bitmap;

	import flash.display.Sprite;


	[SWF(width = 465, height = 465, frameRate = 60, backgroundColor="#0")]
	/**
	* Alternativa3D を簡単に扱うためのベーシックテンプレート
	* @author Yasu (clockmaker)
	*/
	
	/**
	 * バタフライ( http://clockmaker.jp/blog/2009/11/alternativa3d-demos/ ) の羽を下から見ると反転してしまう問題を
	 * primitives.Plane を利用しない方法で解決してみました。
	 */

	/**
	* バタフライ( http://clockmaker.jp/blog/2009/11/alternativa3d-demos/ ) の羽を下から見ると反転してしまう問題を
	* primitives.Plane を利用したままの方法でも、解決してみました。
	*/


	public class Main extends Sprite {
		
		private var image:BitmapData;
		private var loader:Loader;
		
		private var butterfly:Object3D;

		public function Main():void {
			loader = new Loader();
			loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/a/ac/ac09/ac09a2ffd00b54f2779ab5cc3ebfd1114e204ec1"), new LoaderContext(true));
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE,loaded);
		}
			
		private function loaded(e:Event):void{
			loader.contentLoaderInfo.removeEventListener(Event.COMPLETE,loaded);

			var template:BasicTemplate = new BasicTemplate();
			addChild(template);
			
			
			//　オブジェクトを作成します
			butterfly = createButterfly();
			
			var earth:Plane = new Plane(1000, 1000, 10, 10, false);
			earth.cloneMaterialToAllSurfaces(new WireMaterial(1, 0xFFFFFF, .5));

			// 3D表示リストに追加します
			template.scene.root.addChild(butterfly);
			template.scene.root.addChild(earth);
			

				// Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
				// レンダリング前に実行したい処理を記述します。
				template.onPreRender = function():void {

					butterfly.z = Math.sin(getTimer() / 200) * -25 + 240;
					template.camera.x = 500 * Math.sin(getTimer() / 1000);
					template.camera.y = 500 * Math.cos(getTimer() / 1000);
					var targetZ:Number = 400 * (mouseY / stage.stageHeight) + 300
					template.camera.z += (targetZ - template.camera.z) * 0.1;
					template.camera.zoom = 10 * Math.sin(getTimer() / 2000) + 40;
				
					// マウスがステージの高さ何%の位置にあるか算出
					var rateY:Number = mouseY / stage.stageHeight;

					// カメラの高さの座標を調整
					// イージングの公式 対象の値 += (目標値 - 現在の値) * 減速率
					template.camera.y += ( - 1000 * rateY - template.camera.y) * 0.1;

					// カメラの座標を中央に向かせる
					template.cameraContoller.lookAt(new Point3D());
				}
		}
		
		/**
		* 蝶を作成します
		* @return 蝶(DisplayObject3D型)
		*/
		private function createButterfly():Object3D {
			// 蝶のコンテナーを作成
			var butterfly :Object3D = new Object3D();

			// 蝶の羽を作成
			var leftWing	:Object3D = new Object3D();
			var rightWing :Object3D = new Object3D();

			// 蝶の羽の素材を作成
			var rightImage:BitmapData = new BitmapData(loader.content.width, loader.content.height, true, 0x00000000);
			var leftImage:BitmapData = new BitmapData(loader.content.width, loader.content.height, true, 0x00000000);


			//一枚の素材から使い回すため、画像を左右反転
			var mt:Matrix = new Matrix()
					mt.translate(-loader.content.width,0)
					mt.scale(-1,1)

			leftImage.draw(loader,mt);
			rightImage.draw(loader);


			var matRight:TextureMaterial = new TextureMaterial(new Texture(rightImage), 1, false, true, BlendMode.NORMAL, -1);
			matRight.precision = TextureMaterialPrecision.VERY_LOW;
			var matLeft:TextureMaterial = new TextureMaterial(new Texture(leftImage), 1, false, true, BlendMode.NORMAL, -1);
			matLeft.precision = TextureMaterialPrecision.VERY_LOW;

			// 蝶の羽を貼り付ける平面を作成
			var leftWingPlane  :Plane = new Plane(200, 200, 1, 1,true,true);
			//直接、Planeの中の裏面のFaceのUVマップを上下反転させる <----------------------------------ここがポイント！
			leftWingPlane.setUVsToFace(new Point(0, 0), new Point(0, 1), new Point(1, 1), leftWingPlane.getFaceById("back0_0"));
			leftWingPlane.cloneMaterialToAllSurfaces(matLeft);
			
			var rightWingPlane :Plane = new Plane(200, 200, 1, 1,true,true);
			//直接、Planeの中の裏面のFaceのUVマップを上下反転させる <----------------------------------ここがポイント！
			rightWingPlane.setUVsToFace(new Point(0, 0), new Point(0, 1), new Point(1, 1), rightWingPlane.getFaceById("back0_0"));
			rightWingPlane.cloneMaterialToAllSurfaces(matRight);


			/* Planeプリミティブは、front、backの２つのSurfacesで構成されています。
			** またfrontサーフェースはfront0_0、backサーフェースはback0_0というIDのFaceで作成されているようです
			** これらのフェースにはplane.getFaceById("back0_0")の形式で直接アクセスできますので、
			** 今回は、この方法で、上下反転している、back0_0フェースのUVマップを直接修正しています。
			**
			** なお、それぞれサーフェースにも
			** plane.setMaterialToSurface(img1,'front')
			** plane.setMaterialToSurface(img2,'back')
			** と個別に、TextureMaterialを指定する事もできますので、あらかじめ、Texture用の画像を、Matrixで反転させておいて、貼り付けるという手もあります。
			*/


			// 蝶の羽平面の座標や角度を調整
			leftWingPlane.x	= -100;
			rightWingPlane.x = 100;

			// 蝶の羽をコンテナーの表示リストに追加
			leftWing.addChild(leftWingPlane);
			rightWing.addChild(rightWingPlane);
			butterfly.addChild(leftWing);
			butterfly.addChild(rightWing);

			// アニメーションの設定
			addEventListener(Event.ENTER_FRAME, function(event:Event):void {
				// 羽が羽ばたく演出
				leftWing.rotationY	= (Math.sin(getTimer() / 200) * 40) * Math.PI / 180;
				rightWing.rotationY = (Math.sin(getTimer() / 200) * -40) * Math.PI / 180;
			});

			// 蝶のインスタンスを返却
			return butterfly;
		}
	}
}


/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;
class BasicTemplate extends Sprite{

		/**
		 * シーンインスタンスです。
		 */
		public var scene:Scene3D;
		/**
		 * ビューインスタンスです。
		 */
		public var view:View;
		/**
		 * カメラインスタンスです。
		 */
		public var camera:Camera3D;
		/**
		 * カメラコントローラーです。
		 */
		public var cameraContoller:CameraController;
		
		private var _viewWidth:int;
		private var _viewHeight:int;
		private var _scaleToStage:Boolean;

		/**
		 * 新しい BasicTemplate インスタンスを作成します。
		 * @param	viewWidth
		 * @param	viewHeight
		 * @param	scaleToStage
		 */
		public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
				_viewWidth = viewWidth;
				_viewHeight = viewHeight;
				_scaleToStage = scaleToStage;
				
				// Creating scene
				scene = new Scene3D();
				scene.splitAnalysis = false; // not analysis for performance
				scene.root = new Object3D();
				
				// Adding camera
				camera = new Camera3D();
				camera.z = -1000;
				scene.root.addChild(camera);
				
				// camera contoller
				cameraContoller = new CameraController(this);
				cameraContoller.camera = camera;
				
				// set view
				view = new View();
				view.camera = camera;
				addChild(view);
				
				// stage
				if (stage) init();
				else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		/**
		 * 初期化されたときに実行されるイベントです。
		 * 初期化時に実行したい処理をオーバーライドして記述します。
		 */
		protected function atInit():void {}
		
		/**
		 * 初期化されたときに実行されるイベントです。
		 * 初期化時に実行したい処理を記述します。
		 */
		private var _onInit:Function = function():void { };
		public function get onInit():Function { return _onInit; }
		public function set onInit(value:Function):void {
				_onInit = value;
		}
		
		/**
		 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
		 * レンダリング前に実行したい処理をオーバーライドして記述します。
		 */
		protected function atPreRender():void {}
		
		/**
		 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
		 * レンダリング前に実行したい処理を記述します。
		 */
		private var _onPreRender:Function = function():void{};
		public function get onPreRender():Function { return _onPreRender; }
		public function set onPreRender(value:Function):void {
				_onPreRender = value;
		}
		
		/**
		 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
		 * レンダリング後に実行したい処理をオーバーライドして記述します。
		 */
		protected function atPostRender():void {
		}
		
		/**
		 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
		 * レンダリング後に実行したい処理を記述します。
		 */
		protected var _onPostRender:Function = function():void{};
		public function get onPostRender():Function { return _onPostRender; }
		public function set onPostRender(value:Function):void {
				_onPostRender = value;
		}
		
		/**
		 * レンダリングを開始します。
		 */
		public function startRendering():void {
				addEventListener(Event.ENTER_FRAME, onRenderTick);
		}
		/**
		 * レンダリングを停止します。
		 */
		public function stopRendering():void {
				removeEventListener(Event.ENTER_FRAME, onRenderTick);
		}
		
		/**
		 * シングルレンダリング(レンダリングを一回だけ)を実行します。
		 */
		public function singleRender():void {
				onRenderTick();
		}
		
		/**
		 * @private
		 */
		private function init(e:Event = null):void {
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stage.quality = StageQuality.HIGH;

			// resize
			stage.addEventListener(Event.RESIZE, onResize);
			onResize(null);
			
			// render
			startRendering();
			
			atInit();
			_onInit();

		}
		
		/**
		 * @private
		 */
		private function onRenderTick(e:Event = null):void {
			atPostRender();
			_onPostRender();
			scene.calculate();
			atPreRender();
			_onPreRender();
		}
		
		/**
		 * @private
		 */
		private function onResize(event:Event = null):void {
			if (_scaleToStage) {
				view.width = stage.stageWidth;
				view.height = stage.stageHeight;
			}else {
				view.width = _viewWidth;
				view.height = _viewHeight;
			}
		}
}
