/**
 * Copyright IPFix ( http://wonderfl.net/user/IPFix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hEzn
 */

package 
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    /**
     * Main
     */
    public class Main extends Sprite 
    {
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            addChild(new DotBackground(3, 3, 0x444444, 0));
            addChild(new CubicScene(this));
        }
    }
}

import alternativ7.engine3d.core.MouseEvent3D;
import alternativ7.engine3d.core.Object3DContainer;
import alternativ7.engine3d.materials.FillMaterial;
import com.greensock.easing.Quad;
import com.greensock.TweenMax;
import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.ui.Mouse;
import flash.ui.MouseCursor;

/**
 * MainScene
 * add cube on z level and make connection beetween neightboors, also control the camera...
 */
class CubicScene extends Sprite 
{
    private var _scene:AlternativaTemplate;
    private var _platforms:Vector.<Vector.<PlatForm>>;
    private var startPoint:Point;
    private var startRotationZ:Number;
    private var _rootContainer:Object3DContainer;
    private var startCameraZ:Number;
    
    public function CubicScene(container:DisplayObjectContainer) 
    {
        addEventListener(Event.ADDED_TO_STAGE, onStage);
    }
    
    private function onStage(e:Event):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, onStage);
        _scene = new AlternativaTemplate(this, AlternativaTemplate.CONFLICT);
        _scene.camera.z = 300;
        _scene.camera.y = -400;
        _scene.camera.x = 800;
        _scene.camera.lookAt(0, 0, 0);
        var w:int = 5;
        var h:int = 5;
        _platforms = new Vector.<Vector.<PlatForm>>();
        _rootContainer = new Object3DContainer();
        _scene.container.addChild(_rootContainer);
        for (var z:int = 0; z < 7; z++) {
            for (var i:int = 0; i < w; i++) {
                _platforms[i] = new Vector.<PlatForm>();
                for (var j:int = 0; j < h; j++){
                    var platform:PlatForm = new PlatForm();
                    _platforms[i][j]=platform;
                    platform.x = i * 200-300;
                    platform.y = j * 200 - 200;
                    platform.z = z * 550;
                    if (i != 0 && _platforms[i-1][j]!= null) {
                        platform.addNeightboor(_platforms[i-1][j]);
                        _platforms[i - 1][j].addNeightboor(platform);
                    }
                    if (j != 0 && _platforms[i][j-1]!= null) {
                        platform.addNeightboor(_platforms[i][j-1]);
                        _platforms[i][j - 1].addNeightboor(platform);
                    }
                    _rootContainer.addChild( platform );
                }
            }
            for (var i:int = 0; i < w; i++) {
                for (var j:int = 0; j < h; j++) {
                    _platforms[i][j].sendMessage(Math.random()*.5);
                }
            }
        }
        _scene.startRendering();
        stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        Mouse.cursor = MouseCursor.HAND
    }
    
    private function onMouseDown(e:MouseEvent):void 
    {
        stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        stage.addEventListener(Event.MOUSE_LEAVE, onMouseUp);
        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        startPoint = new Point(mouseX, mouseY);
        startRotationZ = _rootContainer.rotationZ;
        startCameraZ = _scene.camera.z;
    }
    
    private function onMouseMove(e:MouseEvent):void 
    {
        TweenMax.to(_rootContainer, .3, {rotationZ: startRotationZ + (startPoint.x - mouseX) * Math.PI / stage.stageWidth, ease:Quad.easeOut});
        TweenMax.to(_scene.camera, .3, {z: startCameraZ + (startPoint.y - mouseY) * 4});
    }
    
    private function onMouseUp(e:Event):void 
    {
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        stage.removeEventListener(Event.MOUSE_LEAVE, onMouseUp);        
    }
    
}


import alternativ7.engine3d.core.MouseEvent3D;
import alternativ7.engine3d.core.Object3DContainer;
import alternativ7.engine3d.materials.FillMaterial;
import alternativ7.engine3d.objects.Mesh;
import com.greensock.easing.Quad;
import com.greensock.TweenMax;
import flash.events.Event;

/**
 * Object can connect to his neightboor and send "message"
 * @author IPFix
 */
class PlatForm extends Object3DContainer 
{
    private var _base:BoxMesh;
    private var _neigtboors:Vector.<PlatForm>;
    private var _connector:Vector.<BoxMesh>;
    private var _connected:Boolean;
    
    public function PlatForm() 
    {
        _base = new BoxMesh(100, 100, 30, new FillMaterial(0xFFFFFF, 1, 1, 0xCCCCCC), false, true);
        _base.alpha = .1;
        addChild(_base);    
        _base.addEventListener( MouseEvent3D.ROLL_OVER, onRollOver );
        _base.addEventListener( MouseEvent3D.CLICK, onClick );
        _neigtboors = new Vector.<PlatForm>();
        _connector = new Vector.<BoxMesh>();
    }
    
    public function addNeightboor(platform:PlatForm):void 
    {
        _neigtboors.push(platform);
    }
    
    private function onRollOver(e:Event):void 
    {
        _base.removeEventListener( MouseEvent3D.ROLL_OVER, onRollOver );
        _base.addEventListener( MouseEvent3D.ROLL_OUT, onRollOut );
        connect();
    }
    
    private function onClick(e:Event):void 
    {
        sendMessage();
    }
    
    
    public function sendMessage(delay:Number=0):void 
    {
        var neigtboor:PlatForm = _neigtboors[Math.round((Math.random() * _neigtboors.length)) % _neigtboors.length];
        var message:BoxMesh = new BoxMesh(100, 100, 5, new FillMaterial(0xFF0000, 1, 1, 0xCCCCCC));
        message.width = 0;
        message.depth = 5;
        message.alpha = .3;
        if(neigtboor.x > x){
            addChild(message);
            message.x = 100;
            TweenMax.to(message, .3, { delay:delay, x:160, ease:Quad.easeOut } );
            TweenMax.to(message, .15, { delay:delay,width:40, ease:Quad.easeOut, overwrite:false } );
            TweenMax.to(message, .15, { delay:.3+delay, width:0,x:200, ease:Quad.easeOut, overwrite:false, onComplete:function():void { removeChild(message); neigtboor.sendMessage();  } } );
        } else if(neigtboor.x < x){
            addChild(message);
            message.x = 0;
            TweenMax.to(message, .3, { delay:+delay, x: -100, ease:Quad.easeOut } );
            TweenMax.to(message, .15, { delay:+delay, width:40, ease:Quad.easeOut, overwrite:false } );
            TweenMax.to(message, .15, { delay:.3+delay, width:0, ease:Quad.easeOut, overwrite:false, onComplete:function():void {  removeChild(message); neigtboor.sendMessage(); } } );
        } else if(neigtboor.y > y){
            addChild(message);
            message.y = 50;
            message.x = 40;
            message.width = 10;
            message.depth = 0;
            TweenMax.to(message, .3, { delay:delay,y: 140, ease:Quad.easeOut } );
            TweenMax.to(message, .3, { delay:delay,depth:40, ease:Quad.easeOut, overwrite:false } );
            TweenMax.to(message, .15, { delay:delay+.3, depth:0, ease:Quad.easeOut, overwrite:false, onComplete:function():void {  removeChild(message); neigtboor.sendMessage(); } } );
        }else {
            addChild(message);
            message.y = -50;
            message.x = 40;
            message.width = 10;
            message.depth = 0;
            TweenMax.to(message, .3, { delay:delay, y: -140, ease:Quad.easeOut } );
            TweenMax.to(message, .3, { delay:delay, depth:40, ease:Quad.easeOut, overwrite:false } );
            TweenMax.to(message, .15, { delay:delay+.3, depth:0, ease:Quad.easeOut, overwrite:false, onComplete:function():void {  removeChild(message); neigtboor.sendMessage(); } } );
        }
    }
    
    public function connect():void 
    {
        if (_connected)
            return;
        _connected = true;
        TweenMax.to(_base, .3, { alpha:.8, height:60 } );
        
        for (var i:int = 0; i < _neigtboors.length; i++){
            var box:BoxMesh = new BoxMesh(100, 100, 5, new FillMaterial(0x0000FF, 1, 1, 0xCCCCCC));
            box.width = 0;
            box.depth = 40;
            box.alpha = .3;
            addChild(box);
            var neightboor:PlatForm = _neigtboors[i];
            if(neightboor.x > x){
                box.x = 100;
                TweenMax.to(box, .35, { width:100, ease:Quad.easeOut, onComplete:neightboor.highlight } );
            } else if(neightboor.x < x){
                box.x = 0;
                TweenMax.to(box, .35, { width:100, x:-100, ease:Quad.easeOut, onComplete:neightboor.highlight } );
            } else if (neightboor.y > y) {
                box.y = 50;
                box.x = 30;
                box.width = 40;
                box.depth = 0;
                TweenMax.to(box, .35, { depth:100, y:100, ease:Quad.easeOut, onComplete:neightboor.highlight } );
            } else {
                box.y = -50;
                box.x = 30;
                box.depth = 0;
                box.width = 40;
                TweenMax.to(box, .35, { depth:100, y:-100, ease:Quad.easeOut, onComplete:neightboor.highlight } );
            }
            _connector.push(box);
        }
    }
    
    public function highlight():void {
        TweenMax.to(_base, .65, { alpha:.5 } );
    }
    
    public function close():void {
        TweenMax.killTweensOf(_base);
        TweenMax.to(_base, .3, { alpha:.1 } );
    }
    
    private function onRollOut(e:MouseEvent3D):void 
    {
        disconnect();
    }
    
    private function disconnect():void 
    {
        if (!_connected)
            return;
        _connected = false;
        
        for (var i:int = 0; i < _neigtboors.length; i++) {
            var neightboor:PlatForm = _neigtboors[i];
            neightboor.close();
        }
        TweenMax.to(_base, .3, { alpha:.25, height:30 } );
        _base.addEventListener( MouseEvent3D.ROLL_OVER, onRollOver );
        for (var i:int = _connector.length-1; i >-1 ; i--) {
            var box:BoxMesh = _connector.pop();
            if (box.y != 0) {
                if (box.y < 0) {
                    TweenMax.to(box, .35, { depth:0, y:-50, ease:Quad.easeOut, onComplete:removeChild, onCompleteParams:[box] } );
                } else {
                    TweenMax.to(box, .35, { depth:0, y:50, ease:Quad.easeOut, onComplete:removeChild, onCompleteParams:[box] } );
                }
            }else if(box.x < 0)
                TweenMax.to(box, .35, { width:0, x:0, ease:Quad.easeOut, onComplete:removeChild, onCompleteParams:[box] } );
            else
                TweenMax.to(box, .35, { width:0, ease:Quad.easeOut, onComplete:removeChild, onCompleteParams:[box] } );
        }
    }
    
}


import alternativ7.engine3d.core.Sorting;
import alternativ7.engine3d.core.Vertex;
import alternativ7.engine3d.materials.FillMaterial;
import alternativ7.engine3d.materials.Material;
import alternativ7.engine3d.objects.Mesh;

/**
 * Box Mesh primitive for easy change width, depth , height..
 * @author IPFix
 */
class BoxMesh extends Mesh 
{
    private var _height:int;
    private var _width:int;
    private var _depth:int;
    
    public function BoxMesh(baseWidth:int, topWidth:int, height:int, material:Material=null, bottomVisible:Boolean=true, topVisible:Boolean=true,topMaterial:Material=null,botMaterial:Material=null) 
    {
        super();
        this._height = height;
        if(material == null)
            material = new FillMaterial(0xFFFFFF, 1, 1, 0xCCCCCC);
        if (topMaterial == null)
            topMaterial = material;
        if (botMaterial == null)
            botMaterial = material;
        
        var b1:Vertex = addVertex(-baseWidth/2, baseWidth/2, 0, 0, 0, "b1");
        var b2:Vertex = addVertex(-baseWidth/2, -baseWidth/2, 0, 0, 1, "b2");
        var b3:Vertex = addVertex(baseWidth/2, -baseWidth/2, 0, 1, 1, "b3");
        var b4:Vertex = addVertex(baseWidth/2, baseWidth/2, 0, 1, 0, "b4");
        
        var t1:Vertex = addVertex(-topWidth/2, topWidth/2, height, 0, 0, "t1");
        var t2:Vertex = addVertex(-topWidth/2, -topWidth/2, height, 0, 1, "t2");
        var t3:Vertex = addVertex(topWidth/2, -topWidth/2, height, 1, 1, "t3");
        var t4:Vertex = addVertex(topWidth/2, topWidth/2, height, 1, 0, "t4");
        
        if(topVisible && topWidth != 0)
            addFaceByIds(["t1", "t2", "t3", "t4"], topMaterial);
        if(bottomVisible)
            addFaceByIds(["b4", "b3", "b2", "b1"], botMaterial);
            
        addFaceByIds(["t1", "b1", "b2","t2"], material);
        addFaceByIds(["t2", "b2", "b3","t3"], material);
        addFaceByIds(["t3", "b3", "b4","t4"], material);
        addFaceByIds(["t4", "b4", "b1","t1"], material);
        
        // Calculating of normals
        calculateFacesNormals(true);
        calculateVerticesNormals(true, Number.MAX_VALUE);
        calculateBounds();
    }
    
    public function get width():int 
    {
        return _width;
    }
    
    public function set width(value:int):void 
    {
        _width = value;
        getVertexById("t3").x = getVertexById("t1").x+value;
        getVertexById("b3").x = getVertexById("b1").x+value;
        getVertexById("b4").x = getVertexById("b2").x+value;
        getVertexById("t4").x = getVertexById("t2").x+value;
        calculateFacesNormals(true);
        calculateVerticesNormals(true, Number.MAX_VALUE);
        calculateBounds();
    }
    
    public function get depth():int 
    {
        return _depth;
    }
    
    public function set depth(value:int):void 
    {
        _depth = value;
        value /= 2;
        getVertexById("t2").y = -value;
        getVertexById("b2").y = -value;
        getVertexById("b3").y = -value;
        getVertexById("t3").y = -value;
        
        getVertexById("t4").y = value;
        getVertexById("b4").y = value;
        getVertexById("b1").y = value;
        getVertexById("t1").y = value;
        
        calculateFacesNormals(true);
        calculateVerticesNormals(true, Number.MAX_VALUE);
        calculateBounds();
    }
    
    public function get height():int 
    {
        return _height;
    }
    
    public function set height(value:int):void 
    {
        _height = value;
        getVertexById("t1").z = height;
        getVertexById("t2").z = height;
        getVertexById("t3").z = height;
        getVertexById("t4").z = height;
        calculateFacesNormals(true);
        calculateVerticesNormals(true, Number.MAX_VALUE);
        calculateBounds();
    }
    
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;

/**
 * Create an background of point
 */
class DotBackground extends Sprite 
{
    private var verticalSpace:int;
    private var horizontalSpace:int;
    private var dotColor:uint;
    private var backgroundColor:uint;
    
    private var bitmap:Bitmap;
    private var bd:BitmapData;
    
    public function DotBackground(verticalSpace:uint, horizontalSpace:uint, dotColor:uint, backgroundColor:uint):void 
    {
        this.backgroundColor = backgroundColor;
        this.dotColor = dotColor;
        this.horizontalSpace = horizontalSpace;
        this.verticalSpace = verticalSpace;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event = null):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        
        bitmap = new Bitmap();
        addChild(bitmap);
        stage.addEventListener(Event.RESIZE, onResize);
        onResize(null);
    }
    
    private function onResize(e:Event):void 
    {
        if (bitmap.bitmapData)
            bitmap.bitmapData.dispose();
        
        bd = new BitmapData(stage.stageWidth, stage.stageHeight, false, backgroundColor);
        bd.lock();
        for (var i:int = 0; i < stage.stageWidth; i+=horizontalSpace) {
            for (var j:int = 0; j < stage.stageHeight; j += verticalSpace) {
                //if(Math.cos(i/coeff-mouseX/coeff)<0&&Math.sin(j/coeff-mouseY/coeff)>0)
                bd.setPixel(i, j, dotColor);
            }
        }
        bd.unlock();
        bitmap.bitmapData = bd;
    }
    
}

/**
 * BasicTemplate for Alternativa3D 7.6
 * Alternativa3D 7.6
 * @author narutohyper & clockmaker
 */
import alternativ7.engine3d.containers.BSPContainer;
import alternativ7.engine3d.containers.ConflictContainer;
import alternativ7.engine3d.containers.DistanceSortContainer;
import alternativ7.engine3d.containers.KDContainer;
import alternativ7.engine3d.containers.LODContainer;
import alternativ7.engine3d.controllers.SimpleObjectController;
import alternativ7.engine3d.core.Camera3D;
import alternativ7.engine3d.core.Object3DContainer;
import alternativ7.engine3d.core.View;
import flash.display.DisplayObject;

import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;

import flash.events.Event;

class AlternativaTemplate extends Sprite
{
    public static const CONFLICT:String = 'conflict';
    public static const BSP:String = 'bsp';
    public static const ZSORT:String = 'zsort';
    public static const KD:String = 'kd';
    public static const LOD:String = 'lod';

    public var container:Object3DContainer;

    public var view:View;
    public var camera:Camera3D;
    public var cameraController:SimpleObjectController;

    private var _mc:DisplayObjectContainer;
    private var _viewWidth:int;
    private var _viewHeight:int;
    private var _scaleToStage:Boolean;
    private var _containerType:String;

    /**
     * 新しい Alternativa3DTemplate インスタンスを作成します。
     * @param    mc
     * @param    containerType
     * @param    viewWidth
     * @param    viewHeight
     * @param    scaleToStage
     */
    public function AlternativaTemplate(mc:DisplayObjectContainer,containerType:String=CONFLICT,viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true)
    {

        _mc = mc;
        _mc.addChild(this);

        _containerType = containerType;
        _viewWidth = viewWidth;
        _viewHeight = viewHeight;
        _scaleToStage = scaleToStage;

        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }

    protected function atInit():void {}
    protected function atPreRender():void {}
    private var _onPreRender:Function = function():void{};
    public function get onPreRender():Function { return _onPreRender; }
    public function set onPreRender(value:Function):void
    {
        _onPreRender = value;
    }
    protected function atPostRender():void {}
    private var _onPostRender:Function = function():void{};
    public function get onPostRender():Function { return _onPostRender; }
    public function set onPostRender(value:Function):void
    {
        _onPostRender = value;
    }

    public function startRendering():void
    {
        addEventListener(Event.ENTER_FRAME, onRenderTick);
    }
    public function stopRendering():void
    {
        removeEventListener(Event.ENTER_FRAME, onRenderTick);
    }
    public function singleRender():void
    {
        onRenderTick();
    }
    private function init(e:Event = null):void
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        // entry point
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.align = StageAlign.TOP_LEFT;
        stage.quality = StageQuality.HIGH;

        if (_containerType == CONFLICT) {
            container = new ConflictContainer();
        } else if (_containerType == BSP) {
            container = new BSPContainer();
        } else if (_containerType == ZSORT) {
            container = new DistanceSortContainer();
        } else if (_containerType == KD) {
            container = new KDContainer();
        } else if (_containerType == LOD) {
            container = new LODContainer();
        }
        //View
        view = new View(stage.stageWidth, stage.stageHeight);
        _mc.addChild(view);
        
        //camera
        camera = new Camera3D();
        camera.view = view;
        camera.x = 0;
        camera.y = -500;
        camera.z = 0;
        container.addChild(camera);
        camera.view.hideLogo();
        _mc.addChild(camera.diagram);
        camera.rotationX = -130*Math.PI/180;
        camera.y = -400;
        camera.z = 350;
        
        onResize();
        stage.addEventListener(Event.RESIZE, onResize);
        atInit();
    }

    private function onResize(e:Event = null):void
    {
        if (_scaleToStage)
        {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
        }
        else
        {
            view.width = _viewWidth;
            view.height = _viewHeight;
        }
    }

    private function onRenderTick(e:Event = null):void
    {
        atPreRender();
        _onPreRender();
        camera.render();
        atPostRender();
        _onPostRender();
    }
}

