/**
 * Copyright toburau ( http://wonderfl.net/user/toburau )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hEUo
 */

// 昔あった電子玩具のライツアウトを作ってみました。
// クリックしたパネルと上下左右のパネルの色が反転します。
// すべて点灯させるか消すとクリアです。
package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;

	[SWF(frameRate="30", width="465", height="465", backgroundColor="0x000000")]

	public class Project9 extends Sprite {

		public function Project9() {
			for(var i:int=0; i<MAPSIZE*MAPSIZE; i++) {
				var mapx:int = i%MAPSIZE;
				var mapy:int = i/MAPSIZE;
				g_Map[i] = new Panel(i);
				g_Map[i].x = mapx * (XSIZE+GAP);
				g_Map[i].y = mapy * (YSIZE+GAP);
				addChild(g_Map[i]);
			}
			addEventListener(MouseEvent.CLICK, onMouseClick);
			g_Mode = MODE_TITLE;

			g_Message = createTextField(100, SCREEN_HEIGHT/3, SCREEN_WIDTH, 32, 0x00ff80);
			g_Message.text = "Click to Start";
			addChild(g_Message);
		}

		// マウスがクリックされたとき
		private function onMouseClick(e:MouseEvent):void {
			if(g_Mode == MODE_TITLE)
			{
				g_Message.text = "";
				g_Mode = MODE_PLAY;
				removeChild(g_Message);
				// ランダムに反転して問題を作成
				var n:int = Math.round(Math.random()*10) + 10;
				for(var j:int=0; j<n; j++)
				{
					var pos:int = Math.floor(Math.random()*MAPSIZE*MAPSIZE);
					g_Map[pos].push();
				}
				return;
			}
			else if(g_Mode == MODE_CLEAR)
			{
				g_Message.text = "Click to Start";
				g_Mode = MODE_TITLE;
				return;
			}

			// クリア判定
			for(var i:int = 0; i<MAPSIZE*MAPSIZE-1; i++) {
				if(g_Map[i].isVisible() != g_Map[i+1].isVisible()) {
					return;
				}
			}
			
			g_Message.text = "Clear !!";
			g_Mode = MODE_CLEAR;
			addChild(g_Message);
		}
	} 
}

import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.filters.GlowFilter;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

const SCREEN_WIDTH:int = 465;
const SCREEN_HEIGHT:int = 465;
const SCREENX:int = 465; // マップピクセルXサイズ
const SCREENY:int = 465; // マップピクセルYサイズ
const MAPSIZE:int = 5; // マップ1辺個数
const GAP:int = 5; // 隣のパネルとの間隔
const XSIZE:int = (SCREENX-GAP*(MAPSIZE-1))/MAPSIZE;
const YSIZE:int = (SCREENY-GAP*(MAPSIZE-1))/MAPSIZE;
// マップデータ
var g_Map:Array = new Array(MAPSIZE*MAPSIZE);
// モード(0:Title,1:Play,2:Clear)
const MODE_TITLE:int = 0;
const MODE_PLAY:int = 1;
const MODE_CLEAR:int = 2;
var g_Mode:int = MODE_TITLE;
var g_Message:TextField = new TextField;

// 1つのパネル
class Panel extends Sprite {
	private var _OffCol:int = 0x808080;
	private var _OnCol:int = 0x00FF00;
	private var _Round:int = 15;
	private var _OnPanel:Sprite = new Sprite();
	private var _PanelNo:int = 0;

	public function Panel(i:int) {
		_PanelNo = i;
		graphics.beginFill(_OffCol);
		graphics.drawRoundRect(0, 0, XSIZE, YSIZE, _Round);
		graphics.endFill();
		_OnPanel.graphics.beginFill(_OnCol);
		_OnPanel.graphics.drawRoundRect(0, 0, XSIZE, YSIZE, _Round);
		_OnPanel.graphics.endFill();
		_OnPanel.filters=[new GlowFilter(0x00FF00,1.0,16.0,16.0,2,2,false,false)];
		_OnPanel.visible = false;
		addChild(_OnPanel);
		addEventListener(MouseEvent.CLICK, onClick);
	}
	// Visible取得
	public function isVisible():Boolean { 
		return _OnPanel.visible;
	}
	// Push
	public function push():void {
		setReverse();
		setNeighbor();
	}
	// クリックされたときの処理
	private function onClick(e:MouseEvent):void {
		if(g_Mode != MODE_PLAY) return;
		push();
	}
	// 反転
	public function setReverse():void {
		_OnPanel.visible = !_OnPanel.visible;
	}
	// 4近傍の反転
	private function setNeighbor():void {
		var mapx:int = _PanelNo%MAPSIZE;
		var mapy:int = _PanelNo/MAPSIZE;
		var up:int = mapy-1;
		if(up >= 0) {
			g_Map[up*MAPSIZE+mapx].setReverse();
		}
		var down:int = mapy+1;
		if(down < MAPSIZE) {
			g_Map[down*MAPSIZE+mapx].setReverse();
		}
		var left:int = mapx-1;
		if(left >= 0) {
			g_Map[mapy*MAPSIZE+left].setReverse();
		}
		var right:int = mapx+1;
		if(right < MAPSIZE) {
			g_Map[mapy*MAPSIZE+right].setReverse();
		}
	}
}

// TextFieldの作成。ABAさんのBallBlastより
function createTextField(x:int, y:int, width:int, size:int, color:int,
					 align:String = TextFormatAlign.LEFT):TextField
{
	var fm:TextFormat = new TextFormat;
	fm.font = "_typewriter"; fm.bold = true;
	fm.size = size; fm.color = color;
	fm.align = align;
	var fi:TextField = new TextField;
	fi.defaultTextFormat = fm;
	fi.x = x; fi.y = y; fi.width = width;
	fi.selectable = false;
	return fi;
}
