/**
 * Copyright mtok ( http://wonderfl.net/user/mtok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hE3Q
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.LoaderInfo;
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.events.ProgressEvent;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	
	/**
	 * ...
	 * @author Motoki Matsumoto
	 */
	public class Main2 extends Sprite 
	{
		private var _apiKey:String;
		private var _service:WonderflWebService;
		private var sw:Number;
		private var sh:Number;
		private var _holder:Sprite;
		public function Main2():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			addChild(_holder = new Sprite());
			_apiKey = LoaderInfo(root.loaderInfo).parameters["open_api_key"];
			_service = new WonderflWebService(_apiKey);
			var method:GetUserCodesMethod = _service.getUserCodes('mtok');
			method.addEventListener(WonderflResultEvent.WONDERFL_API_COMPLETE, methodCompleteHandler);
			method.invoke();
			
			sw = stage.stageWidth;
			sh = stage.stageHeight;
		}
		
		private function methodErrorHandler(e:WonderflErrorEvent):void 
		{
			
		}
		
		private function methodCompleteHandler(e:WonderflResultEvent):void 
		{
			var method:GetUserCodesMethod = e.target as GetUserCodesMethod;
			var l:Loader;
			var i:int;
			for each(var v:* in method.data) {
				l = new Loader();
				l.contentLoaderInfo.addEventListener(Event.COMPLETE,
				function(e:Event):void { 
					var _li:LoaderInfo= e.target as LoaderInfo;
					var _l:Loader = _li.loader;
                                        //_li.content['smoothing'] = true;
					trace('Loader');
					_holder.addChild(_l);
					_l.scaleX = _l.scaleY = 100 / _l.width;
					i = _holder.getChildIndex(_l);
					_l.x = (i % 4)*(100+10) + 10;
					_l.y = Math.floor(i / 4) * (100 + 10) + 10;
				} );
				l.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, 
					function(e:ProgressEvent):void { 
						trace("progress");
					} );
				l.load(new URLRequest(v.thumbnail), new LoaderContext(true));
			}
		}
		
	}
}
/**
 *  Wonderfl Web API Library
 *  
 *  version 0.1
 *  Author: Motoki Matsumoto
 */
import flash.display.Loader;
import flash.events.ErrorEvent;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.ProgressEvent;
import flash.events.IOErrorEvent;
import flash.events.SecurityErrorEvent;
import flash.net.URLLoader;
import flash.net.URLRequest;
import flash.net.URLRequestMethod;
import com.adobe.serialization.json.JSON;
import flash.net.URLVariables;

class WonderflWebService {
	private var _apiKey:String;
	private static const GET_USER:String = "http://api.wonderfl.net/user/%username%";
	private static const GET_USER_CODES:String = "http://api.wonderfl.net/user/%username%/codes";
	private static const GET_CODE:String = "http://api.wonderfl.net/code/%codeid%";
	private static const GET_FORKS:String = "http://api.wonderfl.net/code/%codeid%/forks";	
	
	public function WonderflWebService(apiKey:String) {
		_apiKey = apiKey;
	}
	
	public function getUser(name:String):GetUserMethod{
		var pattern:RegExp = /%username%/;
		var url:String = WonderflWebService.GET_USER.replace(pattern, name);

		var req:URLRequest = new URLRequest(url);
		req.method = URLRequestMethod.GET;
		var v:URLVariables = new URLVariables();
		v.api_key = _apiKey;
		req.data = v;
				
		return new GetUserMethod(req);
	}
	public function getUserCodes(name:String):GetUserCodesMethod{
		var pattern:RegExp = /%username%/;
		var url:String = WonderflWebService.GET_USER_CODES.replace(pattern, name);
		var req:URLRequest = new URLRequest(url);
		req.method = URLRequestMethod.GET;
		
		var v:URLVariables = new URLVariables();
		v.api_key = _apiKey;
		req.data = v;
		return new GetUserCodesMethod(req);
	}
	public function getCode(codeId:String):GetCodeMethod {
		var pattern:RegExp = /%codeid%/;
		var url:String = WonderflWebService.GET_CODE.replace(pattern, codeId);
		var req:URLRequest = new URLRequest(url);
		req.method = URLRequestMethod.GET;
		var v:URLVariables = new URLVariables();
		v.api_key = _apiKey;
		req.data = v;
		return new GetCodeMethod(req);
	}
	public function getForks(codeId:String):GetForksMethod{
		var pattern:RegExp = /%codeid%/;
		var url:String = WonderflWebService.GET_FORKS.replace(pattern, codeId);
		var req:URLRequest = new URLRequest(url);
		req.method = URLRequestMethod.GET;
		var v:URLVariables = new URLVariables();
		v.api_key = _apiKey;
		req.data = v;
		return new GetForksMethod(req);
	}
}

class WebApiMethod extends EventDispatcher{
	private var _req:URLRequest;
	private var _data:* = null;
	public function WebApiMethod(req:URLRequest) {
		_req = req;
	}	
	
	private function completeHandler(e:Event):void 
	{
		var l:URLLoader = e.target as URLLoader;
		var result:* = JSON.decode(l.data);
		if (result.stat == "ok") {
			_data = parseResponse(result);
			dispatchEvent(new WonderflResultEvent(WonderflResultEvent.WONDERFL_API_COMPLETE));
		}else if (result.stat == "fail") {
			var ev:WonderflErrorEvent = new WonderflErrorEvent(WonderflErrorEvent.WONERFL_API_ERROR, result.message);
			dispatchEvent(ev);
			_data = null;
		}
	}
	
	private function progressHandler(e:ProgressEvent):void 
	{
		dispatchEvent(e);
	}
	private function ioErrorHandler(e:IOErrorEvent):void 
	{
		dispatchEvent(e);
	}

	private function securityErrorHandler(e:SecurityErrorEvent):void 
	{
		dispatchEvent(e);
	}
	
	protected function parseResponse(data:*):* {
		//must override;
		return {};
	}
	
	public function get url():String {
		return _req.url;
	}
	
	public function get data():* { return _data; }
	public function set data(value:*):void 
	{
		_data = value;
	}
	
	public function invoke():void {
		var loader:URLLoader = new URLLoader();
		loader.addEventListener(Event.COMPLETE, completeHandler);
		loader.addEventListener(ProgressEvent.PROGRESS, progressHandler);
		loader.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
		loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityErrorHandler);
		loader.load(_req);
	}
}

class GetUserMethod extends WebApiMethod {
	public function GetUserMethod(req:URLRequest) {
		super(req);
	}
	override protected function parseResponse(data:*):* 
	{
		return data.user;
	}
}
class GetUserCodesMethod extends WebApiMethod {
	public function GetUserCodesMethod(req:URLRequest) {
		super(req);
	}
	override protected function parseResponse(data:*):* 
	{
		return data.codes;
	}
}
class GetCodeMethod extends WebApiMethod {
	public function GetCodeMethod(req:URLRequest) {
		super(req);
	}
	override protected function parseResponse(data:*):* 
	{
		return data.code;
	}
}
class GetForksMethod extends WebApiMethod {
	public function GetForksMethod(req:URLRequest) {
		super(req);
	}
	override protected function parseResponse(data:*):* 
	{
		return data.forks;
	}
	
}

class WonderflErrorEvent extends ErrorEvent {
	public static const WONERFL_API_ERROR:String = "wonderflAPIError";
	public function WonderflErrorEvent(type:String, text:String = "", id:int = 0) {
		super(type, false, false, text);
	}
}
class WonderflResultEvent extends Event {
	public static const WONDERFL_API_COMPLETE:String = "wonderflAPIComplete";
	public function WonderflResultEvent(type:String, bubbles:Boolean = false, cancelable:Boolean = false) {
		super(type, bubbles, cancelable);
	}
}