/**
 * Copyright seikai ( http://wonderfl.net/user/seikai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hDvp
 */

// forked from clockmaker's カスタムクラスのプロパティーを再帰的に列挙する方法
/* =====================================
とりあえずdescribeTypeしてみるとか。
実用的かは謎です。
====================================== */
/* ======================================
カスタムクラスのプロパティーを列挙する方法
Object型だと型指定できないのでカスタムクラスを
作りたいときはよくあると思います。

ただ、カスタムクラスはfor inで走査できず不便。
カスタムクラスにtoObject()というメソッドを
追加してプロパティーを列挙できるようにしました。

他にも良い方法がありましたら教えてー
====================================== */
package
{
	import com.bit101.components.Label;
	import com.bit101.components.Text;
	
	import flash.display.Sprite;
	import flash.utils.describeType;
	
	[SWF(backgroundColor=0xCCCCCC)]
	public class Main extends Sprite
	{
		public function Main()
		{
			// 県
			var pref_1:Pref = new Pref();
			pref_1.name = "TOKYO";
			pref_1.id = 13;
			
			var pref_2:Pref = new Pref();
			pref_2.name = "OSAKA";
			pref_2.id = 27;
			
			// 人
			var person_1:Persion = new Persion();
			person_1.name = "YASU";
			person_1.age = 27;
			person_1.pref = pref_1;
			
			var person_2:Persion = new Persion();
			person_2.name = "NOBU";
			person_2.age = 29;
			person_2.pref = pref_2;
			
			// 格納
			var arr:Array = [ person_1, person_2 ];
			
			// 出力パターン1 (for inで出力)
			// カスタムクラスのプロパティーは列挙されない
			new Label(this, 10, 50, "for..in");
			new Text(this, 10, 70, dump(arr));
		}
		
		public function dump(o:*, name:String=""):String
		{
			var result:String= name? name + ":":"";
			var type:String=typeof(o);
			var desc:XML=describeType(o);
			
			switch (type) {
				case "boolean":
				case "number":
				case "string":
					result += String(o) ;
					break;
				case "xml":
					result += o.toXMLString();
					break;
				case "object":
					var t:String = desc.@name;
					result += t=="Array"?"[":"{";
					if (t == "Object" || t == "Array") {
						for (var key:String in o) {
							result+=dump(o[key]) + ",";
						}
					}
					else{
						var prop:XML;
						for each (prop in desc.variable) {	
							result+=dump(o[prop.@name], prop.@name) + ",";
						}
					}
					result = result.substr(0, result.length - 1);
					result += t=="Array"?"]":"}";
					break;
				default:
					result+=String(o);
					break;
			}
			return result;
		}
	}
}

// 都道府県
class Pref
{
	public function Pref(initObject:Object = null)
	{
		if (initObject)
		{
			this.id = initObject.id;
			this.name = initObject.name;
		}
	}
	
	public var id:int; //JISコード
	public var name:String; //都道府県名
	
	public function toObject():Object
	{
		return {
			name: name,
			id: id
		};
	}
}

// 人
class Persion
{
	public function Persion(initObject:Object = null)
	{
		if (initObject)
		{
			this.age = initObject.age;
			this.name = initObject.name;
			this.pref = new Pref(initObject.pref);
		}
	}
	
	public var age:int; // 年齢
	public var name:String; // 人名
	public var pref:Pref; // 所属する都道府県
	
	public function toObject():Object
	{
		return {
			name: name,
			age: age,
			pref: pref.toObject()
		};
	}
}

