/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hDPu
 */

package
{
	import com.bit101.components.Label;
	import com.bit101.components.PushButton;
	import com.bit101.components.TextArea;
	import flash.display.Sprite;
	import flash.events.Event;
	
	public class Main extends Sprite
	{
		private var srcArea:TextArea;
		private var destArea:TextArea;
		private const KEY:String = "FLASHASADOBEACTIONSCRIPT";
		
		public function Main()
		{
			srcArea = new TextArea(this, 0, 0, "FLASH");
			destArea = new TextArea(this, 0, 0);
			
			srcArea.width = destArea.width = stage.stageWidth;
			srcArea.height = 100;
			
			var button:PushButton = new PushButton(this, 0, srcArea.height + 10, "Encryption", onClick);
			var button2:PushButton = new PushButton(this, 0, button.y + button.height, "Decryption", onClick2);
			new Label(this, button.x + button.width + 10 , button.y, "key = FLASHASADOBEACTIONSCRIPT");
			
			destArea.y = button.y + 50;
			destArea.height = stage.stageHeight - destArea.y;
		}
		
		private function onClick(event:Event):void
		{
			destArea.text = encode(srcArea.text.toUpperCase(), KEY);
		}
		
		private function onClick2(event:Event):void
		{
			destArea.text = decode(srcArea.text.toUpperCase(), KEY);
		}
		
		private function encode(src:String, key:String):String
		{
			var table:String = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
			var dest:String = "";
			
			for (var i:int = 0; i < src.length; i++)
			{
				var p:int = table.indexOf(src.charAt(i));
				var k:int;
				if (i < key.length) k = table.indexOf(key.charAt(i));
				else k = 0;
				
				var c:int = (p + k) % 26;
				dest += table.charAt(c);
			}
			
			return dest;
		}
		
		private function decode(src:String, key:String):String
		{
			var table:String = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
			var dest:String = "";
			
			for (var i:int = 0; i < src.length; i++)
			{
				var c:int = table.indexOf(src.charAt(i));
				var k:int;
				if (i < key.length) k = table.indexOf(key.charAt(i));
				else k = 0;
				
				var p:int = (c - k + 26) % 26;
				dest += table.charAt(p);
			}
			
			return dest;
		}
	}
}