/**
 * Copyright nulldesign ( http://wonderfl.net/user/nulldesign )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hDFC
 */

/*
    誰か1-9の修正と、大文字のA-Zと小文字のa-z作ってくださいw

    http://nulldesign.jp/blog/
    http://twitter.com/nulldesign

*/

package 
{
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.Timer;

    public class nulldesign101013 extends Sprite
    {
        private var _timer:Timer;
        private var _list:Array;
        private var _wrap:Sprite;
        private var _bg:Sprite;

        public function nulldesign101013():void
        {
            // constructor code
            addEventListener( Event.ADDED_TO_STAGE, init );
        }
        
        private function init( e:Event ):void
        {
            removeEventListener( Event.ADDED_TO_STAGE, init );
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            //    背景用
            _bg = new Sprite();
            _bg.graphics.beginFill( 0x181818 );
            _bg.graphics.drawRect( 0, 0, 465, 465 );
            addChild( _bg );
            
            //    ラッパー
            _wrap = new Sprite();
            addChild( _wrap );
            
            //    タイポ9つ
            _list = [];
            for( var i:uint = 0; i < 9; i++ )
            {
                var _t:NDTypo = new NDTypo( 0 );
                _t.x = i * 36;
                _wrap.addChild( _t );
                _list.push( _t );
            }
            
            _wrap.x = Math.floor( ( stage.stageWidth - _wrap.width ) * .5 );
            _wrap.y = Math.floor( ( stage.stageHeight - _wrap.height ) * .5 );
            
            _timer = new Timer( 1000 / stage.frameRate );
            _timer.addEventListener( TimerEvent.TIMER, _onTimer );
            _timer.start();
        }
        
        private function _onTimer( e:TimerEvent ):void
        {
                var _d:Date = new Date();
                
                var _h:uint = _d.getHours();
                var _m:uint = _d.getMinutes();
                var _s:uint = _d.getSeconds();
                var _ms:uint = _d.getMilliseconds();
                
                _list[0].typo = new String( Math.floor( _h / 10 ) );
                _list[1].typo = new String( _h % 10 );
                _list[2].typo = new String( Math.floor( _m / 10 ) );
                _list[3].typo = new String( _m % 10 );
                _list[4].typo = new String( Math.floor( _s / 10 ) );
                _list[5].typo = new String( _s % 10 );
                _list[6].typo = new String( Math.floor( _ms / 100 ) );
                _list[7].typo = new String( Math.floor( _ms % 100 / 10 ) );
                _list[8].typo = new String( _ms % 10 );
        }

    }

}



//package 
//{
    import flash.display.Sprite;
    import flash.events.Event;
    import caurina.transitions.*;

    class NDTypo extends Sprite
    {
        public static const TYPO:Object = 
        {
         '0': [ 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0],
         '1': [ 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0],
         '2': [ 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1],
         '3': [ 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0],
         '4': [ 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1],
         '5': [ 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1],
         '6': [ 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1],
         '7': [ 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0],
         '8': [ 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1],
         '9': [ 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1],
         ':': [ 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0]
        };
        
        private var _list:Array;
        private var _dots:Array;
        private var _color:uint = 0xFFFFFF;
        private var _margin:uint = 1;
        private var _size:uint = 5;
        
        public function NDTypo( e:* ):void
        {
            // constructor code
            e = new String( e );
            _list = TYPO[e];
            _dots = createDots();
            addEventListener( Event.ADDED_TO_STAGE, init );
        }
        
        private function init( e:Event ):void
        {
            removeEventListener( Event.ADDED_TO_STAGE, init );
        }
        
        public function set typo( e:* ):void
        {
            e = new String( e );
            _list = TYPO[e];
            //_changeTypo();
            __changeTypo();
        }
        
        private function _changeTypo():void
        {
            var len:uint = _list.length;
            for( var i:uint = 0; i < len; i++ )
            {
                var _sp:Sprite = _dots[i] as Sprite;
                _sp.visible = true;
                Tweener.removeTweens( _sp );
                Tweener.addTween( _sp, { alpha: _list[i], time: .6, onComplete: _onComp } );
            }
        }
        
        private function __changeTypo():void
        {
            var len:uint = _list.length;
            for( var i:uint = 0; i < len; i++ )
            {
                var _sp:Sprite = _dots[i] as Sprite;
                _sp.visible = true;
                _sp.alpha = _list[i];
            }
        }
        
        private function _onComp():void
        {
            
        }
        
        private function createDots():Array
        {
            var _l:Array = [];
            for( var i:uint = 0; i < 35; i++ )
            {
                var _sp:Sprite = createSprite();
                _sp.x = i % 5 * ( _size + _margin ) + _size * .5;
                _sp.y = Math.floor( i / 5 ) * ( _size + _margin ) + _size * .5;
                _l.push( _sp );
                if( _list[i] == 0 ) _sp.visible = false;
                addChild( _sp );
            }
            return _l;
        }
        
        private function createSprite():Sprite
        {
            var _sp:Sprite = new Sprite();
            _sp.graphics.beginFill( _color );
            _sp.graphics.drawRect( - _size * .5, - _size * .5, _size, _size );
            _sp.graphics.endFill();
            _sp.alpha = 0;
            return _sp;
        }

    }

//}