/**
 * Copyright t2421 ( http://wonderfl.net/user/t2421 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hCXA
 */

package {
    import flash.display.Sprite;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    public class Main extends Sprite {
        public function Main() {
            // write as3 code here..
            addChild(new Slider());
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
class Slider extends Sprite
{
    private static const MAX_VALUE:int = 100,MIN_VALUE:int=0;//スライダーによって操作する値の範囲
    private static const VERTICAL:String = "vertical",HORIZON:String = "horizon";//ドラッグしている方向
    private var handle:RectangleObject;//ドラッグするつまみ
    private var dragRect:RectangleObject;//ドラッグの基準となる長方形
    private var dragValueMax:Number;//縦のドラッグ分と横のドラッグ分を合計したもの
    private var moveMax:Number;
    private var xMax:Number , xMin:Number, yMax:Number, yMin:Number;
    private var value:int;
        
    public function Slider() 
    {
        initialize();
    }
        
    public function initialize():void
    {
        handle = new RectangleObject(30, 20);
        addChild(handle);
        dragRect = new RectangleObject(100, 150, 0x000000);
        dragRect.alpha = 0.3;
        addChild(dragRect);
        dragRect.x = 300;
        dragRect.y = handle.y = 200;
        handle.x = dragRect.x - handle.width;
            
        handle.buttonMode = true;
        handle.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
        dragValueMax = dragRect.height + dragRect.width + dragRect.x;
        xMax = dragRect.x + dragRect.width;
        xMin = handle.x;
        yMax = dragRect.y + dragRect.height;
        yMin = dragRect.y;
        moveMax = dragRect.height + dragRect.x + dragRect.width;
        value = 1;
    }
        
    private function downHandler(e:MouseEvent):void 
    {
        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
    }
        
    private function upHandler(e:MouseEvent):void 
    {
        removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
        stage.removeEventListener(MouseEvent.MOUSE_UP, upHandler);
    }
        
    private function enterFrameHandler(e:Event):void 
    {
        var dragValue:Number;
        var direction:String;//方向を格納する
        if (handle.x == xMin) {
            direction = VERTICAL;
            handle.y = mouseY;
                
            if (handle.y <= yMin) {
                handle.y = yMin;
            }
            if (handle.y >= yMax) {
                if (direction == VERTICAL) {
                    dragValue = dragRect.height;
                    handle.x += 1;//縦ドラッグから抜けるために座標を変える
                }
            }else {
                dragValue = handle.y - dragRect.y;
            }
         }

         if (handle.x != xMin) {
            direction = HORIZON;
         }
            
         if (handle.y >= yMax) {
            if(direction==HORIZON){
               handle.x = mouseX;
               if (handle.x <= xMin) {
                    handle.y = yMax - 1;//横ドラッグから抜けるために座標を変える
                    handle.x = xMin;
               }

               if (handle.x >= xMax) {
                    handle.x = xMax;
               }
               handle.y = yMax;
               dragValue = dragRect.height+handle.x;
                    
            }
         }
         value = Math.floor(dragValue / moveMax * (MAX_VALUE-MIN_VALUE));
            
     }
        
     public function destroy():void
     {
        removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
        stage.removeEventListener(MouseEvent.MOUSE_UP, upHandler);
     }
        
}
    
//長方形を描くクラス    
class RectangleObject extends Sprite
{       
    public function RectangleObject(w:Number = 10, h:Number = 10, c:uint = 0xff0000) 
    {
        var sp:Sprite = new Sprite();
        addChild(sp);
        sp.graphics.beginFill(c);
        sp.graphics.drawRect(0, 0, w, h);
        sp.graphics.endFill();
    }   
}

