/**
 * Copyright wrotenodoc ( http://wonderfl.net/user/wrotenodoc )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hB5n
 */

package {

    import flash.display.Sprite;
    import flash.display.BitmapData
    import flash.display.Bitmap
    
    public class FlashTest extends Sprite {
        
        private var bd:BitmapData
        
        private const W:int = 64, H:int = 64
        private const sea:uint = 128
        
        public function FlashTest() {
            // write as3 code here..
            bd = new BitmapData(W, H)
            
            var rand:int, color:uint
            for(var i:int=0; i<W; i++){
                for(var j:int=0; j<H; j++){
                    rand = Math.random() * 256
                    bd.setPixel(i, j, rand)
                }
            }
            
            var bd2:BitmapData = bd.clone()
            smooth(bd, bd2)
            smooth(bd2, bd)
            smooth(bd, bd2)
            cutout(bd2, bd)
            
            with(addChild(new Bitmap(bd))){
                width = stage.stageWidth ; height = stage.stageHeight
            }
        }
        
        private function smooth(src:BitmapData, dst:BitmapData):void {
            var i:int, j:int, color:uint
            for(i=0; i<W; i++){
                for(j=0; j<H; j++){
                    color = getNeighbor(i, j, -1, -1, src)
                    color += getNeighbor(i, j, -1, 0, src)
                    color += getNeighbor(i, j, -1, 1, src)
                    color += getNeighbor(i, j, 0, -1, src)
                    color += getNeighbor(i, j, 0, 1, src)
                    color += getNeighbor(i, j, 1, -1, src)
                    color += getNeighbor(i, j, 1, 0, src)
                    color += getNeighbor(i, j, 1, 1, src)
                    color /= 4
                    //color = color << 16 | color << 8 | color
                    dst.setPixel(i, j, color)
                }
            }
        }
        
        private function cutout(src:BitmapData, dst:BitmapData):void {
            var i:int, j:int, color:uint
            for(i=0; i<src.width; i++){
                for(j=0; j<src.height; j++){
                    color = src.getPixel(i, j)
                    if(color > sea/2) color = 255
                    else if(color > sea/8) color = sea/2
                    else color = 0
                    //color = getNeighbor(i, j, 0, 0, src)
                    color = color << 16 | color << 8 | color
                    dst.setPixel(i, j, color)
                }
            }
        }
        
        private function getNeighbor(x:int, y:int, dx:int, dy:int, bd:BitmapData):uint {
            var nx:int = x + dx
            var ny:int = y + dy
            if(nx < 0) nx = bd.width - 1
            if(nx >= bd.width) nx = 0
            if(ny < 0) ny = bd.height - 1
            if(ny >= bd.height) ny = 0
            if(bd.getPixel(nx, ny) > sea*2) return 255
            if(bd.getPixel(nx, ny) > sea) return sea
            return 0
        }
        
    }
    
}