/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hA7v
 */

// forked from yd_niku's Fur 2D : 2nd step
// forked from yd_niku's Fur 2D : 1st step
// forked from yd_niku's Fur 2D
// forked from yd_niku's flash on 2009-9-29
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    [SWF(backgroundColor=0x000000,frameRate=60)]
    public class FlashTest extends Sprite {
        private var _canvas:BitmapData;
        private var _fur:FurBall;
        public function FlashTest() {
            _canvas = new BitmapData( 465, 465, true, 0x00 );
            
            var bm:Bitmap;
            addChild( bm = new Bitmap(_canvas) );
            bm.smoothing = true;
            
            _fur = new FurBall(Math.random()*60+200, Math.random()*90+10);
            _fur.x = stage.stageWidth/2;
            _fur.y = stage.stageHeight/2;
            
            addEventListener( Event.ENTER_FRAME, enterframe ); 
            
        }
        
        private function enterframe(e:Event):void{
            _canvas.lock();
            _fur.draw( _canvas );
            _canvas.unlock();
        }
    }
}
import flash.display.*;

class FurBall {
    public var x:Number = 0;
    public var y:Number = 0;
    private var _particles:Vector.<Particle> = new Vector.<Particle>();
    public function FurBall( count:int = 300, life:int = 60 ){
        const RADIAN :Number = 2*Math.PI;
        for( var i:int=0; i<count; ++i ) {
            var angle:Number= Math.random()*RADIAN;
            var p:Particle = new Particle();
            p.x  = 0;
            p.y  = 0;
            p.vx = Math.cos(angle);
            p.vy = Math.sin(angle);
            p.life = Math.random()*20 + life;
            _particles.push(p);
        }
    }
    public function draw( canvas:BitmapData ) :void {
            for each( var p:Particle in _particles ) {
                if( p.life > 0 ) {
                     p.x += p.vx;
                     p.y += p.vy;
                     
                     var tx:int= p.x+Math.cos(p.life/6)+x;
                     var ty:int= p.y+Math.sin(p.life/6) +y;
                     
                     var a:uint =  canvas.getPixel32( tx, ty ) >> 24;
                     var ta:uint = Math.min((p.life/90)*0xff+ a,0xFF);
                     var tc:uint = 0xFFFFFF | ta<<24;
                     
                     canvas.setPixel32( tx, ty, tc ); 
                     p.life--;
                }
            }    
    }
}
class Particle {
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var life:Number;
}
