/**
 * Copyright nacookan ( http://wonderfl.net/user/nacookan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h9iY
 */

package {
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    public class Janken extends Sprite {
        public function Janken() {
            var maxlevel:Number = 10;
            var maxcount:Number = Math.pow(2, maxlevel);
            var challengers:Array = [];
            for(var i:Number = 0; i < maxcount; i++){
                challengers.push(new Challenger(i, maxlevel * 10));
            }
            var winner:Challenger = tournament(challengers);
            
            var label:TextField = new TextField();
            label.autoSize = TextFieldAutoSize.LEFT;
            addChild(label);
            
            var s:Sprite = new Sprite();
            s.graphics.beginFill(0xfafafa);
            s.graphics.lineStyle(2, 0xa0a0a0);
            s.graphics.drawRect(0, 0, 100, 50);
            s.graphics.endFill();
            s.x = 300;
            s.y = 100;
            addChild(s);
            var t:TextField = new TextField();
            t.text = winner.id;
            t.autoSize = TextFieldAutoSize.LEFT;
            t.mouseEnabled = false;
            t.x = (s.width - t.width) / 2;
            t.y = (s.height - t.height) / 2
            s.addChild(t);
            s.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void{
                label.text += ['g', 'c', 'p'][winner.next()] + '\n';
            });
        }
        
        private function tournament(challengers:Array):Challenger{
            var winners:Array = [];
            for(var i:Number = 0; i < challengers.length; i += 2){
                var a:Challenger = challengers[i];
                var b:Challenger = challengers[i + 1];
                var draw:Number = 0;
                while(true){
                    var result:Number = doJanken(a.next(), b.next());
                    if(result == -1){
                        winners.push(a);
                        break;
                    }else if(result == +1){
                        winners.push(b);
                        break;
                    }
                    if(draw++ == 200){
                        throw new Error('引き分け発生');
                    }
                }
            }
            if(1 < winners.length){
                return tournament(winners);
            }else{
                return winners[0];
            }
        }
        
        private function doJanken(a:Number, b:Number):Number{
            return (
                (a == 0 && b == 0) ? 0 :
                (a == 0 && b == 1) ? -1 :
                (a == 0 && b == 2) ? +1 :
                (a == 1 && b == 0) ? +1 :
                (a == 1 && b == 1) ? 0 :
                (a == 1 && b == 2) ? -1 :
                (a == 2 && b == 0) ? -1 :
                (a == 2 && b == 1) ? +1 :
                (a == 2 && b == 2) ? 0 : 9
            );
        }
    }
}

class Challenger {
    private var _id:Number;
    private var index:Number = 0;
    private var stocks:Array = [];
    public function Challenger(id:Number, capacity:Number){
        _id = id;
        for(var i:Number = 0; i < capacity; i++){
            stocks.push(Math.floor(Math.random() * 3));
        }
    }
    public function next():Number{
        var res:Number = stocks[index];
        index++;
        if(stocks.length <= index) index = 0;
        return res;
    }
    public function get id():String{
        return _id.toString();
    }
}