/**
 * Copyright satoru.net ( http://wonderfl.net/user/satoru.net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h9Kn
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.text.*;
	import flash.utils.*;
	import flash.ui.*;
	import flash.system.*;
    import com.bit101.components.*;

	[SWF(width=500, height=400,frameRate = 30)]
	public class main extends MovieClip {

	public var selectedStage:int = 3;
	
	public var debug:TextField = new TextField();
	public var res:TextArea;
	
	public var FIELDS:Object = {
1: ["###########",
    "#.V..#..H.#",
    "#.##...##.#",
    "#L#..#..R.#",
    "#.#.###.#.#",
    "#....@....#",
    "###########"],

2: ["####################",
    "###.....L..........#",
    "###.##.##.##L##.##.#",
    "###.##.##.##.##.##.#",
    "#.L................#",
    "#.##.##.##.##.##.###",
    "#.##.##L##.##.##.###",
    "#.................L#",
    "#.#.#.#J####J#.#.#.#",
    "#L.................#",
    "###.##.##.##.##.##.#",
    "###.##.##R##.##.##.#",
    "#................R.#",
    "#.##.##.##.##R##.###",
    "#.##.##.##.##.##.###",
    "#@....R..........###",
    "####################"],
3: [
    "##########################################################",
    "#........................................................#",
    "#.###.#########.###############.########.###.#####.#####.#",
    "#.###.#########.###############.########.###.#####.#####.#",
    "#.....#########....J.............J.......###.............#",
    "#####.###.......#######.#######.########.###.#######.#####",
    "#####.###.#####J#######.#######.########.###.##   ##.#####",
    "#####.###L#####.##   ##L##   ##.##    ##.###.##   ##.#####",
    "#####.###..H###.##   ##.##   ##.########.###.#######J#####",
    "#####.#########.##   ##L##   ##.########.###.###V....#####",
    "#####.#########.#######.#######..........###.#######.#####",
    "#####.#########.#######.#######.########.###.#######.#####",
    "#.....................L.........########..........R......#",
    "#L####.##########.##.##########....##....#########.#####.#",
    "#.####.##########.##.##########.##.##.##.#########.#####.#",
    "#.................##............##..@.##...............R.#",
    "##########################################################",
]
};

	public var stringMap:Object = { "h":"left" , "j":"down", "k":"up" , "l":"right",  ".":"stop" };	
	public var key2code:Object  = { "left":37, "up":38, "right":39, "down":40, "stop":96 };

	public var FIELD:Array = [];
	public var hero:Object =  { X:0 , Y:0 };
	public var preHero:Object = { X:0, Y:0 };
	public var timeLimits:Object = {"1":50,"2":300,"3":700};
	public var status:Object = { time:0 , gameover:0, timelimit:timeLimits[selectedStage], point:0 };

	public var enemys:Array = new Array();
	public var gameStage:Sprite = new Sprite();
	public var stageArray:Array = new Array();
	public var isEnemy:Object = {};
	public var points:Array = new Array();
	public var firstPosition:Object = new Object();
	
	public var statusLabel:*;
	public var muteki:CheckBox;

	public var gameover:Window;
	public var gameclear:Window;
	
	public function main(){
		if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
	}

	public function init(e:Event = null):void {
			setupHistory();
			setupMap();
//			setupTrace();
			setupKey();
			
			loadField();
			drawFiled();
			setupForm();
            // gameStage.width = 400;

	}

	
	
	public function setupForm():void {
		stage.align = StageAlign.TOP_LEFT;
		stage.scaleMode = StageScaleMode.NO_SCALE;
		var panel:* = new Panel(this, 0, 0);
		
		panel.setSize(stage.stageWidth, 50);

		gameclear = new Window(this, 100, 100, "GameOver");
		gameclear.setSize(250, 80)
		gameclear.alpha = .9;
		gameclear.visible = false;
		new Label(gameclear, 100, 20, "You Win!!");
		new PushButton(gameclear, 130, 50, "Reset",doReset);
		new PushButton(gameclear, 20, 50, "Return", function():void { doReturn(1) } );
		
		
		gameover = new Window(this, 100, 100, "GameOver");
		gameover.setSize(250, 80)
		gameover.alpha = .9;
		gameover.visible = false;
		new Label(gameover, 80, 20, "ooops..! Try Again?");
		new PushButton(gameover, 130, 50, "Reset",doReset);
		new PushButton(gameover, 20, 50, "Return", function():void { doReturn(1) } );
		
		new PushButton(panel.content, 0, 0, "Reset(R)",doReset);
		new PushButton(panel.content, 110, 0, "Return(Ctrt+Z)", function():void { doReturn(1) } );
		
		muteki = new CheckBox(panel.content, 20, 36, "Muteki");
		
		statusLabel = new Label(panel.content, 20, 18, "status");
	}
	

		public function doReset(e:*):void {
			hero.X = firstPosition["hero"].X;
			hero.Y = firstPosition["hero"].Y;
			gameover.visible = false;
			gameclear.visible = false;
//		history = "";
			var heroMC:* = gameStage.getChildByName("hero");
			heroMC.x = hero.X * 8;
			heroMC.y = hero.Y * 8;
//		returnButton.enabled = false;

			for (var e:* in enemys) {
				var enemy:* = enemys[e];
				enemy.X = firstPosition["enemy" + enemy.ID].X;
				enemy.Y = firstPosition["enemy" + enemy.ID].Y;
				var mc:* = gameStage.getChildByName("enemy" + enemy.ID);
				
				// タイプを初期化
				if (enemy.STR == "J") {
					enemy.TYPE = "L"
				}
				
				mc.x = enemy.X * 8;
				mc.y = enemy.Y * 8;
			}
			
			for (var p:* in points) {
				points[p].visible = true;
			}
			
			status.time = 0;
			status.gameover = 0;
			status.point = 0;
			res.text = "";
			updateStatus();
//			setupHistoryLine();
		}
	
		
	public function drawFiled():void {
		
		for (var Y:int = 0; Y<stageArray.length; Y++) {
			var line:Array = stageArray[Y];
			var lines:Array = new Array();

//			_trace(Y + ":" + line.length + ":" + line)
			
			for (var X:int = 0; X<line.length; X++ ) {
				var str:String = stageArray[Y][X];
				var tf:TextField = new TextField();


				if (isHero(X,Y)) {
					str = "@";
					tf.name = "hero"
					firstPosition["hero"] = { X:X, Y:Y };
				} else if (isEnemy[ X + ":" + Y]) {
					var enemy:Object = isEnemy[X + ":" + Y];
					tf.name = "enemy" + enemy.ID;
					str = enemy.STR;
					firstPosition["enemy" + enemy.ID] = { X:X, Y:Y };
				} else {
					tf.name = "_" + X + ":" + Y;
					if (str == ".") {
						points.push(tf);
					}
				}
					// 色
				switch(str) {
					case ("@"):
						tf.textColor = 0xAAAAFF;
					break;
					case ("#"):
						tf.textColor = 0xFFFFFF;
					break;
					case ("."):
						tf.textColor = 0x00FF00;
					break;
					case ("L"):
					case ("R"):
						tf.textColor = 0xFF9900;
					break;
					case ("J"):
						tf.textColor = 0xFF00FF;
					break;
					default:
						tf.textColor = 0xFF0000;
					break;
				}

				var fmt:TextFormat = new TextFormat();
				fmt.size = 8;
//				fmt.align = TextFormatAlign.CENTER;
				
				tf.defaultTextFormat = fmt;
				tf.selectable = false;
				tf.text = str;
				tf.x = X*8;
				tf.y = Y*8;
				gameStage.addChild(tf);
			}
		}
		
		// 位置調整
		gameStage.x = selectedStage == 3 ? 0 : (gameStage.x - (gameStage.width / 3));
		
	}	

	public function isHero(X:int, Y:int):Boolean {
		return (hero.X == X && hero.Y == Y ) ? true : false;
	}		
		
	public function loadField():void {
			for (var Y:int = 0; Y < FIELD.length; Y++ ) {
				var line:String = FIELD[Y];
				var lines:Array = new Array();
				stageArray[Y] = new Array();
				

				for (var X:int = 0; X < line.length; X++ ) {
					var str:String = line.substr(X, 1);
					switch(str) {
						case ("@"):
							hero = { X:X, Y:Y,STR:"@",TYPE:"@" };
							stageArray[Y][X] = "";
							isEnemy[ X + ":" + Y ] = str;
						break;
						case ("."):
							stageArray[Y][X] = ".";
							var point:Object = {X:X,Y:Y}
						break;
						case ("#"):
							stageArray[Y][X] = "#";
							break;
						case ("L"):
						case ("R"):
						case ("H"):
						case ("J"):
						case ("V"):
							var enemyID:int = enemys.length;
							var enemy:Object = { X:X, Y:Y, STR:str, ID:enemyID, TYPE:(str == "J" ? "L" : str) };
							isEnemy[ X + ":" + Y ] = enemy;
							enemys.push(enemy);
							stageArray[Y][X] = "";
							break;
						default :
							stageArray[Y][X] = "";
						break;
					}
				}
			}
		}
	
	
	public function setupMap():void {
		
		var blackBg:Sprite = new Sprite();
		
		addChild(blackBg);
		blackBg.addChild(gameStage);
		blackBg.graphics.beginFill(0x000000);
		blackBg.graphics.drawRect(0,0,stage.stageWidth,200);
		blackBg.y = 50;
		gameStage.y = 10;
		gameStage.x = (blackBg.width / 2);

		FIELD = FIELDS[selectedStage];
	}

	public function setMove(obj:Object,direction:String):Object {
		switch(direction){
			case ("left"): // left
				if(!isBlock(obj,"left")){
					obj.X -= 1;
				}
			break;
			case ("up"): // up
				if(!isBlock(obj,"up")){
					obj.Y -= 1;
				}
			break;
			case ("right"): // right
				if(!isBlock(obj,"right")){						
					obj.X += 1;
				}
			break;
			case ("down"): // down
				if(!isBlock(obj,"down")){						
					obj.Y += 1;
				}
			break;
		}
		return obj;
	}	
	
	public function doMove(code:*):void {

		var codeMap:Object   = { 37:"left", 38:"up", 39:"right", 40:"down",96:"stop" };
		var googleMap:Object = { "left":"h" , "down":"j", "up":"k" , "right":"l",  "stop":"." };

		if (/96|39|40|37|38/.exec(new String(code)) && !isBlock(hero, codeMap[code])){

			var preN:int = (hero.X + hero.Y);
			preHero = { X:hero.X, Y: hero.Y };
			hero = setMove(hero, codeMap[code]);

			var isStop:Boolean = ((hero.X + hero.Y) == preN ? true : false);
			var stamp:String = isStop ? "." : googleMap[codeMap[code]];
//			res.text += stamp;
//			history += stamp;

			_appendHistory(stamp)

			pointCheck();
			updateDraw();
		}
	}
	
	public function pointCheck():void {
		var key:String = "_" + hero.X + ":" + hero.Y;
		var target:Object = gameStage.getChildByName(key);
		var isPoint:Boolean = target && target.text == "." ? true : false;

		if (isPoint && target.visible) {
			target.visible = false;
			status.point++;
		}
		return;
	}	

	public function updateStatus():void {
		statusLabel.text = ["Time:" + toZero(status.time) + "/" + toZero(status.timelimit) + " ",
						    "Point:" + toZero(status.point) + "/" + toZero(points.length)].join(" ");
	}	
	
	public function toZero(n:int):String {
		switch(true) {
			case (n < 10) : return String("00" + n); break;
			case (n < 100) : return String("0" + n); break;
			default : return String(n);
		}
	}
	
	public function updateDraw():void {
			// 主人公の位置更新
			var mc:DisplayObject = gameStage.getChildByName("hero");
			mc.x = hero.X * 8;
			mc.y = hero.Y * 8;

			var relation:Object = {
				"right" : {"right":"down" ,"left":"up"  ,"back":"left" }, // →
				"left"  : {"right":"up"   ,"left":"down","back":"right"}, // ←
				"up"    : {"right":"right","left":"left","back":"down" }, // ↑
				"down"  : {"right":"left" ,"left":"right","back":"up"   } // ↓
			};
			
			// 敵移動
			for (var e:String in enemys) {
				var enemy:Object = enemys[e];
				enemy.preX = enemy.X;
				enemy.preY = enemy.Y;
				var emc:* = gameStage.getChildByName("enemy" + enemy.ID);
				
				// 移動ルール1:行き止まりのマスが一つの場合、唯一侵入可能なマスに移動
				// →移動可能マスが1つかどうかチェック
				var way_type:int = isBlock(enemy, "up") + isBlock(enemy, "down") + isBlock(enemy, "left") + isBlock(enemy, "right");
				var way_name:String;
				switch(way_type) {
					case(3): way_name = "IKIDOMARI"; break;
					case(2): way_name = "TURO";      break;
					case(0): way_name = "KOUSA";     break;
					case(1): way_name = "KOUSA";     break;
				}

				// 相対位置
				var rp:Object = { X:preHero.X - enemy.X , Y: preHero.Y - enemy.Y };					
				var rp2:Object= { X:hero.X - enemy.X , Y: hero.Y - enemy.Y };	
				
				// ルール1 : 初期の動き
				if(status.time == 0){
					var direction1:String = (["down", "left", "up", "right"].filter(function(ele:*):* { return isBlock(enemy, ele) == 0 ? true:false } ))[0];
					setMove(enemy, direction1);

				// ルール2 : 行き止まり時　→　動ける方に移動
				} else if (way_name == "IKIDOMARI") {
					var direction2:String = (["up", "down", "left", "right"].filter(function(ele:*):* { return isBlock(enemy, ele) == 0 ? true:false } ))[0];
					setMove(enemy, direction2);
 
				// ルール3 : 通路の場合の処理　→　前居たところとは戻らない
				} else if (way_name == "TURO") {
					var direction3:String = (["up", "down", "left", "right"].filter(function(ele:*):* { return isBlock(enemy, ele) == 0 && ele !== getReverse(enemy.direction) ? true:false } ))[0];
					setMove(enemy, direction3);

				// ルール4 : 機種別動作
				} else if (enemy.TYPE == "V") { // V用
						if (rp.Y > 0 && !isBlock(enemy, "down")){
							setMove(enemy, "down");						
						} else if (rp.Y < 0 && !isBlock(enemy, "up")){
							setMove(enemy, "up");
						} else if (rp.X < 0 && !isBlock(enemy, "left")){
							setMove(enemy,"left")				
						} else if (rp.X > 0 && !isBlock(enemy, "right")){
							setMove(enemy, "right");
						} else {
							var direction4:String = (["down", "left", "up", "right"].filter(function(ele:*):* { return isBlock(enemy, ele) == 0 ? true:false } ))[0];
							setMove(enemy, direction4);
						}
				} else if (enemy.TYPE == "H") {
						if (rp.X < 0 && !isBlock(enemy, "left")){
							setMove(enemy,"left")				
						} else if (rp.X > 0 && !isBlock(enemy, "right")){
							setMove(enemy, "right");					
						} else if (rp.Y > 0 && !isBlock(enemy, "down")){
							setMove(enemy, "down");						
						} else if (rp.Y < 0 && !isBlock(enemy, "up")){
							setMove(enemy, "up");
						} else {
							var direction5:String = (["down", "left", "up", "right"].filter(function(ele:*):* { return isBlock(enemy, ele) == 0 ? true:false } ))[0];
							setMove(enemy, direction5);
						}
				} else if (enemy.TYPE == "L") {

					
					if (!isBlock(enemy, relation[enemy.direction]["left"])){
						setMove(enemy, relation[enemy.direction]["left"]);
					} else if (!isBlock(enemy, enemy.direction)){
						setMove(enemy, enemy.direction);
					} else if (!isBlock(enemy, relation[enemy.direction]["right"])){
						setMove(enemy, relation[enemy.direction]["right"]);
					} else {
						trace("ERROR" + enemy.STR + ":" + relation[enemy.direction]);							
					}
					

				} else if (enemy.TYPE == "R") {

					if (!isBlock(enemy, relation[enemy.direction]["right"])){
						setMove(enemy,relation[enemy.direction]["right"])				
					} else if (!isBlock(enemy, enemy.direction)){
						setMove(enemy, enemy.direction);						
					} else if (!isBlock(enemy, relation[enemy.direction]["left"])){
						setMove(enemy, relation[enemy.direction]["left"]);							
					} else {
						trace("ERROR" + enemy.STR + ":" + relation[enemy.direction]);							
					}

				} else {
					_trace("NO TYPE ERROR:" + enemy.TYPE + ":" + enemy.STR);
				}

				emc.x = enemy.X * 8;
				emc.y = enemy.Y * 8;

				if (enemy.preX == enemy.X-1) {
					enemy.direction = "right";
				} else if (enemy.preX == enemy.X+1) {
					enemy.direction = "left";
				} else if (enemy.preY == enemy.Y-1)　{
					enemy.direction = "down";
				} else if (enemy.preY == enemy.Y+1) {
					enemy.direction = "up";
				} else {
					if(status.time > 0) {trace("Direction Error")}
				}
				
				//trace(enemy.STR + ":" + enemy.direction)
				
				if (enemy.STR == "J" && way_name == "KOUSA") {
					enemy.TYPE = (enemy.TYPE == "L" ? "R" : "L");
				}					

			}
			
			// 時間更新
			status.time += 1;
			
			updateStatus();
		

			// ゲームオーバーチェック
			
			if(!muteki.selected){
				for (var n:* in enemys) {
					if (enemys[n].X == hero.X && enemys[n].Y == hero.Y || 
					    ((enemys[n].preX == hero.X && enemys[n].preY == hero.Y) && (enemys[n].X == preHero.X && enemys[n].Y == preHero.Y)) ) {
						gameover.visible = true;
						status.gameover = 1;
					}
				}
			
				if (status.timelimit == status.time) {
						gameover.visible = true;
						status.gameover = 1;				
				}
			} 
			
			if (status.point == points.length) {
				gameclear.visible = true;
				status.gameover = 1;
				trace("clear");
			}
			
			trace(status.point + ":" +  points.length)

			
		}	

		public function getReverse(direction:String):String {
			var reverse:Object = { up:"down", down:"up", left:"right", right:"left" };
			return reverse[direction];
		}
				
		
		public function isBlock(obj:Object, direction:String):Number {
			var flag:Boolean = false;
			switch(direction) {
				case("right"):
					flag = stageArray[obj.Y][obj.X + 1] == "#";
				break;
				case("left"):
					flag = stageArray[obj.Y][obj.X - 1] == "#";
				break;
				case("up"):
					flag = stageArray[obj.Y-1][obj.X] == "#";
				break;
				case("down"):
					flag = stageArray[obj.Y+1][obj.X] == "#";
				break;
				default:
					//trace("isBlock Error!:" + obj.STR + ":" + stageArray[obj.Y+1][obj.X])
				break;
			}
			return flag ? 1 : 0;
		}
	
		public function keyDownHandler(e:*):void {
			//trace(e + ":" + e.keyCode)
			if (e.keyCode == "82") { // R
				doReset( { } );
				return
			} else if (e.ctrlKey && e.keyCode == "90") { // Ctrl+Z
				doReturn(1)
				;
				return;
			}
			
			if(!status.gameover){
				doMove(e.keyCode)
			}
		}

		public function doReturn(num:Number):* {
			returnHistory(num)
		}

		public function returnHistory(num:*):* {
			var tempHistory:String = res.text.concat();
			//trace(">" + debug.text.concat());
			gameover.visible = false;
			gameclear.visible = false;
			
			if(tempHistory.length > 0){				
				doReset( {} );
				tempHistory = tempHistory.substr(0, tempHistory.length - num);
				//returnButton.enabled = tempHistory.length ? true : false;
				for (var i:int = 0; i < tempHistory.length; i++ ) {
					var word:String = tempHistory.substr(i, 1);
					var code:String = key2code[stringMap[word]];
					doMove(code);
				}
			} 
		}
		
		
		public function setupKey():void {
			stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
		}

		public function setupHistory():void {
			res = new TextArea(this, 0, 250);
			res.setSize(450,80);
			
			/*
			addChild(res);
			res.y = 300;
			res.border = true;
			res.width = 600;
			res.wordWrap = true;
			res.background = true;
			res.backgroundColor = 0xFFDDDD;
			res.alpha = .5;
			*/
//			res = new PushButton(panel.content, 0, 0, "Reset(R)",doReset);
		}
		
		
		public function _appendHistory(str:String):void {
			//res.appendText(str);
			res.text += str;
		}		
		
		public function setupTrace():void {
			addChild(debug);
			debug.y = 300;
			debug.border = true;
			debug.width = 600;
			debug.wordWrap = true;
			debug.background = true;
			debug.backgroundColor = 0xFFDDDD;
			debug.alpha = .5;
		}
		
		public function _trace(str:String):void {
			debug.text = str + debug.text;
		}
	}
}