/**
 * Copyright nishink ( http://wonderfl.net/user/nishink )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h8Wj
 */

// ジャンプアクションゲーム風のサンプル
// 左右キーで移動
// 上キーでジャンプ
//
// 地形はランダム生成　身動き取れなくなったらリロードしてください
package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;

	[SWF(width=465, height=465, backgroundColor=0, frameRate=60)]
	public class FlashTest extends Sprite {
		private var key:Key = new Key();
		private var chara:Chara = new Chara();
		private var field:Field = new Field(100);
		// コンストラクタ
		public function FlashTest() {
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
		}
		// 描画更新
		private function onEnterFrame(ev:Event):void {
			// 描画物のクリア
			graphics.clear();
			// ブロックの描画
			field.draw(graphics);
			// キーを押した方向へ移動
			if (key.isPress(Keyboard.RIGHT)) chara.moveRight();
			if (key.isPress(Keyboard.LEFT)) chara.moveLeft();
			chara.onEnterFrame(field);
			chara.draw(graphics);
		}
		// キー押下
		// キー押しっぱなしだとオート連打（ＯＳのキーリピート機能）になる
		private function onKeyDown(ev:KeyboardEvent):void {
			key.press(ev.keyCode);
			if (ev.keyCode == Keyboard.UP) {
				chara.jump();
			}
		}
		// キー離す
		private function onKeyUp(ev:KeyboardEvent):void {
			key.release(ev.keyCode);
		}
	}
}
import flash.ui.Keyboard;
import flash.display.Graphics;
class Obj {
	protected const SCALE:int = 8; // 倍率
	protected const SIZE:int = 16; // サイズ
	protected var x:int; // 水平位置
	protected var y:int; // 垂直位置
	protected var w:int;　// 幅
	protected var h:int; // 高さ
	public function Obj(x:int=0, y:int=0) {
		this.x = x * SCALE;
		this.y = y * SCALE;
		this.w = SIZE * SCALE;
		this.h = SIZE * SCALE;
	}
	public function collisionLeft(x:int, y:int, w:int, h:int):Boolean {
		return (isIn(x, y) || isIn(x, y + h - 1));
	}
	public function collisionRight(x:int, y:int, w:int, h:int):Boolean {
		return (isIn(x + w - 1, y) || isIn(x + w - 1, y + h - 1));
	}
	public function collisionTop(x:int, y:int, w:int, h:int):Boolean {
		return (isIn(x, y) || isIn(x + w - 1, y));
	}
	public function collisionBottom(x:int, y:int, w:int, h:int):Boolean {
		return (isIn(x, y + h - 1) || isIn(x + w - 1, y + h - 1));
	}
	private function isIn(x:int, y:int):Boolean {
		return (x >= this.x && x < this.x + this.w &&
				y >= this.y && y < this.y + this.h);
	}
	public function getX():int {
		return x;
	}
	public function getY():int {
		return y;
	}
	public function getW():int {
		return w;
	}
	public function getH():int {
		return h;
	}
}
class Field {
	private var blocks:Vector.<Block> = new Vector.<Block>();
	private var newX:int;
	private var newY:int;
	public function Field(numObj:uint) {
		for (var i:int=0; i < numObj; i++) {
			blocks.push(new Block(Math.random()*448, Math.random()*448));
		}
	}
	public function collisionRight(x:int, y:int, w:int, h:int):Boolean {
		for each(var block:Block in blocks) {
			if (block.collisionRight(x, y, w, h)) {
				this.newX = block.getX() - w;
				return true;
			}
		}
		return false;
	}
	public function collisionLeft(x:int, y:int, w:int, h:int):Boolean {
		for each(var block:Block in blocks) {
			if (block.collisionLeft(x, y, w, h)) {
				this.newX = block.getX() + block.getW();
				return true;
			}
		}
		return false;
	}
	public function collisionTop(x:int, y:int, w:int, h:int):Boolean {
		for each(var block:Block in blocks) {
			if (block.collisionTop(x, y, w, h)) {
				this.newY = block.getY() + block.getH();
				return true;
			}
		}
		return false;
	}
	public function collisionBottom(x:int, y:int, w:int, h:int):Boolean {
		for each(var block:Block in blocks) {
			if (block.collisionBottom(x, y, w, h)) {
				this.newY = block.getY() - h;
				return true;
			}
		}
		return false;
	}
	public function draw(g:Graphics):void {
		for each(var block:Block in blocks) {
			block.draw(g);
		}
	}
	public function getNewX():int {
		return newX;
	}
	public function getNewY():int {
		return newY;
	}
}
class Chara extends Obj{
	private const VT:int = 16; // 終端速度
	private var vx:int; // 水平方向速度
	private var vy:int; // 垂直方向速度
	private var air:Boolean = true; // 空中かどうか
	// キーを押した方向へ移動
	public function onEnterFrame(field:Field):void {
		// 重力加速度
		if (vy < VT) vy++;
		// 摩擦
		if (vx > 0) vx--;
		if (vx < 0) vx++;
		// キャラの移動
		var newX:int = x + vx;
		var newY:int = y + vy;
		// ブロックとの衝突
		if (field.collisionRight(newX, y, w, h)) {
			newX = field.getNewX();
			vx = 0;
		}
		if (field.collisionLeft(newX, y, w, h)) {
			newX = field.getNewX();
			vx = 0;
		}
		air = true;
		if (field.collisionBottom(x, newY, w, h)) {
			newY = field.getNewY();
			air = false;
			vy = 0;
		}
		if (field.collisionTop(x, newY, w, h)) {
			newY = field.getNewY();
			vy = 0;
		}
		x = newX;
		y = newY;
		// 壁からでないように
		const WALL:int = (465 - SIZE) * SCALE;
		if (x < 0) x = 0;
		if (y < 0) y = 0;
		if (x > WALL) x = WALL;
		if (y > WALL) {
			y = WALL;
			air = false; // 床に接地
		}
	}
	// キャラ（四角形）を描画
	public function draw(g:Graphics):void {
		g.beginFill(0x00FF00);
		g.drawRect(x / SCALE, y / SCALE, SIZE, SIZE);
		g.endFill();
	}
	public function moveRight():void {
		if (vx < VT) vx+=2;
	}
	public function moveLeft():void {
		if (vx > -VT) vx-=2;
	}
	public function jump():void {
		if (!air) {
			vy = -VT*2;
			air = true;
		}
	}
}
class Block extends Obj{
	public function Block(x:int=0, y:int=0) {
		super(x, y);
	}
	// ブロック（四角形）を描画
	public function draw(g:Graphics):void {
		g.beginFill(0x0000FF);
		g.drawRect(x / SCALE, y / SCALE, 16, 16);
		g.endFill();
	}
}
class Key {
	private var state:Array = new Array();
	public function press(keyCode:uint):void {
		state[keyCode] = true;
	}
	public function release(keyCode:uint):void {
		state[keyCode] = false;
	}
	public function isPress(keyCode:uint):Boolean {
		return state[keyCode];
	}
}
