/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h8Cc
 */

/*
 * どうもzahirです
 * PixelBenderToolkitのpre7(ver 1.5.1)が出たので早速その機能の程を試してみました。
 * 正直、英語がぜんっぜん読めないので何が変わったのか判りません
 * とりあえず、これまでではbool(Boolean型)の1～4を使っているとpbj出力できなかったのが
 * ここに来てようやく修正されて出力できるようになったようなので試しに
 * しかしです、なんかbool型の認識がおかしい感じです…
 * 自分が悪いのかflashPlayerが悪いのかPBTKが悪いのかadob(ry
 * 
 * flex sdk 3.4 FP10.0.32 PBTK pre7(1.5.1)
*/

package{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	
	import flash.display.ShaderInput;
	import flash.display.ShaderJob;
	import flash.display.ShaderParameter;
	import flash.display.Sprite;
	
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.text.TextField;
	
	[SWF(width=465, height = 465, backgroundColor = 0x666666)]
	
	public class PBTK_pre7_test1 extends Sprite{
		private const URL:String = "http://assets.wonderfl.net/images/related_images/e/e5/e5a0/e5a0588a81f4cd6e76cc5cc470b0d1b301655bf1m";
		
		private var ref:Boolean = false;

		private var l:Loader;
		private var bmp:Bitmap;
		private var bd:BitmapData;
		
		private var s:TestShader;
		private var sj:ShaderJob;
		private var reader:ShaderParamReader;
		
		private var tf:TextField;
		
		public function PBTK_pre7_test1(){
			l = new Loader();
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
			l.load( new URLRequest( URL ) , new LoaderContext(true));
			
			stage.addEventListener(MouseEvent.CLICK, onClick);
		}
		private function onComp( e:Event ):void{
			s = new TestShader( l.width, l.height, ref);
			
			s.reflect = ref; // 何故か最初は 無視されるｗ defaultはtrueに設定してあります.
			
			bmp = l.content as Bitmap;
			bd = bmp.bitmapData;
			addChild(bmp);
			bmp.x = bmp.y = 10;
			s.data.src.input = bd;
			
			reader = new ShaderParamReader( s.data );
			setParamData();
			label();
			
			BoolValue();
			
			onShader()
		}
		private function onClick( e:MouseEvent ):void{
			s.reflect = ref = ref == true ? false : true;
			onShader();
			setBoolValue();
		}
		private function onShader():void{
			sj = new ShaderJob( s, bd , bd.width, bd.height );
			sj.start( true );
		}
		private function label():void{
			var t:TextField = new TextField();
			t.autoSize = "left";
			t.text = "クリックすると水平方向に反転";
			t.x = 10;
			t.y = bmp.y + bmp.height + 10;
			addChild(t);
		}
		private function BoolValue():void{
			tf = new TextField();
			tf.autoSize = "left";
			tf.x = 10;
			tf.y = bmp.y + bmp.height + 40;
			addChild(tf);
			setBoolValue();
		}
		private function setBoolValue():void{
			tf.text = "ref  :: " + ref + "\n" + "H_Reflect :: " + s.reflect;
		}
		private function setParamData():void{
			var t:TextField = new TextField();
			t.background = true;
			t.backgroundColor = 0xCCCCCC;
			
			t.width = 465 - ( bmp.x + bmp.width + 20);
			t.height = stage.stageHeight - 20;
			t.x = bmp.x + bmp.width + 10;
			t.y = 10;
			var str:String = "";
			str = "<b>Input</b>\n" + reader.getInputHtml() + "\n\n<b>Parameter</b>\n" + reader.getParamHtml();
			str += ( "\n\nH_Reflect(bool)がParameterに登録されない。\n\n");
			
			for( var p:String in s.data){
				str += "<b>" + p + "</b>  ::  " + (s.data[p] is ShaderParameter) + "\n";
			}
			str += "\nShaderParameterじゃない＼(＾o＾)／"
			t.htmlText += str ;
			addChild(t);
		}
	}
}

import flash.display.Shader;
import flash.display.ShaderData;
import flash.display.ShaderInput;
import flash.display.ShaderParameter;

import mx.utils.Base64Decoder;
import flash.events.Event;

class ShaderParamReader{
	public static const INDEX:String = "index";
	public static const NAME:String = "name";
	public static const NONE:String = "none";
	
	private var sd:ShaderData;
	
	private var _sort:String;
	
	private var input:Array = [];
	private var param:Array = [];
	private var meta:Object;
	
	public function get inputs():Array{ return input; }
	public function get params():Array{ return param; }
	public function get metaData():Object{ return meta; }
	
	public function ShaderParamReader(shaderData:ShaderData , sort:String = "index" ){
		read( shaderData, sort );
	}
	public function read( shaderData:ShaderData , sort:String = "index"  ):void{
		sd = shaderData;
		_sort = sort;
		
		reading();
	}
	private function reading():void{
		for( var p:String in sd){
			if( sd[p] is ShaderParameter ){
				var v:Array = [];
				for(var m:String in sd[p]) v[v.length] = {"type":m, "value":sd[p][m]};
				param[param.length] = {"name":p, "index":sd[p].index, "type":sd[p].type, "values":sortValues( v )};
			}
			else if( sd[p] is ShaderInput )
					input[input.length] = {"name":p, "index":sd[p].index, "channels":sd[p].channels};
		}
		
		setMeta();
		onSort();
	}
	private function sortValues( v:Array ):Array{
		if(v){
		var _name:Object = {};
		var _des:Object = {};
		var _max:Object = {};
		var _min:Object = {};
		var _def:Object = {};
		for(var i:int=0, len:int= v.length;i<len; i++){
			if(v[i].type == "name") _name = v[i];
			else if(v[i].type == "description") _des = v[i];
			else if(v[i].type == "maxValue") _max = v[i];
			else if(v[i].type == "minValue") _min = v[i];
			else if(v[i].type == "defaultValue") _def = v[i];
		}
		v = null;
		return [_name, _max, _min, _def, _des];
		}else return [];
	}
	
	private function setMeta():void{
		meta = {
			"name": (sd["name"] != null) ? sd["name"] : "",
			"namespace":(sd["namespace"] != null) ? sd["namespace"] : "",
			"vendor":(sd["vendor"] != null) ? sd["vendor"] : "",
			"version":(sd["version"] != null) ? sd["version"] : "",
			"description":(sd["description"] != null) ? sd["description"] : ""
		};
	}
	private function onSort():void{
		if( _sort == "index"){
			param.sortOn( "index", Array.CASEINSENSITIVE );
			input.sortOn("index", Array.CASEINSENSITIVE );
		}else if(_sort == "name"){
			param.sortOn( "name", Array.CASEINSENSITIVE );
			input.sortOn("name", Array.CASEINSENSITIVE );
		}
	}
	public function reSort( sort:String ):void{
		_sort = sort;
		onSort();
	}
	
	public function getInputHtml( nameColor:uint = 0x0000FF, channelColor:uint = 0x339900 ):String{
		var str:String = "";
		if(input.length){
			str = "";
			for(var i:int=0, len:int= input.length; i < len; i++){
				str += "\t" + input[i].name +"";
				str += " ( " + input[i].channels + " )\n";
			}
		}
		return str;
	}
	public function getParamHtml( nameColor:uint = 0x0000FF , typeColor:uint = 0x339900 , menberColor:uint = 0xFF6600):String{
		var str:String = "";
		if(param.length){
		str = "";
		for(var i:int=0, len:int= param.length; i<len; i++){
			var v:Array = param[i].values;
			str += "\t<font color=\"#" + nameColor.toString(16) + "\">" + param[i].name +"</font>";
			str += " ( <font color=\"#" + typeColor.toString(16) + "\">" + param[i].type + "</font> )\n";
			str += "\t&lt;\n";
			if(v){
				for(var j:int = 0, len2:int = v.length; j < len2; j++){
					if(v[j].type)
					str += "\t\t<font color=\"#" + menberColor.toString(16) + "\">" + v[j].type + "</font> : " + v[j].value + "\n";
				}
			}
			str += "\t&gt;;\n\n";
			}
		}
		return str;
	}
}

/* pbk
<languageVersion : 1.0;>

kernel pre7_test1
<   namespace : "zahir1929";
    vendor : "zahir";
    version : 1;
    description : "bool test.";
>
{
    input image4 src;
    output pixel4 dst;
    
    parameter bool H_Reflect<
        defaultValue: bool(true);
    >;
    parameter float2 rect<
        maxValue: float2(4000);
        minValue: float2(8);
        defaultValue: float2(256);
    >;

    void
    evaluatePixel(){
        float2 oc = outCoord();
        if(H_Reflect == true)
            dst = sampleNearest(src, rect - oc);  
        else
            dst = sampleNearest(src,outCoord());
    }
}
 * */
class TestShader extends Shader{
	public function TestShader( width:int, height:int, reflect:Boolean = false){
		var code:String = "pQEAAACkCgBwcmU3X3Rlc3QxoAxuYW1lc3BhY2UAemFoaXIxOTI5AKAMdmVuZG9yAHphaGlyAKAIdmVyc2lvbgABAKAMZGVzY3JpcHRpb24AYm9vbCB0ZXN0LgChAQIAAAxfT3V0Q29vcmQAowAEc3JjAKECBAEAD2RzdAChAQ0BgAhIX1JlZmxlY3QAog1kZWZhdWx0VmFsdWUAAQChAQIAAANyZWN0AKICbWF4VmFsdWUARXoAAEV6AACiAm1pblZhbHVlAEEAAABBAAAAogJkZWZhdWx0VmFsdWUAQ4AAAEOAAAAdAgDBAAAQADIBgEABAAAAKAGAgAGAQAAdAYAgAIAAADQAAAABgIAAHQIAMQAAsAACAgAxAgAQADADAPECALAAHQEA8wMAGwA1AAAAAAAAADADAPEAABAAHQEA8wMAGwA2AAAAAAAAAA==";
		var dec:Base64Decoder = new Base64Decoder();
		dec.decode( code );
		this.byteCode = dec.toByteArray();
		data.H_Reflect  = reflect;
		this.rect = [width, height];
	}
	public function get reflect():Boolean{
		return data.H_Reflect;
	}
	public function set reflect( flg:Boolean ):void{
		data.H_Reflect =  flg ;
	}
	public function set rect( value:Array ):void{
		data.rect.value = value;
	}
}
