/**
 * Copyright ken880guchi ( http://wonderfl.net/user/ken880guchi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h85Y
 */

package {
  import flash.display.Sprite;
  import flash.events.KeyboardEvent;
  import flash.text.TextField;
  import flash.text.TextFieldType;
  import flash.ui.Keyboard;
 
  import net.user1.reactor.IClient;
  import net.user1.reactor.Room;
  import net.user1.reactor.Reactor;
  import net.user1.reactor.ReactorEvent;
 
  public class UnionChatPart1 extends Sprite {
    protected var reactor:Reactor;
    protected var chatRoom:Room;
    // Define a variable for the "incoming" text field
    protected var incomingMessages:TextField;
    protected var outgoingMessages:TextField;
   
   
    public function UnionChat () {
      buildUI();
      reactor = new Reactor();
      reactor.addEventListener(ReactorEvent.READY,readyListener);
      reactor.open("tryunion.com", 9100);
    }
   
    protected function readyListener (e:ReactorEvent):void {
      // Display the connection status on screen
      incomingMessages.appendText("Connected to Union\n");
      chatRoom = connection.getRoomManager().createRoom(
                                                   "chatRoom");
      chatRoom.addMessageListener("CHAT_MESSAGE",
                                  chatMessageListener);
      chatRoom.join();
    }
   
    protected function buildUI ():void {
      // Create a text field to show incoming chat messages
      incomingMessages = new TextField;
      incomingMessages.border = true;
      incomingMessages.background = true;
      incomingMessages.width = 400;
      incomingMessages.height = 200;

      outgoingMessages = new TextField;
      outgoingMessages.type = TextFieldType.INPUT;
      outgoingMessages.border = true;
      outgoingMessages.background = true;
      outgoingMessages.width = 400;
      outgoingMessages.height = 20;
      outgoingMessages.y = 210;
      outgoingMessages.addEventListener(KeyboardEvent.KEY_UP,
                                        keyUpListener);
     
      // Add the "incoming messages" text field to the screen
      addChild(incomingMessages);
      addChild(outgoingMessages);
    }
   
    protected function keyUpListener (e:KeyboardEvent):void {
      if (e.keyCode == Keyboard.ENTER) {
        chatRoom.sendMessage("CHAT_MESSAGE",
                             true,
                             null,
                             outgoingMessages.text);
        outgoingMessages.text = "";
      }
    }
   
    // Define the listener for "CHAT_MESSAGE" messages
    protected function chatMessageListener (fromClient:IClient,
                                            messageText:String
                                            ):void {
      // The "fromClient" is the client that sent the message.
      // messageText is the value of the 4th argument to
      // sendMessage() (see line 67, above)
      incomingMessages.appendText("Guest"
                                  + fromClient.getClientID()
                                  + " says: "
                                  + messageText + "\n");
    }
  }
}