/**
 * Copyright majoraze ( http://wonderfl.net/user/majoraze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h7r1
 */

// forked from majoraze's Throwing
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class Easing extends Sprite {
        private var ball:Ball;
        private var easing:Number = .2;
        private var targetX:Number = stage.stageWidth/2;
        private var targetY:Number = stage.stageHeight/2;
        
        public function Easing() {
            init();
        }
        
        
        private function init():void {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            ball = new Ball();
            addChild(ball);
            
            ball.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            var dx:Number = targetX - ball.x;
            var dy:Number = targetY - ball.y;
            
            var distance:Number = Math.sqrt(dx * dx + dy * dy);
            
            //check if the ball reaches the target (or get close enought to stop the code)
            if (distance < 1) {
                ball.x = targetX;
                ball.y = targetY;
                removeEventListener(Event.ENTER_FRAME, onEnterFrame);
            } else {
                var vx:Number = (targetX - ball.x) * easing;
                var vy:Number = (targetY - ball.y) * easing;
                ball.x += vx;
                ball.y += vy;
            }
        }
        
        private function onMouseDown(e:MouseEvent):void {
            //check if there's no enterframe (that means its already on the target)
            if (hasEventListener(Event.ENTER_FRAME)) {
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
            }

            ball.startDrag();
            removeEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function onMouseUp(e:MouseEvent):void {
            ball.stopDrag();
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }


        
    }
}



//ball class

import flash.display.Sprite;

class Ball extends Sprite {
    public var radius:Number;
    private var color:uint;
    public var vx:Number = 0;
    public var vy:Number = 0;    
    
    public function Ball(radius:Number = 40, color:uint = 0xff0000) {
        this.radius = radius;
        this.color = color;
        
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill()
    }
}
