/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h7fx
 */

package {
  import flash.display.Sprite;
  import flash.events.TimerEvent;
  import flash.text.TextField;
  import flash.utils.Timer;
  import funnel.*;
  import funnel.ui.*;

  public class ControlDCMotor extends Sprite {
    // 独立したPWMピンを用いないTA7291Pの場合にはfalseにする
    private static const useSeparatePWMPin:Boolean = true;

    // Arduino
    private var arduino:Arduino;

    // DCモータ
    private var dcMotor:DCMotor;

    // タイマ
    private var timer:Timer;

    // 現在の状態
    private var state:int = -1;

    // 現在の状態を表示するテキストフィールド
    private var textField:TextField;

    public function ControlDCMotor() {
      // IN1、IN2、PWMで使用するピンのモードをそれぞれセット
      var config:Configuration = Arduino.FIRMATA;
      config.setDigitalPinMode(9, PWM);
      config.setDigitalPinMode(10, PWM);
      config.setDigitalPinMode(11, PWM);
      arduino = new Arduino(config);

      if (useSeparatePWMPin) {
        // DCモータのインスタンスを生成（TB6612FNGの場合）
        dcMotor = new DCMotor(arduino.digitalPin(9), 
                              arduino.digitalPin(10),
                              arduino.digitalPin(11));
      } else {
        // DCモータのインスタンスを生成（TA7291Pの場合）
        dcMotor = new DCMotor(arduino.digitalPin(9), 
                              arduino.digitalPin(10),
                              null);
      }

      // 現在の状態を表示するテキストフィールドを追加
      textField = new TextField();
      addChild(textField);

      // 状態を一定時間ごとに変更するためのタイマを生成してスタート
      timer = new Timer(500);
      timer.addEventListener(TimerEvent.TIMER, onTimer);
      timer.start();
    }

    private function onTimer(e:TimerEvent):void {
      // イベントが発生したら状態を次に進める（0から3の間で繰り返す）
      state = (state + 1) % 4;

      switch (state) {
        case 0:  // 順方向に回転
          dcMotor.forward(0.3);
          textField.text = "Forward";
          break;
        case 1:  // 回転を停止（ブレーキあり）
          dcMotor.despin(true);
          textField.text = "Brake";
          break;
        case 2:  // 逆方向に回転
          dcMotor.reverse(0.3);
          textField.text = "Reverse";
          break;
        case 3:  // 回転を停止（ブレーキなし）
          dcMotor.despin(false);
          textField.text = "Standby";
          break;
      }
    }
  }
}
