/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h7EO
 */

// forked from Jacky.Riawan's pendulum
package 
{
    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2CircleDef;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import Box2D.Dynamics.Joints.b2DistanceJoint;
    import Box2D.Dynamics.Joints.b2DistanceJointDef;
    import flash.display.Sprite;
    import flash.events.Event;
    public class main extends Sprite 
    {
        private const ratio : uint = 30
        private var world : b2World;
        public function main() 
        {
            setupWorld()
            setupDebugDraw()
            addPendulum(100, 100, true)
            for (var i : int = 0; i < 25; i++)
            {
                addPendulum(111 + i * 11, 100)
            }
            addPendulum(375, 250, true, 1)
            for (i = 0; i < 25; i++)
            {
                addPendulum(100 + i * 11, 250)
            }
            addEventListener(Event.ENTER_FRAME, update)
        }
        private function update(e : Event) : void 
        {
            world.Step(1 / 20, 10)
        }
        private function addPendulum(posx : int, posy : int, first : Boolean = false, isLeft : int = -1) : void
        {
            var shiftx : int
            var shifty : int
            if (first) 
            {
                shiftx = 50 * isLeft
                shifty = 0
            }
            else 
            {
                shiftx = 0
                shifty = 50
            }
            var anchorBD : b2PolygonDef = new b2PolygonDef()
            anchorBD.SetAsBox(4 / ratio, 4 / ratio)
            var anchorB : b2BodyDef = new b2BodyDef()
            anchorB.position.Set(posx / ratio, posy / ratio)
            var anchor : b2Body = world.CreateBody(anchorB)
            anchor.CreateShape(anchorBD)
            anchor.SetMassFromShapes()
            var ballShape : b2CircleDef = new b2CircleDef()
            ballShape.radius = 5 / ratio
            ballShape.density = 100
            ballShape.friction = 0
            ballShape.restitution = 1
            var ballBD : b2BodyDef = new b2BodyDef()
            ballBD.position.Set((posx + shiftx) / ratio, (posy + shifty) / ratio)
            var ball : b2Body = world.CreateBody(ballBD)
            ball.SetBullet(true)
            ball.CreateShape(ballShape)
            ball.SetMassFromShapes()
            var jointDef : b2DistanceJointDef = new b2DistanceJointDef()
            jointDef.Initialize(anchor, ball, anchor.GetPosition(), ball.GetPosition())
            jointDef.dampingRatio = 1
            jointDef.frequencyHz = 100
            var joint : b2DistanceJoint = world.CreateJoint(jointDef) as b2DistanceJoint
        }
        private function setupDebugDraw() : void
        {
            var sprite : Sprite = new Sprite()
            addChild(sprite)
            var debugDraw : b2DebugDraw = new b2DebugDraw()
            debugDraw.m_drawScale = ratio
            debugDraw.m_sprite = sprite
            debugDraw.SetFlags(b2DebugDraw.e_jointBit|b2DebugDraw.e_shapeBit)
            world.SetDebugDraw(debugDraw)
        }
        private function setupWorld() : void
        {
            var AABB : b2AABB = new b2AABB()
            AABB.upperBound.Set( 1000 / ratio, 1000 / ratio)
            AABB.lowerBound.Set(-1000 / ratio, -1000 / ratio)
            world = new b2World(AABB, new b2Vec2(0, 15), false)
        }
    }
}
