/**
 * Copyright OKASUKE ( http://wonderfl.net/user/OKASUKE )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h6Zs
 */

// forked from Event's Button
/*
* AdobeButton
* Adobeより生まれしものそれは、続く・・・
* 
* 参考Pv3D オブジェクトの軸移動
* see http://blog.alumican.net/2009/03/31_134333
* 素材作り
* アイコンジェネレータ　http://icon-generator.net/
*
* パーティクルの量調整中です。
* 2010/09/28 OKASUKE
* 2010/09/29 重なっている蓋のちらつきをごまかしました。
*  
*/

package  
{
    import com.bit101.components.Label;
    import com.bit101.components.ProgressBar;
    import flash.display.*;    
    import flash.events.*;
    import flash.geom.*;    
    import flash.net.*;
    import flash.system.*;    
    
    import org.papervision3d.objects.DisplayObject3D;    
    import org.papervision3d.view.*;   
    import org.papervision3d.lights.*;    
    
    import idv.cjcat.stardust.common.clocks.SteadyClock;    
    import idv.cjcat.stardust.common.emitters.Emitter;
    import idv.cjcat.stardust.common.renderers.Renderer;  
    import idv.cjcat.stardust.threeD.papervision3d.renderers.PV3DDisplayObject3DRenderer;
    
    import jp.progression.commands.lists.SerialList;
    import jp.progression.commands.net.LoadBitmapData;
    import jp.progression.data.getResourceById;    
    
    import net.hires.debug.Stats;    
    
    [SWF(width="465", height="465", backgroundColor="#FFFFFF", frameRate="30")]     
    public class ButtonContainer extends BasicView
    {
        private var _light:PointLight3D;    
        private static const IMAGE_LIST:Array = [
            "http://assets.wonderfl.net/images/related_images/4/4b/4bb0/4bb014d76b957359d0e0ee432e43d0e8d6958630",    
            "http://assets.wonderfl.net/images/related_images/9/98/985f/985f8d20147ddefa9238f4cc4d4ff40a1bc74bac",    
            "http://assets.wonderfl.net/images/related_images/1/10/10c5/10c51d6cc6a9c6eb81c5a9aacccff8a230f1ebde",
            "http://assets.wonderfl.net/images/related_images/f/fd/fd20/fd209fcc4532bd265a761a955bda0b885d8be98e",
            "http://assets.wonderfl.net/images/related_images/b/bc/bcad/bcad44a813eb60966c79cc869505a6fb0033e9ab",
            "http://assets.wonderfl.net/images/related_images/9/96/96e9/96e97dd2b27daab15aa2183d0f2a18318950f04d",
            "http://assets.wonderfl.net/images/related_images/3/3e/3e49/3e4951dd9e09196811fa889a6c109738546ecb8c",
            "http://assets.wonderfl.net/images/related_images/6/62/6205/62057254156ea35c3b69937f53dadd270fb315bc",
            "http://assets.wonderfl.net/images/related_images/4/44/44ec/44ecab665f326f888a17ed5760a0b1906462f1aa"            
        ];
            
        private var _openbox:OpenBox;    
    
        private var _emitter:Emitter; 
        private var _particleRenderer:Renderer;         
        private var _container:DisplayObject3D;        
        
        private var _state:Stats;
        
        
        public function ButtonContainer() {
            super(0, 0, true, true);
            opaqueBackground = 0xFFFFFF;            
            getImage();
        }
        
        private function _init():void 
        {            
            //_state = new Stats();
            //addChild(_state);
                        
            //Light-Create
            _light = new PointLight3D(false);
            scene.addChild(_light);            
            
            viewport.buttonMode = true;                                    
            
            _openbox = new OpenBox(scene, arrImage[0] as BitmapData, _light);
            scene.addChild(_openbox);            
            
            //StardustObj-Create        
            _container = new DisplayObject3D();
            _container.rotationY = 180;
            scene.addChild(_container);        
            
            //Stardust-SystemCreate
            _emitter = new IconEmitter(new SteadyClock(0.3), arrImage, _light);             
            _particleRenderer = new PV3DDisplayObject3DRenderer(_container);
            _particleRenderer.addEmitter(_emitter);
                    
            startRendering();                
        
            _openbox.addEventListener(OpenBoxEvent.DOWN, downHandler);
            _openbox.addEventListener(OpenBoxEvent.UP, upHandler);    
            
            //Debug-Stardust
            //addEventListener(Event.ENTER_FRAME, StardustEnterframe);            
        }        
            
        private function downHandler(e:*):void {
            //TODO:なにかする？                        
        }        
        
        private function upHandler(e:*):void {          
                       
            GoOpen();
        }    
        
        private function GoOpen():void {    
            _openbox.moveopenCamera3D(camera);            
            _openbox.addEventListener(OpenBoxEvent.TWEENCOMP, StarDustRevolution);            
        }
        
        private function StarDustRevolution(e:*):void {
            
            addEventListener(Event.ENTER_FRAME, StardustEnterframe); 
            stage.addEventListener(MouseEvent.MOUSE_MOVE, StardustMouseMove);    
            //removeEventListener(Event.ENTER_FRAME, Looplight);
            _openbox.removeEventListener(OpenBoxEvent.TWEENCOMP, StarDustRevolution);               
        }    
        
        private function StardustEnterframe(e:*):void {        
            
            //EmitterUpdate
            _emitter.step();
            //微調整
            IconEmitter(_emitter)._point.x = Math.random() * 10;
            IconEmitter(_emitter)._point.y = Math.random() * 10;    
            _container.rotationY += 0.5;    
            _light.x = camera.x;
            _light.y = camera.y;
            _light.z = camera.z;
        }    
        
        private function StardustMouseMove(e:MouseEvent):void 
        {
           camera.x += (1000 * Math.sin(mouseX / stage.stageWidth * 360 * Math.PI / 180) - camera.x) * .1;
           camera.z += (1000 * Math.cos(mouseX / stage.stageWidth * 360 * Math.PI / 180) - camera.z)* .1;
           camera.y += (1000 * mouseY / stage.stageHeight - camera.y) * .1;
        }    
        
                
        private function getImage():void {            
            
            _progbar = new ProgressBar(this, 200, 200);    
            _progbar.visible = true;            
            
            var list:SerialList = new SerialList();    
            list.onPosition = function():void {
                _progbar.value = list.position / list.numCommands;                
            }
            for (var i:int = 0; i < IMAGE_LIST.length; i++) {
                list.addCommand(new LoadBitmapData(new URLRequest(IMAGE_LIST[i]), { context: new LoaderContext(true)}));
            } 
            list.onComplete = function():void {     ImageComplete(IMAGE_LIST); }
            list.onError = function():void { errimg();}
            list.execute();    
        }
        
        private var _progbar:ProgressBar;        
        private var arrImage:Vector.<BitmapData> = new Vector.<BitmapData>(); 
        private function ImageComplete(images:Array):void {
            _progbar.visible = false;            
            
            for (var i:int = 0; i < images.length; ++i) {
                //trace(images[i]);
                var bmd:BitmapData = getResourceById(images[i]).toBitmapData();    
                arrImage.push(bmd);
            }            
            _init();
        }
        
        private var _err:Label;
        private function errimg():void {            
            _err = new Label(this, 200, 200, "Error! Not Image");            
            _progbar.visible = false;            
        }        
    }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////    
    import flash.display.*;
    import flash.events.*;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.core.proto.CameraObject3D;
    import org.papervision3d.core.proto.DisplayObjectContainer3D;
    import org.papervision3d.lights.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.shaders.*;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.*;
    import org.papervision3d.events.InteractiveScene3DEvent;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.events.TweenEvent;    
    
    //ダンボール作成Class
    internal class OpenBox extends DisplayObject3D
    {
        private var _plane1:Plane;
        private var _plane2:Plane;
        private var _plane3:Plane;
        private var _plane4:Plane;
        
        private var _it1:ITween;
        private var _it2:ITween;
        private var _it3:ITween;
        private var _it4:ITween;
        private var _t:ITween;
        
        private var _plane:Array = [];
        private var _scene1:Scene3D
        private var _camera1:CameraObject3D;
        private var _light:PointLight3D;
        
        public function OpenBox(scene_:Scene3D, bmd_:BitmapData, light_:PointLight3D) 
        {
            _scene1 = scene_;
            _light = light_;        
            var f_material:FlatShadeMaterial= new FlatShadeMaterial(light_, 0xFFFFFF, 0x111111, 50);
            f_material.doubleSided = true;        
            
            var bitmat:BitmapMaterial = new BitmapMaterial(bmd_, true); 
            bitmat.smooth = true;           
            //何のShaderを使うか・・・?
            var shader:FlatShader = new FlatShader(light_, 0xFFFFFF, 0x000000, 0);                    
            var s_material:ShadedMaterial = new ShadedMaterial(bitmat, shader, 0);                
            s_material.oneSide = true;            
            s_material.interactive = true;                 
            
            // とりあえずダンボール作成
            for (var i:uint = 0; i <= 5; i++) {                
                
                if(i != 4) _plane[i] = new Plane(f_material, 200, 200, 6, 6);                    
                else _plane[i] = new Plane(s_material, 200, 200, 6, 6);                    
                
                _scene1.addChild(_plane[i]);                            
                if (i == 0) _plane[i].rotationY = 90, _plane[i].x = 100;
                else if (i == 1) _plane[i].rotationY = 90, _plane[i].x = -100;
                else if (i == 2) _plane[i].rotationX = 90, _plane[i].y = -100;
                else if (i == 3) _plane[i].z = 100;
                else if (i == 4) _plane[i].z = -100;    
                else if (i == 5) _plane[i].z = -99;//裏側にAdobeマークが表示されるのでもう一枚
            }
            
            //RIGHT            
            _plane1 = new Plane(f_material, 100, 200, 8, 8);
            _scene1.addChild(_plane1);
            _plane1.rotationX = 90;
            _plane1.y = 100;
            _plane1.x = 100;                
            jikuhenkou(-100, _plane1, true);            
            
            //LEFT        
            _plane2 = new Plane(f_material, 100, 200, 8, 8);
            _scene1.addChild(_plane2);        
            _plane2.rotationX = 90;
            _plane2.y = 100;
            _plane2.x = -100;
            jikuhenkou(100, _plane2, true);            
            
            //TOPFRONT            
            _plane3 = new Plane(f_material, 200, 99, 8, 8);
            _scene1.addChild(_plane3);
            _plane3.rotationX = 90;
            _plane3.y = 0;
            _plane3.z = 100;                
            jikuhenkou( -100, _plane3, false);
            
            //TOPBACK            
            _plane4 = new Plane(f_material, 200, 99, 8, 8);
            _scene1.addChild(_plane4);
            _plane4.rotationX = 90;
            _plane4.y = 0;
            _plane4.z = -100;            
            jikuhenkou( 100, _plane4, false);    
            
            
            _plane[4].addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, downHandler);
            _plane[4].addEventListener(InteractiveScene3DEvent.OBJECT_RELEASE, upHandler);            
            //addEventListener(Event.ENTER_FRAME, lightloop);                       
        }
            
        private function jikuhenkou(beforeWidth:Number, obj3d:DisplayObject3D, flg:Boolean):void {
            var offset:Number = beforeWidth / 2;
            var v:Vertex3D;
            
            if(flg) {
                for each (v in obj3d.geometry.vertices) v.x += offset;                
            } else {            
                for each (v in obj3d.geometry.vertices) v.y += offset;
            }
        }
        
        private function downHandler(e:*):void {                
            var event:OpenBoxEvent = new OpenBoxEvent(OpenBoxEvent.DOWN);               
            dispatchEvent( event );
        }
        
        private function upHandler(e:*):void {
            _plane[4].removeEventListener(InteractiveScene3DEvent.OBJECT_PRESS, downHandler);
            _plane[4].removeEventListener(InteractiveScene3DEvent.OBJECT_RELEASE, upHandler);
            
            //わざわざdispatchEventせずにここでmoveCameraを動かすほうがいいような気がす今日この頃・・・
            var event:OpenBoxEvent = new OpenBoxEvent(OpenBoxEvent.UP);               
            dispatchEvent( event );        
        }
        
        private function moveCamera():void {            
            //var tweens1:Vector.<BetweenAS3> = new Vector.<BetweenAS3>();
            var tweens1:Array = [];
            tweens1.push(BetweenAS3.tween(_plane1, { rotationZ: -210 }, null, 2, Quart.easeInOut ),
                        BetweenAS3.tween(_plane2, { rotationZ: 210 }, null, 2, Quart.easeInOut ),
                        BetweenAS3.tween(_plane3, { y: 100 }, null, 1, Quart.easeInOut),
                        BetweenAS3.tween(_plane4, { y: 100 }, null, 1, Quart.easeInOut)
                        );
            var tweens2:Array = [];
            
            tweens2.push(BetweenAS3.tween(_plane3, { rotationX: 320 }, null, 5, Quart.easeOut ),
                        BetweenAS3.tween(_plane4, { rotationX: -140 }, null, 5, Quart.easeOut ),
                        BetweenAS3.parallel(BetweenAS3.bezierTo(_camera1, { x:900, y:900, z:900, rotationX:360, rotationZ:360 }, null, 5, Quart.easeOut)
                        ,BetweenAS3.bezierTo(_light, { x:900, y:900, z:900, rotationX:360, rotationZ:360 }, null, 5, Quart.easeOut))); //ok
                
            _it1 = BetweenAS3.parallel(BetweenAS3.bezierTo(_camera1, { x:300, y:300, z:0, rotationX:180, rotationZ:180 },  null, 3, Quart.easeInOut),
                    BetweenAS3.bezierTo(_light, {x:300, y:300, z:0,  rotationX:180, rotationZ:180 }, null, 4, Quart.easeOut));
            
            _it2 = BetweenAS3.parallelTweens(tweens1);                    
            _it4 = BetweenAS3.parallelTweens(tweens2);            
            
            _t = BetweenAS3.serial(_it1, _it2, _it4);            
            _t.play();
            
            _t.addEventListener(TweenEvent.COMPLETE, tweenComp);
        }            
            
        public function moveopenCamera3D(camera_:CameraObject3D):void {
            _camera1 = camera_; //セッター的な・・・            
            moveCamera();            
        }
        
        private function tweenComp(e:TweenEvent):void {                    
            _t.removeEventListener(TweenEvent.COMPLETE, tweenComp);
            var event:OpenBoxEvent = new OpenBoxEvent(OpenBoxEvent.TWEENCOMP);               
            dispatchEvent( event );    
        }
        
        
    }

////////////////////////////////////////////////////////////////////////////////////////////////////////////
    import org.papervision3d.objects.DisplayObject3D;
    import flash.events.Event;          
        
    class OpenBoxEvent extends Event{      
        public static const DOWN:String = "BoxDown";
        public static const UP:String = "BoxUp";   
        public static const TWEENCOMP:String = "TweenComplete";
       
        private var _box:DisplayObject3D;        
       
        function OpenBoxEvent( type:String, bubbles:Boolean = false, cancelable:Boolean = false ){
            super( type , bubbles , cancelable );
        }         
    }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

    import adobe.utils.CustomActions;
    import flash.display.BitmapData;
    import idv.cjcat.stardust.common.actions.*;
    import idv.cjcat.stardust.common.clocks.*;
    import idv.cjcat.stardust.common.initializers.*;
    import idv.cjcat.stardust.common.math.*;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shaders.ShadedMaterial;
    
    import idv.cjcat.stardust.threeD.actions.*;
    import idv.cjcat.stardust.threeD.deflectors.*;
    import idv.cjcat.stardust.threeD.emitters.*;
    import idv.cjcat.stardust.threeD.fields.*;
    import idv.cjcat.stardust.threeD.initializers.*;
    import idv.cjcat.stardust.threeD.papervision3d.initializers.*;
    import idv.cjcat.stardust.threeD.papervision3d.renderers.*;
    import idv.cjcat.stardust.threeD.zones.*;    
    import org.papervision3d.objects.primitives.Plane;    
    
    //アレンジエミッタークラス
    class IconEmitter extends Emitter3D {
        public var _point:SinglePoint3D = new SinglePoint3D();//あとで微調整用

        public function IconEmitter(clock:Clock, v_mat:Vector.<BitmapData>, light_:PointLight3D) {
            super(clock);

            _point.y = -15;
            addInitializer(new Position3D(_point));            
            
            var displayObject3DClass_FL:PV3DDisplayObject3DClass = new PV3DDisplayObject3DClass(SratdustPlane, [v_mat[1], light_]);        
            var displayObject3DClass_AI:PV3DDisplayObject3DClass = new PV3DDisplayObject3DClass(SratdustPlane, [v_mat[2], light_]);
            var displayObject3DClass_PS:PV3DDisplayObject3DClass = new PV3DDisplayObject3DClass(SratdustPlane, [v_mat[3], light_]);
            var displayObject3DClass_DW:PV3DDisplayObject3DClass = new PV3DDisplayObject3DClass(SratdustPlane, [v_mat[4], light_]);
            var displayObject3DClass_AE:PV3DDisplayObject3DClass = new PV3DDisplayObject3DClass(SratdustPlane, [v_mat[5], light_]);
            var displayObject3DClass_FB:PV3DDisplayObject3DClass = new PV3DDisplayObject3DClass(SratdustPlane, [v_mat[6], light_]);
            var displayObject3DClass_FD:PV3DDisplayObject3DClass = new PV3DDisplayObject3DClass(SratdustPlane, [v_mat[7], light_]);
            var displayObject3DClass_FDT:PV3DDisplayObject3DClass = new PV3DDisplayObject3DClass(SratdustPlane, [v_mat[8], light_]);
            
            var compInitFL:CompositeInitializer = new CompositeInitializer();
            compInitFL.addInitializer(new Position3D(_point));
            compInitFL.addInitializer(displayObject3DClass_FL);
            var compInitAI:CompositeInitializer = new CompositeInitializer();
            compInitAI.addInitializer(new Position3D(_point));
            compInitAI.addInitializer(displayObject3DClass_AI);
            var compInitPS:CompositeInitializer = new CompositeInitializer();
            compInitPS.addInitializer(new Position3D(_point));
            compInitPS.addInitializer(displayObject3DClass_PS);
            var compInitDW:CompositeInitializer = new CompositeInitializer();
            compInitDW.addInitializer(new Position3D(_point));
            compInitDW.addInitializer(displayObject3DClass_DW);
            var compInitAE:CompositeInitializer = new CompositeInitializer();
            compInitAE.addInitializer(new Position3D(_point));
            compInitAE.addInitializer(displayObject3DClass_AE);
            var compInitFB:CompositeInitializer = new CompositeInitializer();
            compInitFB.addInitializer(new Position3D(_point));
            compInitFB.addInitializer(displayObject3DClass_FB);
            var compInitFD:CompositeInitializer = new CompositeInitializer();
            compInitFD.addInitializer(new Position3D(_point));
            compInitFD.addInitializer(displayObject3DClass_FD);
            var compInitFDT:CompositeInitializer = new CompositeInitializer();
            compInitFDT.addInitializer(new Position3D(_point));
            compInitFDT.addInitializer(displayObject3DClass_FDT);                
            
            var switchInit:SwitchInitializer = new SwitchInitializer([compInitFL, compInitAI,
            compInitPS,compInitDW,compInitAE,compInitFB,compInitFD,compInitFDT],[0.3,0.1,0.1,0.1,0.1,0.1,0.1,0.1]);
            addInitializer(switchInit);
            addInitializer(new Life(new UniformRandom(60, 20)));            
            
            var cap:SphereCap = new SphereCap(-30, 0, 0, 30, 60, 30);
            cap.rotationX = 180;            
            addInitializer(new Velocity3D(cap));
            
            addAction(new Age()); 
            addAction(new DeathLife());
            addAction(new Accelerate3D(0.1)); 
            addAction(new Move3D());            
            addAction(new ScaleCurve(10, 40));
            
            var field:UniformField3D = new UniformField3D(0, -1, 0);
            var gravity:Gravity3D = new Gravity3D();
            gravity.addField(field);
            addAction(gravity);            
        }
    }
    
///////////////////////////////////////////////////////////////////////////////////////////////////
    import flash.display.BitmapData;
    
        
    import org.papervision3d.materials.BitmapMaterial;    
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.materials.shaders.FlatShader;
    import org.papervision3d.materials.shaders.ShadedMaterial;    
    import org.papervision3d.lights.PointLight3D;
    
    import org.papervision3d.materials.ColorMaterial;
    
    class SratdustPlane extends Plane
    {
        
        public function SratdustPlane(bmd_:BitmapData, light_:PointLight3D) 
        {
                        
            var bitmat:BitmapMaterial = new BitmapMaterial(bmd_);
            bitmat.doubleSided = true;
            bitmat.smooth = true;
            //shaderはやめました
            //var shader:FlatShader = new FlatShader(light_, 0xFFFFFF, 0x000000, 0);                    
            //var s_material:ShadedMaterial = new ShadedMaterial(bitmat, shader, 0);            
            super(bitmat, 200, 200, 2, 2);
        }        
    }
    
    