/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h6JW
 */

// forked from makc3d's forked from: Nonstop-motion
// forked from civet's Nonstop-motion
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.DropShadowFilter;
	import flash.geom.Matrix;
	import flash.net.NetStream;
	import flash.system.Security;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.ui.Keyboard;
	import flash.utils.Timer;
	
	[SWF(backgroundColor="0xffffff", frameRate="25")]
	
	public class BadAppleAgain extends Sprite
	{
		private var VIDEO_WIDTH:int = 120 * 4;
		private var VIDEO_HEIGHT:int = 68 * 4;
		
		private var player:VideoPlayer;
		private var stream:NetStream;
		
		public function BadAppleAgain()
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			Security.loadPolicyFile("http://cdn1.akamai.coub.com/crossdomain.xml");
			init();
		}
		
		private function init():void
		{
			//Video
			player = new VideoPlayer(VIDEO_WIDTH, VIDEO_HEIGHT, VideoPlayer.EXACT_FIT);
//			player.addEventListener(Event.OPEN, onOpen);
//			player.addEventListener(Event.COMPLETE, onComplete);
			addChild(player);

			
			//start
			stream = player.play("http://cdn1.akamai.coub.com/coub/simple/cw_audio/9fc0ef8630c/ffd419dd394e89f03518d/flv_mid_c1_1391614049_out.flv");
		}
		
	}
}


import flash.display.Shape;
import flash.display.Sprite;
import flash.events.AsyncErrorEvent;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.NetStatusEvent;
import flash.media.SoundTransform;
import flash.media.Video;
import flash.net.NetConnection;
import flash.net.NetStream;

/**
 * FLV Player
 * @author civet
 */
class VideoPlayer extends Sprite
{
	public static const NO_SCALE:int = 0;
	public static const EXACT_FIT:int = 1;
	public static const MAINTAIN_ASPECT_RATIO:int = 2;
	
	public var meta:Object = {};
	private var stream:NetStream;
	private var _volume:Number = 1.0;
	private var _scaleMode:int = 0;
	private var video:Video;
	private var block:Shape;
	
	public function VideoPlayer(blockWidth:int, blockHeight:int, scaleMode:int=0)
	{
		this._scaleMode = scaleMode;
		
		block = new Shape();
		addChild(block);
		block.graphics.clear();
		block.graphics.beginFill(0);
		block.graphics.drawRect(0, 0, blockWidth, blockHeight);
		block.graphics.endFill();
		
		var nc:NetConnection = new NetConnection();
		nc.connect(null);
		stream = new NetStream(nc);
		stream.addEventListener(AsyncErrorEvent.ASYNC_ERROR, asyncErrorHandler);
		stream.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
		stream.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
		stream.client = this;
		
		video = new Video();
		video.smoothing = true; //bug: [FP-178] Video.clear() fails, fp10.1 fixed
		addChild(video);
		
		video.attachNetStream(stream);
	}
	
	public function play(url:String=""):NetStream
	{
		if(url != "") {
			stream.play(url);
		}
		else {
			stream.resume();
		}
		return stream;
	}
	
	public function stop():void
	{
		stream.close();
		video.clear();
	}
	
	public function pause():void
	{
		stream.pause();
	}
	
	public function get volume():Number
	{
		return stream.soundTransform.volume;
	}
	
	public function set volume(value:Number):void
	{
		_volume = value;
		
		var t:SoundTransform = stream.soundTransform;
		t.volume = _volume;
		stream.soundTransform = t;
	}
	
	private function resizeVideo(videoWidth:int, videoHeight:int):void
	{
		if(video.videoWidth != 0) videoWidth = video.videoWidth;
		if(video.videoHeight != 0) videoHeight = video.videoHeight;
		var w:Number;
		var h:Number;
		if(_scaleMode == NO_SCALE) {
			w = videoWidth;
			h = videoHeight;
			video.width = w;
			video.height = h;
			video.x = int((block.width - w) /2) + block.x;
			video.y = int((block.height - h) /2) + block.y;
		}
		else if(_scaleMode == EXACT_FIT) {
			video.width = block.width;
			video.height = block.height;
			video.x = block.x;
			video.y = block.y;
		}
		else if(_scaleMode == MAINTAIN_ASPECT_RATIO) {
			w = (videoWidth / videoHeight) * block.height;
			h = block.height;
			if(w > block.width) {
				w = block.width;
				h = (videoHeight / videoWidth) * block.width;
			}
			video.width = w;
			video.height = h;
			video.x = int((block.width - w) /2) + block.x;
			video.y = int((block.height - h) /2) + block.y;
		}
		
		this.dispatchEvent(new Event(Event.RESIZE));
	}
	
	private function asyncErrorHandler(e:AsyncErrorEvent):void {
		//ignore error
	}
	
	private function ioErrorHandler(e:IOErrorEvent):void {
		trace(e.text);
	}
	
	private function netStatusHandler(e:NetStatusEvent):void
	{
		switch(e.info.code) {
			case "NetStream.Play.Stop":
				dispatchEvent(new Event(Event.COMPLETE));
				break;
			case "NetStream.Play.Start":
				dispatchEvent(new Event(Event.OPEN));			
				break;
		}
	}
	
	/* NetStream client Event Hanlders */
	public function onMetaData(info:Object):void {
		//trace("metadata: duration=" + info.duration + " width=" + info.width + " height=" + info.height + " framerate=" + info.framerate);
		meta = info;
		resizeVideo(info.width, info.height);
	}
	
	public function onCuePoint(info:Object):void {
		//trace("cuepoint: time=" + info.time + " name=" + info.name + " type=" + info.type);
	}
}