/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h66r
 */

package {
    
    import flash.display.Sprite
    import flash.display.MovieClip
    import flash.events.Event
    import flash.events.MouseEvent
    import flash.events.KeyboardEvent
    import flash.ui.Keyboard
    import flash.text.TextField
    
    [SWF(width=400, height=400, backgroundColor=0x000000)]
    
    // [유지]
    // 화면을 누르면 누른 지점을 기점으로 대형을 이룬다
    // 화면을 더블 클릭하면 흩어진다
    // 유닛이 목적지까지 일정 속도로 움직인다
    // 왼쪽, 오른쪽 방향키를 누르면 화면을 누를 때 이루는 대형이 바뀐다
    // 원을 이루는 대형을 추가했다
    // 대형 종류를 화면 왼쪽 위에 텍스트로 표시한다
    
    // [추가]
    // 화면 위의 텍스트 필드에 숫자를 입력하고 엔터를 눌러 유닛 수를 바꿀 수 있다
    
    public class FlashTest extends Sprite {
        
        private var formations:Array = [f0, f1]
        private var formationIndex:int = 0
        private var formationView:TextField
        
        private var numInput:TextField
        private var unitContainer:Sprite
        
        public function FlashTest() {
            makeUnits(67) // 인자는 유닛 개수
            setMouseAction()
            setKeyboardAction()
        }
        
        private function makeUnits(num:uint):void {
            unitContainer = addChild(new Sprite()) as Sprite
            unitContainer.mouseEnabled = false
            unitContainer.mouseChildren = false
            var unit:MovieClip
            for(var i:int=0 ; i<num ; i++){
                unit = new MovieClip()
                unit.graphics.beginFill(0xff0000, 1)
                unit.graphics.drawCircle(0, 0, 5)
                unit.graphics.endFill()
                unit.x = unit.destX = Math.random() * stage.stageWidth
                unit.y = unit.destY = Math.random() * stage.stageHeight
                unit.vx = unit.vy = 0
                unitContainer.addChild(unit)
            }
            unitContainer.addEventListener("enterFrame", moveUnitsToDest)
        }
        
        private function setMouseAction():void {
            stage.addEventListener("mouseDown", setDestination)
            function setDestination(e:MouseEvent):void {
                if(e.target == stage) formations[formationIndex](e.stageX, e.stageY)
            }
            
            stage.doubleClickEnabled = true
            stage.addEventListener("doubleClick", scatterUnits)
            function scatterUnits(e:Event):void {
                var unit:MovieClip
                for(var i:int=0 ; i<unitContainer.numChildren ; i++){
                    unit = unitContainer.getChildAt(i) as MovieClip
                    unit.destX = Math.random() * stage.stageWidth
                    unit.destY = Math.random() * stage.stageHeight
                }
            }
        }
        
        private function setKeyboardAction():void {
            formationView = addChild(new TextField()) as TextField
            formationView.autoSize = "left"
            formationView.selectable = false
            formationView.textColor = 0xffffff
            formationView.text = "formation : 0"
            formationView.mouseEnabled = false
            stage.addEventListener("keyDown", changeFormation)
            function changeFormation(e:KeyboardEvent):void {
                switch(e.keyCode){
                    case Keyboard.LEFT :
                        formationIndex --
                        if(formationIndex == -1) formationIndex = formations.length - 1
                        break
                    case Keyboard.RIGHT :
                        formationIndex ++
                        if(formationIndex == formations.length) formationIndex = 0
                        break
                }
                formationView.text = "formation : " + formationIndex
            }
            
            var cap:TextField = addChild(new TextField()) as TextField
            cap.selectable = false
            cap.autoSize = "left"
            cap.y = 20
            cap.textColor = 0xffffff
            cap.mouseEnabled = false
            cap.text = "write number of units and enter"
            
            numInput = addChild(new TextField()) as TextField
            numInput.text = "67"
            numInput.type = "input"
            numInput.autoSize = "left"
            numInput.background = true
            numInput.backgroundColor = 0xffff00
            numInput.textColor = 0x000000
            numInput.x = 160
            numInput.y = 20
            numInput.restrict = "0-9"
            numInput.addEventListener("keyDown", changeNumUnits)
            function changeNumUnits(e:KeyboardEvent):void {
                if(e.keyCode == Keyboard.ENTER){
                    for(;unitContainer.numChildren;) unitContainer.removeChildAt(0)
                    var unit:MovieClip
                    for(var i:int=0 ; i<int(numInput.text) ; i++){
                        unit = new MovieClip()
                        unit.graphics.beginFill(0xff0000, 1)
                        unit.graphics.drawCircle(0, 0, 5)
                        unit.graphics.endFill()
                        unit.x = unit.destX = Math.random() * stage.stageWidth
                        unit.y = unit.destY = Math.random() * stage.stageHeight
                        unit.vx = unit.vy = 0
                        unitContainer.addChild(unit)
                    }
                }
            }
        } // setKeyboardAction() 끝
        
        private function moveUnitsToDest(e:Event):void {
            var speedX:Number = 5
            var speedY:Number = 5
            var unit:MovieClip
            for(var i:int=0 ; i<unitContainer.numChildren ; i++){
                unit = unitContainer.getChildAt(i) as MovieClip
                if(unit.x < unit.destX){
                    if(unit.destX - unit.x > speedX) unit.vx = speedX
                    else unit.vx = unit.destX - unit.x
                }
                else if(unit.x > unit.destX){
                    if(unit.x - unit.destX > speedX) unit.vx = -speedX
                    else unit.vx = unit.destX - unit.x
                }
                if(unit.y < unit.destY){
                    if(unit.destY - unit.y > speedY) unit.vy = speedY
                    else unit.vy = unit.destY - unit.y
                }
                else if(unit.y > unit.destY){
                    if(unit.y - unit.destY > speedY) unit.vy = -speedY
                    else unit.vy = unit.destY - unit.y
                }
                if(Math.abs(unit.x-unit.destX)<0.05) unit.vx = 0
                if(Math.abs(unit.y-unit.destY)<0.05) unit.vy = 0
                unit.x += unit.vx
                unit.y += unit.vy
            }
        }

        
        // setFormation 시리즈 /////////////////////////////////////////////////////
        // 직사각형
        private function f0(destX:Number, destY:Number):void {
            var numColumns:int = Math.sqrt(unitContainer.numChildren)
            var numRows:int = unitContainer.numChildren / numColumns
            var numMods:int = unitContainer.numChildren - numColumns*numRows
            var spaceX:Number = 10
            var spaceY:Number = 10
            var LT_x:Number = destX - numRows*spaceX/2
            var LT_y:Number = destY - numColumns*spaceY/2
            
            var unit:MovieClip, count:int=0
            for(var column:int=0 ; column<numColumns ; column++){
                for(var row:int=0 ; row<numRows ; row++){
                    unit = unitContainer.getChildAt(count) as MovieClip
                    unit.destX = LT_x + row*spaceX
                    unit.destY = LT_y + column*spaceY
                    count ++
                }
            }
            if(count < unitContainer.numChildren){
                for(var i:int=0 ; i<unitContainer.numChildren-numRows*numColumns ; i++){
                    unit = unitContainer.getChildAt(count) as MovieClip
                    unit.destX = LT_x + i*spaceX
                    unit.destY = LT_y + numColumns*spaceY
                    count ++
                }
            }
        }
        
        // 원
        private function f1(destX:Number, destY:Number):void {
            var radius:Number = unitContainer.numChildren * 2
            var unit:MovieClip
            for(var i:int=0 ; i<unitContainer.numChildren ; i++){
                  unit = unitContainer.getChildAt(i) as MovieClip
                  unit.destX = destX + radius * Math.cos(2*Math.PI*i/unitContainer.numChildren)
                  unit.destY = destY + radius * Math.sin(2*Math.PI*i/unitContainer.numChildren)
            }
        }
        
    }
    
}