/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h635
 */

package  {
    import com.bit101.components.HUISlider;
    import com.bit101.components.RotarySelector;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BitmapFilter;
    import flash.filters.BitmapFilterType;
    import flash.filters.GradientGlowFilter;

    public class GradientGlowSimpleExplorer extends Sprite {
        private var bgColor:uint = 0xFFCC00;
        private var size:uint    = 80;
        private var strength:Number;
        private var blur:Number=0;
        private var quality:Number;
        private var colorssprite:Sprite;
        private var filtered:Sprite;

        public function GradientGlowSimpleExplorer() 
        {
            draw();
            
            
            new HUISlider(this, 0, 0, "strength", doStrength).value = strength = 70;
            new HUISlider(this, 0, 20, "blur", doBlur).value = blur = 50;
            var qualityRotarySelector:RotarySelector = new RotarySelector(this, 200, 10, 'quality', doQuality);
            qualityRotarySelector.numChoices = 3;
            qualityRotarySelector.labelMode = RotarySelector.NUMERIC;
            quality = 1
            qualityRotarySelector.choice = quality;
            
            colorssprite = addChild(new Sprite) as Sprite;
            setFilter()
        }
        
        private function doQuality(e:Event):void 
        {
            quality = RotarySelector(e.target).choice+1;
            setFilter();
        }
        
        private function doStrength(e:Event):void 
        {
            strength = (e.target as HUISlider).value;
            setFilter();
        }
        
        private function doBlur(e:Event):void 
        {
            blur = (e.target as HUISlider).value;
            setFilter();
        }

        private function getBitmapFilter():BitmapFilter {
            var color:Number = 0x33CCFF;
            var alpha:Number = 0.8;
            var blurX:Number = blur;
            var blurY:Number = blur;
            var inner:Boolean = false;
            var knockout:Boolean = false;
            //quality = BitmapFilterQuality.MEDIUM;
            trace( "quality : " + quality );
            
            var filter:GradientGlowFilter = new GradientGlowFilter();
            filter.distance = 0;
            filter.strength = strength;
            filter.colors = [0xff0000, 0x00ff00, 0x0000ff, 0xff7f00];
            filter.alphas = [0, .6, .9, 1];
            filter.ratios = [0, 50, 100, 255];
            filter.type = BitmapFilterType.FULL;
            filter.blurX = blur;
            filter.blurY = blur;
            filter.quality = quality;
            filter.knockout = false;
            
            if(colorssprite){
            var g:Graphics = colorssprite.graphics;
            g.clear();
            var ww:Number = 75;
            var gap:Number = 5;
            for (var i:int = 0; i < filter.colors.length; i++) 
            {
                g.beginFill(filter.colors[i])
                g.drawRect(10+(ww+gap) * i, 300, ww, ww);
            }
            }
            return filter;                      
        }

        private function draw():void {
            filtered = addChild(new Sprite) as Sprite;
            filtered.y = 100;
            filtered.x = 75;
            var g:Graphics = filtered.graphics;
            g.beginFill(bgColor);
            g.drawRect(0, 0, size, size);
            g.endFill();
        }
        
        private function setFilter():void 
        {
            filtered.filters = [getBitmapFilter()];
        }
    }
}