/**
 * Copyright krogue ( http://wonderfl.net/user/krogue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h5Sv
 */

/**
 * #20 ChikaChika
 * 
 * チカチカするので注意してください。
 * 
 * @author krogue
 */
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", backgroundColor="0", frameRate="60")]
    public class Main extends Sprite
    {
        private var frame:int = 0;
        private var chika:Chika;
        
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        }
        
        private function addedToStageHandler(event:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
            initialize();
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(event:Event):void
        {
            update();
        }
        
        private function initialize():void
        {
            chika = addChild(new Chika()) as Chika;
//            addChild(new Stats());
            addEventListener(MouseEvent.CLICK, clickHandler);
        }
        
        private function update():void
        {
            chika.update();
            frame = (frame + 1 == 60 ? 0 : frame + 1);
        }
        
        private function clickHandler(event:MouseEvent):void
        {
            chika.setAnchor(event.stageX, event.stageY);
        }
    }
}

import __AS3__.vec.Vector;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.geom.ColorTransform;
import flash.geom.Point;

class Chika extends Sprite
{
    private var bitmap:Bitmap = addChild(new Bitmap()) as Bitmap;
    private var particles:Vector.<Particle>;
    private var point:Point = new Point(465 / 2, 465 / 2);
    private var colors:Array /* of ColorTransform */ =
    [
        new ColorTransform(0.98, 0.9, 0.9),
        new ColorTransform(0.98, 0.98, 0.9),
        new ColorTransform(0.9, 0.98, 0.9),
        new ColorTransform(0.9, 0.98, 0.98),
        new ColorTransform(0.9, 0.9, 0.98),
        new ColorTransform(0.98, 0.9, 0.98)
    ];
    private var colorIndex:int = 0;
    
    public function Chika()
    {
        var bmd:BitmapData = new BitmapData(465, 465, false, 0x000000);
        bmd.lock();
        particles = buildParticles();
        bmd.unlock();
        bitmap.bitmapData = bmd;
    }
    
    public function update():void
    {
        var bmd:BitmapData = bitmap.bitmapData;
        bmd.lock();
        bmd.colorTransform(bmd.rect, colors[colorIndex]);
        for each (var p:Particle in particles)
        {
            var a:Number = Math.atan2(point.y - p.y, point.x - p.x);
            
            p.ax = Math.cos(a);
            p.ay = Math.sin(a);
            p.vx += p.ax;
            p.vy += p.ay;
            p.x += p.vx;
            p.y += p.vy;
            p.vx *= 0.995;
            p.vy *= 0.995;
//            最初は上下左右をつなげた何かを作ろうと思ったが中止
//            p.x = (p.x < 0 ? 465 + p.x : (p.x >= 465 ? p.x - 465 : p.x));
//            p.y = (p.y < 0 ? 465 + p.y : (p.y >= 465 ? p.y - 465 : p.y));
            bmd.setPixel(p.x, p.y, 0xFFFFFF);
        }
        bmd.unlock();
    }
    
    public function setAnchor(x:Number, y:Number):void
    {
        if (++colorIndex == colors.length)
            colorIndex = 0;
        point = new Point(x, y);
        particles = buildParticles();
    }
    
    private function buildParticles():Vector.<Particle>
    {
        var particles:Vector.<Particle> = new Vector.<Particle>(1000, true);
        var n:int = particles.length;
        for (var i:int = 0; i < n; i++)
        {
            var p:Particle = new Particle();
            var radians:Number = Math.random() * 2 * Math.PI;
            p.ax = 0;
            p.ay = 0;
            p.vx = Math.cos(radians);
            p.vy = Math.sin(radians);
            p.x = Math.random() * 465;
            p.y = Math.random() * 465;
            particles[i] = p;
        }
        return particles;
    }
}

class Particle
{
    public var x:Number;
    public var y:Number;
    public var ax:Number;
    public var ay:Number;
    public var vx:Number;
    public var vy:Number;
}
