/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h5Rl
 */

package {
    import alternativ7.engine3d.containers.DistanceSortContainer;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.View;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Vector3D;
    import idv.cjcat.stardust.threeD.alternativa3d.handlers.Alternativa3DObject3DHandler;
    
    [SWF(width="465", height="465", bakcgroundColor="0xffffff", frameRate="60")]
    
    public class FlashTest extends Sprite {
        private var _emitter:Alternativa3DEmitter;
        private var _camera:Camera3D;
        private var _container:DistanceSortContainer;
        private var _controller:SimpleObjectController;
        
        public function FlashTest() {
            if(stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);            
        }
        
        private function init(event:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.align = StageAlign.TOP_LEFT;
            stage.frameRate = 60;
            
            var g:Graphics = graphics;
            g.beginFill(0x000000);
            g.drawRect(0, 0, 465, 465);
            
            _container = new DistanceSortContainer();
            _container.sortByZ = true;
            
            _camera = new Camera3D();
            _camera.view = new View(465, 465);
            _camera.y = 0;
            _camera.z = -400;
            _container.addChild(_camera);
            
            _controller = new SimpleObjectController(stage, _camera, 200);
            _controller.mouseSensitivity = 0.1;
            _controller.lookAtXYZ(0, 0, 0);
            
            _emitter = new Alternativa3DEmitter();
            _emitter.particleHandler = new Alternativa3DObject3DHandler(_container);
            
            addChild(_camera.view);
            
            addEventListener(Event.ENTER_FRAME, mainLoop);
        }
        
        private function mainLoop(event:Event):void
        {
            _emitter.step();
            _controller.update();
            _camera.render();
        }
    }
}

import alternativ7.engine3d.core.Sorting;
import alternativ7.engine3d.materials.FillMaterial;
import alternativ7.engine3d.materials.Material;
import alternativ7.engine3d.primitives.Box;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.AlphaCurve;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.clocks.SteadyClock;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.threeD.actions.Deflect3D;
import idv.cjcat.stardust.threeD.actions.Move3D;
import idv.cjcat.stardust.threeD.actions.Spin3D;
import idv.cjcat.stardust.threeD.alternativa3d.initializers.Alternativa3DObject3DClass;
import idv.cjcat.stardust.threeD.deflectors.BoundingSphere;
import idv.cjcat.stardust.threeD.emitters.Emitter3D;
import idv.cjcat.stardust.threeD.initializers.Omega3D;
import idv.cjcat.stardust.threeD.initializers.Position3D;
import idv.cjcat.stardust.threeD.initializers.Rotation3D;
import idv.cjcat.stardust.threeD.initializers.Velocity3D;
import idv.cjcat.stardust.threeD.zones.SphereCap;
import idv.cjcat.stardust.threeD.zones.SphereZone;

internal class Alternativa3DEmitter extends Emitter3D
{
    public function Alternativa3DEmitter()
    {
        super(new SteadyClock(1));
        
        addInitializer(new Alternativa3DObject3DClass(BoxParticle));
        addInitializer(new Position3D(new SphereCap(0,0,0,30,40,15)));
        var omegaRand:UniformRandom = new UniformRandom(0, 10);
        addInitializer(new Omega3D(omegaRand, omegaRand, omegaRand));
        addInitializer(new Velocity3D(new SphereZone(0, 0, 0, 10)));
        addInitializer(new Life(new UniformRandom(100, 50)));
        var rotRand:UniformRandom = new UniformRandom(0, 180);
        addInitializer(new Rotation3D(rotRand, rotRand, rotRand));
        addInitializer(new Scale(new UniformRandom(1.2, 0.2)));
        
        addAction(new Age());
        addAction(new DeathLife());
        addAction(new Move3D());
        addAction(new Spin3D());
        addAction(new ScaleCurve(10, 10));
        addAction(new AlphaCurve(10, 10));
        var deflect:Deflect3D = new Deflect3D();
        deflect.addDeflector(new BoundingSphere(0, 0, 0, 300));
        addAction(deflect);
    }
}

internal class BoxParticle extends Box
{
    public static const MATERIAL:Vector.<Material> = Vector.<Material>([new FillMaterial(0x000000, 1, 2, 0xFFFFFF),
                                                                        new FillMaterial(0xFFFFFF, 1, 2, 0x000000)]);
    public function BoxParticle():void
    {
        super(30, 30, 30, 1, 1, 1);
        setMaterialToAllFaces(MATERIAL[Math.random() * 2 >> 0]);
    }

}
