/**
 * Copyright diverses ( http://wonderfl.net/user/diverses )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h4mb
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    [SWF(width='465', height='465', backgroundColor='#000000', frameRate='30')]
    public class Sketch1 extends Sprite {
        
	private var circlesArray:Array;
	private var numCircle:uint = 40;
	private var canvas:Bitmap;
	private var canvasBitmapData:BitmapData;
	private var linecount:uint=0;
        
        public function Sketch1() 
        {
         	addEventListener(Event.ADDED_TO_STAGE,onAddedToStageHandler);
        }
        
        private function onAddedToStageHandler(e:Event):void
        {	
            removeEventListener (Event.ADDED_TO_STAGE,onAddedToStageHandler);      
            stage.scaleMode = StageScaleMode.NO_SCALE;
    	    stage.align = StageAlign.TOP_LEFT;
            stage.quality=StageQuality.LOW;
            
            init();
            addEventListener(Event.ENTER_FRAME,loop);     
        }
       
    
       private function init():void
       {
           var appW:int =465;
           var appH:int = 465;
           canvas = new Bitmap(new BitmapData(appW,appH,true,0x000000)  );
           circlesArray = new Array(canvas);
           addChild(canvas);
           for(var i:uint=0; i<numCircle; i++) { 
			    circlesArray[i] = new Circle3(MathUtil.randomRange(appW),
                                                          MathUtil.randomRange(appH),
                                                          15+MathUtil.randomRange(20),
                                                          i,
                                                          appW,
                                                          appH,
                                                          canvas.bitmapData,
                                                          circlesArray,
                                                          25); 
	    } 
                       
       }
        
        private function loop(e:Event):void
        {
              linecount=0;
			
		if(canvas){
			canvas.bitmapData.lock();
			canvas.bitmapData.fillRect(canvas.bitmapData.rect,0x00000000);	
				
			for(var i:uint=0; i<numCircle; i++) { 
			    circlesArray[i].draw(); 
	 		 }
	 			
	 		for(var k:uint=0; k<numCircle; k++) { 
			     circlesArray[k].drawHair();
			     linecount+=Circle3(circlesArray[k]).count; 
	 		 }
	 			 
	 		 canvas.bitmapData.unlock();
 		}       
        }

    }
}    

import flash.display.BitmapData;

class Circle3 {
    
    public var x:Number
    public var y:Number;	
    private var r:Number;	
    private var r2:Number;
    private var d :Number;	
    private var d2:Number;
    private var lastx:Number;
    private var lasty:Number;		
    private var ac1:Number;
    private var ac2:Number;
    private var ac3:Number;
    private var sp1:Number;
    private var sp2:Number;
    private var sp3:Number;    
    private var height:Number;
    private var width:Number;		
    private var inx:Number = 0; 
    private var iny:Number = 0;
    private var hasIntersect:Boolean = false; 
    private var hairArray:Array; 
    private var cc:Array;  		
    private const TWO_PI:Number = 6.28318530717958647693;
    private var gray:uint; 
    private var id:uint;
    private var bmp:BitmapData 		
    private var cColor1:uint=0xFF000000;
    private var cColor2:uint=0xFF666666;
    public var count:uint;
    private var maxHairs:int;
    
    public function Circle3(px:Number,
                            py:Number,
                            pr:Number,
                            pId:uint,
                            w:uint,
                            h:uint,
                            target:BitmapData,
                            cirArray:Array,
                            mHairs:int)
    {
	x = px; 
	y = py; 
	r = pr; 
        r2 = r*r; 
        d = r*2; 
        d2 = d*d; 
        bmp = target;
        height=h;
        width=w;
        bmp=target;
        cc=cirArray;	    
        id = pId; 
        gray = 0; 
			
	maxHairs = mHairs;
			
	hairArray = new Array(maxHairs);
		    
	var stepA:Number =  2*Math.PI/hairArray.length;;
		    
	for (var i:Number=0; i<hairArray.length; i++) 
        { 
	    hairArray[i] = new Hair( Math.cos(stepA*i)*r, 
                                        Math.sin(stepA*i)*r, 5, stepA*i+Math.PI, this,bmp ); 
	     }
		    
	    sp1 = MathUtil.randomRange(10); 
	    sp2 = MathUtil.randomRange(2); 
	    sp3 = MathUtil.randomRange(2); 
		 
	    ac1 = MathUtil.randomRange(0.5)-MathUtil.randomRange(0.5); 
	    ac2 = MathUtil.randomRange(0.5)-MathUtil.randomRange(0.5); 
	    ac3 = MathUtil.randomRange(0.5)-MathUtil.randomRange(0.5); 
					   
    }
    
    public function  draw():void 
    { 
	count=0;
        Raster.circle(bmp,x, y, Math.abs(d/2)+1, cColor1); 
        move();
    }
		
        public function  drawHair():void { 
 	    for (var i:Number=0; i<hairArray.length; i++) 
            { 
	        hairArray[i].updatePos(); 
		hairArray[i].draw();
		count++; 
	    } 
  	}
  		
  	private function move():void {
  			
  	   var angle:Number = Math.sin( sp1 ) - Math.cos(sp2); 
 
	    sp1+=ac1; 
	    sp2+=ac2; 
	    sp3+=ac3; 
		 
	    angle = (angle<0) ? angle+TWO_PI : ( (angle>=TWO_PI) ? angle-TWO_PI : angle ); 
		 
	    x += Math.sin(angle); 
	    y -= Math.cos(angle); 
		 
	    checkBounds(); 
		 
	    checkIntersect(); 
  			
  	}
  		
  	private function  checkIntersect():void
  	{
  		
	    var flag:Boolean = false; 
	    var flag2:Boolean = false; 
	    for (var i:int=0; i<cc.length; i++) { 
	      if (i!=id) { 
	        flag = intersect( cc[i]); 
	        if (!flag2) flag2 = flag; 
	      } 
	    } 
		 
	   if (flag2){ 
	      hairFocus(inx, iny); 
	    } else if ( hasIntersect ) { 
	      hairFocusRevert(); 
	    } 
		 
	    hasIntersect = flag2; 
		 
	 }
		 
	 private function intersect(cB:Circle3 ):Boolean 
	 { 
		 
	    var dx:Number = x - cB.x; 
	    var dy:Number = y - cB.y; 
	    var d2:Number = dx*dx + dy*dy; 
	    var d:Number = Math.sqrt( d2 ); 
		 
	    if ( d>r+cB.r || d<Math.abs(r-cB.r) ) return false; 
		 
	    var a:Number = (r2 - cB.r2 + d2) / (2*d); 
	    var h:Number = Math.sqrt( r2 - a*a ); 
	    var x2:Number = x + a*(cB.x - x)/d; 
	    var y2:Number = y + a*(cB.y - y)/d; 
		 
	    var paX:Number = x2 + h*(cB.y - y)/d; 
	    var paY:Number = y2 - h*(cB.x - x)/d; 
	    var pbX:Number = x2 - h*(cB.y - y)/d; 
	    var pbY:Number = y2 + h*(cB.x - x)/d; 
		 
	    repel( Math.atan2( dy, dx) ); 
		 	
		 count++
		 //Raster.circle(bmp,paX, paY,7, cColor2);
		 //Raster.circle(bmp,pbX, pbY,10, cColor2);  
		 //ellipse( paX, paY, 15, 15 ); 
		 //ellipse( pbX, pbY, 20, 20 ); 
		 
		    if ( cB.id > id ) { 
		      inx = x2; 
		      iny = y2; 
		 
		    } else { 
		      inx = pbX; 
		      iny = pbY; 
		    } 
		 
		    return true; 
		 
		  }
		  
		  private function repel( angle:Number ):void { 
			  x = x + Math.cos(angle)/4; 
			  y = y + Math.sin(angle)/4; 
		  } 
 			
 		  private function  hairFocus( px:Number, py:Number):void { 
 
		    for (var i:int = 0; i<hairArray.length; i++) { 
		      hairArray[i].focus( px, py ); 
		    } 
		 
		  } 
		 
		  private function hairFocusRevert():void{ 
		    for (var i:int = 0; i<hairArray.length; i++) { 
		      hairArray[i].revertFocus(); 
		    } 
		  }
		  
		  
		   private function checkBounds():void { 
		   
		    if ( x > width ) x = 0; 
		    if ( x < 0 ) x = width; 
		    if ( y > height ) y = 0; 
		    if ( y < 0 ) y = height; 
		 
		  } 
    
}

import flash.display.BitmapData;
class Hair
	{
		
		private var repel_speed:Number; 
		private var radius:Number; 
		private var origRadius:Number; 
		private var angle:Number; 
		private var origAngle:Number; 
		private var x:Number; 
		private var y:Number; 
		private var regX:Number; 
		private var regY:Number; 
		private var nextX:Number; 
		private var nextY:Number; 
		private var lastx:Number; 
		private var lasty:Number; 
		
		private var speedFactor:Number = 12; 
		
		
		private var parent:Circle3;
		
		private var bmp:BitmapData;
		
		private var myColor:int;
		
		
		public function Hair(rx:Number,ry:Number,r:Number,a:Number,parent:Circle3,target:BitmapData )
		{
			radius = r; 
		    origRadius = r; 
		 
		    angle = a; 
		    origAngle = a; 
		 
		    this.parent = parent; 
		 	bmp = target;
		 	
		    regX = rx; 
		    regY = ry;
		    
		    nextX = parent.x+regX+Math.cos(angle)*radius; 
		    nextY = parent.y+regY+Math.sin(angle)*radius; 
		 
		    x = nextX; 
		    y = nextY; 
		 	
		//	myColor = 0xFFFFFFFF*Math.random();
		 	myColor =0xFFFF0000;
		}
		
		public function updatePos():void { 
 
		    nextX = parent.x+regX+Math.cos(angle)*radius; 
		    nextY = parent.y+regY+Math.sin(angle)*radius; 
		 
		    var dx:Number = nextX - x; 
		    var dy:Number = nextY - y; 
		    
		    if (Math.abs(dx)>1) { 
		      x += dx/speedFactor; 
		      y += dy/speedFactor; 
		    } 
		 
		    if (Math.abs(dx)>200 || Math.abs(dy)>200) { 
		      x = nextX; 
		      y = nextY; 
		    } 
		 
		  }
		  
		  public function draw():void {  
		  	
		  	Raster.line(bmp,parent.x+regX,parent.y+regY,x,y,myColor);
		 
		  }
		  
		  public function focus(px:Number,py:Number):void
		  {
	  	 	var dx:Number = px-(parent.x+regX); 
		    var dy:Number = py-(parent.y+regY); 
		 
		    angle = Math.atan2( dy, dx ); 
		    radius = MathUtil.dist( px, py, parent.x+regX, parent.y+regY );
		  	
		  }
		  
		   public function revertFocus():void
		  {
		  	 angle = origAngle; 
             radius = origRadius;
	  	}

}

class MathUtil
{

    public static function randomRange(minVal:Number,maxVal:Number=NaN):Number
    {
	if(!isNaN(maxVal)) return minVal+(Math.random()*(maxVal-minVal));
	else return Math.random()*minVal;
    }
		
    public static function dist( x1:Number, y1:Number, x2:Number, y2:Number ):Number
    {
	 
	 var dist:Number
	 var dx:Number;
	 var dy:Number;
			 
	 dx = x2-x1;
	 dy = y2-y1;
	 dist = Math.sqrt(dx*dx + dy*dy);
			 
         return dist;
			 
    }
}



import flash.display.BitmapData;
class Raster 
{
    public static function line(bmp:BitmapData,x0:int,y0:int,x1:int,y1:int,c:Number):void
    {
			
	var dx:int;
	var dy:int;
	var i:int;
	var xinc:int;
	var yinc:int;
	var cumul:int;
	var x:int;
	var y:int;
	x = x0;
	y = y0;
	dx = x1 - x0;
	dy = y1 - y0;
	xinc = ( dx > 0 ) ? 1 : -1;
	yinc = ( dy > 0 ) ? 1 : -1;
	dx = Math.abs(dx);
	dy = Math.abs(dy);
	bmp.setPixel32(x,y,c);
			
    	if ( dx > dy )
        {
	    cumul = dx / 2 ;
	    for ( i = 1 ; i <= dx ; i++ ){
	        x += xinc;
        	cumul += dy;
	        if (cumul >= dx){
	  	    cumul -= dx;
	  	    y += yinc;
            }
	bmp.setPixel32(x,y,c);
	}
	    }else{
		cumul = dy / 2;
		for ( i = 1 ; i <= dy ; i++ )
                {
		    y += yinc;
		    cumul += dx;
		    if ( cumul >= dy )
                    {
		    cumul -= dy;
		    x += xinc ;
		}
		bmp.setPixel32(x,y,c);
	    }
    	}
    }
        
    public static function circle(bmp:BitmapData,px:int,py:int,r:int,c:Number):void
    {
        var x:int;
	var y:int;
	var d:int;
	x = 0;
	y = r;
	d = 1-r;
	bmp.setPixel32(px+x,py+y,c);
	bmp.setPixel32(px+x,py-y,c);
	bmp.setPixel32(px-y,py+x,c);
	bmp.setPixel32(px+y,py+x,c);
			
		while ( y > x ){
			if ( d < 0 ){
				d += 2 * x+3 ;
			}else{
				d += 2 * (x - y)+5;
				y--;
			}
			x++;
			bmp.setPixel32(px+x,py+y,c);
			bmp.setPixel32(px-x,py+y,c);
			bmp.setPixel32(px+x,py-y,c);
			bmp.setPixel32(px-x,py-y,c);
			bmp.setPixel32(px-y,py+x,c);
			bmp.setPixel32(px-y,py-x,c);
			bmp.setPixel32(px+y,py-x,c);
			bmp.setPixel32(px+y,py+x,c);
       }
    }
    
    		
}
