/**
 * Copyright mfc314159 ( http://wonderfl.net/user/mfc314159 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h4j6
 */

package  {
	//--WHAT THE--
        //--The radial application of a sine wave on a 3D plane--
        //The original program I wrote had 2 waves, I'll get to add that later
        //There was also mouse control for for freq and amp, but I think
        //I'm going to make a function to generate a splash like motion
        //I've yet to even mess with perLn.. so I think there is potential there too.
        //There must be a better material then the colorMat for this.
        //---CONTROLS---
        // keyboard UP, DOWN, LEFT, and RIGHT control the wave origin position
        // keyboard A increases frequency
        // keyboard Z decreases frequency
        // keyboard S increases amplitude
        // keyboard X decreases amplitude
        // keyboard SPACE randomizes the origin, frequency, and amplitude
        // CLICKing on the upper half of the screen pitches up
        // CLICKing on the lower hald of the screen pitches down
        
        
        //I'm just not spending to time to fix the f.d formating from pasting it into HTML from CS5
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.KeyboardEvent;
	import flash.filters.BlurFilter;
	import org.papervision3d.render.BasicRenderEngine;
        import org.papervision3d.scenes.Scene3D;
        import org.papervision3d.view.Viewport3D;
	import org.papervision3d.cameras.Camera3D;
        import org.papervision3d.core.effects.*;
        import org.papervision3d.core.effects.utils.*;
        import org.papervision3d.view.layer.*;
        import org.papervision3d.objects.*;
        import org.papervision3d.view.*;
        import org.papervision3d.objects.primitives.*;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.shaders.FlatShader;
	import org.papervision3d.materials.shaders.ShadedMaterial;
	import org.papervision3d.materials.shadematerials.PhongMaterial;
	import org.papervision3d.materials.WireframeMaterial;
	
	public class master2 extends Sprite {
		private const piE:Number = Math.PI / 180;
		//papervision	
		private var viewport:Viewport3D;        
		private var scene:Scene3D;        
		private var renderer:BasicRenderEngine;        
		private var camera:Camera3D;
		private var light:PointLight3D;
		private var angle:Number = 180;
		//plane 3D object / 2D Array
		private var cont:DisplayObject3D;
		private var plane:Plane;
		private var pArr:Array = []; // [i][0] = [i].x  [i][1] = [i].y
		//plane geometry
		private var vc:int;
		private var vCoords:Array = [];
		//--Array to hold the wavefrom
		private var waveArray:Array = [];
		//index related #
		private var i:int; //loop index #
		private var a:int; 
		private var b:int;
		private var c:int;
		//Math\Position Tables
		private var bfa:Array = [];
		private var sqrtTable:Array = [];
		private var sinTable:Array = [];
		//-------------------WAVE TABLE DIMENSIONS
		//--Plane/pArr dimensions
		private var hiX:int = 60;  //FIRST INDEX    X
		private var hiY:int = 60;  //SECOND INDEX   Y
		//The corner to corner distance determins
		//the size of the waveArray
		private var hiIdx:int = int( Math.sqrt((hiX * hiX) + (hiY * hiY)) );  
			
		//--Plane Dimensions 
		private var w:int = 1200;  //WIDTH
		private var h:int = 1200;   //HEIGHT
		private var hw:int = w / 2;
		private var hh:int = h / 2;
		private var hsh:int = stage.stageHeight * .5; //
		//--waveform 1 init characteristics 
		private var amp:int = 50; //AMPLITUDE
		private var freq:int = 30; //FREQUENCY
		private var dec:Number = .975; //DECLINATION
		//--wave position and calculation
		private var midPos:int = int(hiX / 2);
		//WAVE 1
		private var orgX:int = midPos;
		private var orgY:int = hiY - 10;
		private var ang:int = 0;
		private var rad:Number;
		private var originWave:int;
		
		public function master2() {
//INIT-----------------------------
			//PAPERVISION
			viewport = new Viewport3D();
			viewport.opaqueBackground = 0x000000;
			viewport.viewportWidth = 500; 
			viewport.viewportHeight = 500;
			viewport.x = ( this.stage.stageWidth - viewport.viewportWidth ) / 2; 
			viewport.y = ( this.stage.stageHeight - viewport.viewportHeight ) / 2;
			addChild(viewport);
			viewport.filters = [new BlurFilter(10, 10, 1)];
			scene = new Scene3D();
			camera = new Camera3D();
			renderer = new BasicRenderEngine(); 
			//light = new PointLight3D(true);
			//scene.addChild(light);
//SETUP----------------
			drawArray();
			resetWaveArray();
			makeMathTables();
//EVENT HANDLERS-------------------------------------------------------------
			parent.stage.addEventListener(MouseEvent.MOUSE_DOWN, pitchChange);
			function pitchChange(evt:MouseEvent) {
				if(evt.stageY >= hsh ) { cont.pitch(5.00); }
				else {					cont.pitch(-5.00); }
			}
			parent.stage.addEventListener(KeyboardEvent.KEY_DOWN, moveOrigin);
			function moveOrigin(evt:KeyboardEvent) {
				//trace(evt.keyCode, evt.keyLocation, evt.charCode);
				if(evt.keyCode == 38) { orgY++; }//up 
				if(evt.keyCode == 40) { orgY--; }//down
				if(evt.keyCode == 37) { orgX++; }//left
				if(evt.keyCode == 39) { orgX--; }//right
				if(orgX < 0) { orgX = 0; }
				if(orgY < 0) { orgY = 0; }
				if(orgX > hiX) { orgX = hiX; }
				if(orgX > hiY) { orgY = hiY; }
			        if(evt.keyCode == 65) { freq++;}
				if(evt.keyCode == 90) { freq--;}
				if(evt.keyCode == 83) { amp++; }
				if(evt.keyCode == 88) { amp--; }
				if(evt.keyCode == 32) {
					orgX = int(hiX * Math.random());
					orgY = int(hiY * Math.random());
					freq = int(100 * Math.random());
					amp  = int(100 * Math.random());
				}
                        }
			addEventListener(Event.ENTER_FRAME, mainLoop);
		}
//MAIN LOOP---------------------------------
		public function mainLoop(evt:Event) {
			//Wub Wub Wub Wub Wub Wub
			ang += freq;
			if(ang > 360) { ang -= 360; }
			originWave = (amp * sinTable[ang]);
			
			stage1(); //windArray algorithm
			stage2(); //set plane's z vertices
			cont.roll(1); //pizazz
			renderer.renderScene(scene, camera, viewport); //Render!!
		}
//STAGE 1:  Add new value to windArray,---------
//			Shift values up, 
//			multiply declination
		public function stage1() {
			waveArray.pop();				//out with the old
			waveArray.unshift(originWave);	//in with the new
			i = 0;
			while(i < vc) {	waveArray[i] *= dec; i++; }	//Declination
		}
//STAGE 2: Change z values to reflect waveArray------
		public function stage2() {
			i = 0;
			while(i < vc) {
				//set to corresponding z
				plane.geometry.vertices[i].z = waveArray[ bfa[orgX][orgY][pArr[i].x][pArr[i].y] ];
				i++;
			}
		}
		public function drawArray() {
//SETUP THE plane OBJET AND pArr ARRAY
			//--VISUAL
			cont = new DisplayObject3D;
			//color material seems to work the best for now
			var mat = new ColorMaterial(0x0000BB, .5);
			//var mat = new WireframeMaterial(0x1111BB, .5, .1);
			//var mat = new PhongMaterial(light, 0x1111FF, 0x000000, 1);
			//var mat = new FlatShadeMaterial(light, 0x0000BB, 0x000011, 1);
			plane = new Plane(mat, w, h, hiX, hiY);
			cont.addChild(plane);
			scene.addChild(cont);
			cont.pitch(70);
			camera.target = plane;
			camera.z = -860;
			//light.x = plane.x;
			//light.y = plane.y + 200;
			//light.z = plane.z;
			//--DATA
			vCoords = plane.geometry.vertices;
			vc = plane.geometry.vertices.length;
			i = 0;
			while(i < vc) {
				//Convert vertices corrdinates into array indexs
				pArr[i] = new Array();
				pArr[i]["x"] = int( Math.round(  (hw + vCoords[i].x) / (w / hiX)  ) );
				pArr[i]["y"] = int( Math.round(  (hh + vCoords[i].y) / (h / hiY)  ) );
				i++;
			}
		}
		public function resetWaveArray() {
//WAVEARRAY RESET-------------------------			
			//set the inital size of the wave array by filling it with .001
			for(var k:int = 0; k <= hiIdx; k++) {
				waveArray[k] = Number(.001);
			}
		}
		public function makeMathTables() {
//MATH TABLES-----------------------------
			        //--Square root table for the Big Fucking Table
			for(var k:int = 0; k <= hiIdx; k++) {
				sqrtTable[k] = new Array();
				for(var j:int = 0; j <= hiIdx; j++) {
					sqrtTable[k][j] = int(Math.sqrt((k * k) + (j * j)));
				}
			}
			//--Big Fucking Table knows all, sees all
			for(var ox:int = 0; ox <= hiX; ox++) {
				bfa[ox] = new Array ();
				for(var oy:int = 0; oy <= hiY; oy++) {
					bfa[ox][oy] = new Array ();
					for(var vx:int = 0; vx <= hiX; vx++) {
						bfa[ox][oy][vx] = new Array ();
						for(var vy:int = 0; vy <= hiY; vy++) {
							if (vx > ox) { a = vx - ox; } else { a = ox - vx; }
							if (vy > oy) { b = vy - oy; } else { b = oy - vy; }
							// a = x - vertex.x
							// b = y - vertex.y
							// c*c = a*a + b*b
							bfa[ox][oy][vx][vy] = int(sqrtTable[a][b]);
						}//vy
					}//vx
				}//oy
			}//ox
			//--Sine wave table
			for(var s:int = 0; s <= 361; s++) {
				sinTable[s] = Number(Math.sin(s * piE));
			}
		}//makeTables
	}//class
}//package