/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h4V7
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
    public class FlashTest extends Sprite {
		private var _frame:uint;
		
        public function FlashTest() {
			this.graphics.beginFill(0x808080);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();
			
			_frame = 0;
			
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function proc(e:Event):void {
			++_frame;
			
			if (_frame >= 10) {
				_frame = 0;
				
				var r:uint = 128 + (Math.random() * 128);
				var g:uint = 128 + (Math.random() * 128);
				var b:uint = 128 + (Math.random() * 128);
				var color:uint = (r << 16) + (g << 8) + (b << 0);
				var radius:Number = Math.random() * 20 + 40;
				
				var bubble:Bubble = new Bubble(this, color, radius);
				bubble.x = Math.random() * 400 + 32.5;
				bubble.y = Math.random() * 400 + 32.5;
			}
		}
    }
}
import flash.display.Sprite;
import caurina.transitions.Tweener;

class Bubble extends Sprite
{
	private var _parent:Sprite;
	private var _color:uint;
	private var _radius:Number;
	
	public function Bubble(parent:Sprite, color:uint, radius:Number) {
		_parent = parent;
		_color = color;
		_radius = radius;
		
		_parent.addChild(this);
		
		this.graphics.beginFill(_color);
		this.graphics.drawCircle(0, 0, _radius);
		this.graphics.endFill();

		this.alpha = 0;
		this.scaleX = 0.1;
		this.scaleY = 0.1;
		
		var appear:uint = 2;
		var wait:uint = 5;
		var vanish:uint = 5;
		
		Tweener.addTween(this,
		{
			scaleX:1,
			scaleY:1,
			alpha:1,
			time:appear,
			useFrames:true,
			onComplete:function():void {
				createChild();
			}
		});
		Tweener.addTween(this,
		{
			alpha:0,
			delay:appear + wait,
			time:vanish,
			useFrames:true,
			onComplete:function():void {
				_parent.removeChild(this);
			}
		});
	}
	
	private function createChild():void {
		if (_radius < 10.0) return;
		
		var num:uint = Math.random() * 2 + 2;
		
		for (var index:uint = 0; index < num; ++index) {
			var childRadius:Number = (Math.random() * 0.2 + 0.6) * _radius;
			
			var child:Bubble = new Bubble(_parent, _color, childRadius);
			var rad:Number = Math.random() * Math.PI * 2;
			child.x = this.x + (Math.cos(rad) * _radius);
			child.y = this.y + (Math.sin(rad) * _radius);
		}
	}
}