/**
 * Copyright alumican_net ( http://wonderfl.net/user/alumican_net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h4NZ
 */

package {
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.events.Event;
    import a24.tween.Tween24;
    import a24.tween.events.Tween24Event;
    
    public class FlashTest extends Sprite {
        public var frame:int = 0;
        
        public function FlashTest() {
            addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
            stage.frameRate = 60;

            var tf:TextField = new TextField();
            tf.width = 465;
            tf.height = 465;
            addChild(tf);
            function log(...m):void { tf.appendText(frame + ": " + m.join(" ") + " " + ball.x + "\n"); }

            var ball:Sprite = new Sprite();
            ball.graphics.beginFill(0x0);
            ball.graphics.drawCircle(0, 0, 50);
            ball.graphics.endFill();
            ball.x = 465 / 2 - 150;
            ball.y = 465 / 2;
            addChild(ball);
            
            function getTween(duration:Number):Tween24 {
                return Tween24.tween(ball, duration)
                    .x(465 / 2 + 150)
                    .onPlay(log, "onPlay")
                    .onInit(log, "onInit")
                    .onUpdate(log, "onUpdate")
                    .onComplete(log, "onComplete")
                    .onStop(log, "onStop")
                    .onPause(log, "onPause")
                    .onDelay(log, "onDelay")
                    .onSkip(log, "onSkip");
            }
            var tween:Tween24;
            
            switch (3) {
                case 0:
                    tween = getTween(1);
                    tween.play();
                    break;
                    
                case 1:
                    tween = getTween(0);
                    tween.play();
                    break;
                    
                case 2:
                    tween = getTween(1);
                    tween.setTimeScale(0);
                    tween.play();
                    break;
                    
                case 3:
                    tween = getTween(1);
                    tween.play();
                    tween.skip();
                    break;
            }
        }
        
        public function _enterFrameHandler(event:Event):void {
            ++frame;
        }
    }
}