/**
 * Copyright knd ( http://wonderfl.net/user/knd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h4HR
 */

// forked from uraac's flash on 2010-3-1
package
{
	import flash.display.Sprite;
	import flash.text.TextField;

	[SWF( backgroundColor="#000000" )]
	public class PascalsTriangle extends Sprite{

		private const EXPONENT:Number = 200;
		private const MODULUS:Number = 7;
		private var colorMap:Array;
		private var steps:Array;
		private var fractMemory:Object;

		public function PascalsTriangle()
		{
			fractMemory = {};
			prepareColorMap();
			prepareSteps();
			drawShape();
		}

		private function prepareColorMap():void
		{
			colorMap = [];
			var colorChunk:int = 0xeeeeee / MODULUS;
			for (var cmapindex:int = 0; cmapindex < MODULUS; cmapindex++)
			{
				colorMap[cmapindex] = colorChunk * (cmapindex+1);
			}
		}

		private function prepareSteps():void
		{
			steps = [];
			for(var stepc:int = 0; stepc < EXPONENT; stepc++)
			{
				steps[stepc] = makeStep(stepc);
			}
		}

		private function makeStep(stepc:int):Array
		{
			var result:Array = [];

			for (var stepe:int = 0; stepe <= stepc; stepe++)
			{
				result[stepe] = combination(stepc, stepe);
			}
			return result;
		}

		private function drawShape():void
		{

			//var t:TextField = new TextField();
			//t.textColor = 0xFFFFFF;
			//t.x = 100;
			
			var px:Number = 228;
			var py:Number = 0;
			var radius:Number = 3;
			for (var stepc:int = 0; stepc < EXPONENT; stepc++)
			{
				px -= radius;
				var lpx:Number = px;
				var step:Array = steps[stepc] as Array;
				for (var r:int = 0; r <= stepc; r++)
				{
					var keisu:Number = Number(step[r]);
					var rem:int = keisu % MODULUS;
					this.graphics.beginFill(uint(colorMap[rem]));
					this.graphics.drawCircle(lpx,py,radius);
					this.graphics.endFill();

					lpx += radius * 2;

					//t.appendText(keisu.toString());
					//t.appendText(",");
				}
				py += radius*Math.sqrt(3);

				//t.appendText("\n");
			}
			//addChild(t);
		}

		private function combination(n:int, r:int):Number
		{
			return fractorial(n)/(fractorial(n-r)*fractorial(r));
		}

		private function fractorial(value:Number):Number
		{
			if (value == 0 || value == 1)
			{
				return 1;
			}
			
			if (fractMemory.hasOwnProperty(value))
			{
				return fractMemory[value];
			}
			else
			{
				fractMemory[value] = value * fractorial((value-1));
			}

			return value * fractorial((value-1));
		}
	}
}
