/**
 * Copyright k_tsushima ( http://wonderfl.net/user/k_tsushima )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h3wn
 */

package {
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
        import caurina.transitions.Tweener;
	import caurina.transitions.properties.ColorShortcuts;
	import flash.utils.*;
	/**
	 * ...
	 * @author k_tsushima
	 */
	[SWF(backgroundColor="0x000000")]
	public class fireworks extends Sprite  
	{
		private var SpriteArray:Array;
		private var CircleNum:uint = 300;
		
		public function fireworks():void {
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event=null):void {
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			SpriteArray = getSprite(CircleNum);
			for (var i:uint = 0; i < SpriteArray.length; i++) {
				stage.addChild(SpriteArray[i]);
			}
			stage.addEventListener(MouseEvent.MOUSE_MOVE, moveHandler);
			stage.addEventListener(MouseEvent.CLICK, clickHandler);
		}
		
		private function getSprite(n:uint):Array {
			var ArrayStack:Array = new Array();
			for (var i:uint = 0; i < n; i++) {
				var s:Sprite = new Sprite();
				s.graphics.beginFill(0xffffff*Math.random());
				s.graphics.drawCircle(0, 0, 5);
				s.graphics.endFill();
				ArrayStack.push(s);
			}
			return ArrayStack;
		}
		
		private function moveHandler(e:MouseEvent):void {
			for (var i:uint = 0; i < SpriteArray.length; i++) {
				var random1:Number = Math.random();
				var random2:Number = Math.random();
				SpriteArray[i].alpha = 1;
				SpriteArray[i].x = stage.mouseX + 50 * random1 * Math.cos(2 * Math.PI * random2);
				SpriteArray[i].y = stage.mouseY + 50 * random1 * Math.sin(2 * Math.PI * random2);
			}
		}
		
		private function clickHandler(e:MouseEvent):void {
			removeEventListener(MouseEvent.MOUSE_MOVE, moveHandler);
			var rad:Number = 2 * Math.PI / CircleNum ;
			for (var i:uint = 0; i < SpriteArray.length; i++) {
				var sx:Number = stage.mouseX + 80*(1+i%5) * Math.cos(2 * Math.PI * rad * i);
				var sy:Number = stage.mouseY + 80*(1+i%5) * Math.sin(2 * Math.PI * rad * i);
				Tweener.addTween(SpriteArray[i], {
					time:2,
					x:sx,
					y:sy
				});
				Tweener.addTween(SpriteArray[i], {
					time:3,
					delay:2,
					alpha:0,
					y:sy + 100
				});
			}
			setTimeout(function():void { stage.addEventListener(MouseEvent.MOUSE_MOVE, moveHandler); }, 5000);
		}
	}
	
}