/**
 * Copyright snaf ( http://wonderfl.net/user/snaf )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h3lv
 */

// forked from bucchigiri's flash on 2012-2-14
/*
http://clockmaker.jp/blog/2008/08/cubicvr_papervision3d_cubeface/
より借用
*/
package
{
    import flash.system.Security;
    import flash.display.*;
    import flash.events.*;
    
    import org.papervision3d.cameras.*;
    import org.papervision3d.view.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*
    import org.papervision3d.materials.utils.*;
    
    [SWF(width = "720", height = "480", frameRate = "60", backgroundColor = "#FFFFFF")]
    
    public class FlashTest extends BasicView {
        // 3Dオブジェクト
        private var cube:Cube;
        private var wire:Cube;

        /**
         * コンストラクタ
         */
        public function FlashTest()
        {
            // BasicViewの初期化
            super(720, 480, true, false, CameraType.FREE);
            
            // init swf
            //stage.quality = StageQuality.LOW;
            
            // クロスドメイン対策
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
            
            // カメラ
            camera.x = camera.y = camera.z = 0;
            camera.focus = 200;
            camera.zoom = 1;
            
            // マテリアル(立方体の面を作成)
            var materials:MaterialsList = new MaterialsList(
            {
                back : new BitmapFileMaterial( "http://assets.wonderfl.net/images/related_images/b/b6/b658/b65801e09ff673faea38e6ff917e8d121b3f0f39m", true ),
                left : new BitmapFileMaterial( "http://assets.wonderfl.net/images/related_images/3/31/31f3/31f3b6c2088986f28498c74ddf1e527669257232m", true ),
                front  : new BitmapFileMaterial( "http://assets.wonderfl.net/images/related_images/5/57/57c4/57c40397c6b0659b99c908f79d77b2241b7a3e21m", true ),
                right  : new BitmapFileMaterial( "http://assets.wonderfl.net/images/related_images/a/a8/a802/a8028504924e22dcb7253545fa7d1cc9f82d87d1m", true ),
                top   : new BitmapFileMaterial( "http://assets.wonderfl.net/images/related_images/3/3c/3cfe/3cfe302779e14bb2a8d2fb77d203c13519340065m", true ),
                bottom: new BitmapFileMaterial( "http://assets.wonderfl.net/images/related_images/e/e2/e260/e260a30585316dce0c1250d78643135dab26c761m", true )
            } );

            // 立方体の面を設定
            // You can add or sustract faces to your selection. For examples: Cube.FRONT+Cube.BACK or Cube.ALL-Cube.Top.

            // On single sided materials, all faces will be visible from the inside.
            var insideFaces  :int = Cube.ALL;

            // Front and back cube faces will not be created.
            var excludeFaces :int = Cube.NONE;
            
            // 定数
            var size :Number = 5000;
            var quality :Number = 10;
            
            // キューブを作成
            cube = new Cube( materials,
                size, size, size, quality, quality, quality, insideFaces, excludeFaces );
            wire = new Cube( new MaterialsList( { all:new WireframeMaterial() } ), 
                size, size, size, quality, quality, quality, insideFaces, excludeFaces );
            wire.visible = false;
            
            // シーンに追加
            scene.addChild(cube);
            scene.addChild(wire);
            
            // マウスのインタラクティブを設定しています
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
            addEventListener(MouseEvent.MOUSE_UP, upHandler);
            addEventListener(MouseEvent.MOUSE_WHEEL, wheelHandler);
            
            // レンダリングを開始します
            startRendering();
        }
        
        /**
         * マウスの位置に応じてインタラクティブを設定しています
         * @param    event
         */
        private function enterFrameHandler(event:Event):void
        {
            // Pan
            camera.rotationY += (480 * mouseX/(stage.stageWidth) - camera.rotationY) * .1;
            camera.rotationX += (180 * mouseY/(stage.stageHeight) - 90 - camera.rotationX) * .1;
        }
        
        /**
         * マウスを押したときにワイヤーフレームが表示されるように設定しています
         * @param    event
         */
        private function downHandler(event:MouseEvent):void 
        {
            wire.visible = true;
        }
        
        /**
         * マウスを話したときにワイヤーフレームが非表示になるように設定しています
         * @param    event
         */
        private function upHandler(event:MouseEvent):void 
        {
            wire.visible = false;
        }
        
        /**
         * マウスホイールでカメラ焦点を調整します
         * @param    event
         */
        private function wheelHandler(event:MouseEvent):void 
        {
            camera.zoom += event.delta / 10;
            if (camera.zoom < 1) camera.zoom = 1;
        }
    }
}