/**
 * Copyright misinoe ( http://wonderfl.net/user/misinoe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h3CX
 */

package {
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.events.Event;
    public class FlashTest extends Sprite {
        
        
        public var generativeBitmap:GenerativeBitmap;
        
        // Const
        public function FlashTest() {
            Debug.into( this );
            
            
            
            generativeBitmap = new GenerativeBitmap(800,400);
            addChild( generativeBitmap );
            
            var source:BitmapData = BitmapDataPertial.generateGradientCircle( 10, 0xFF8800 );
            generativeBitmap.drawPointToPoint( source, 0, 0, 100, 100 );

            addEventListener( Event.ENTER_FRAME, enterFrameHandler );
        }
        public function enterFrameHandler(...args):void{
            generativeBitmap.weathering();
        }

    }
}
import flash.filters.ColorMatrixFilter;
import flash.geom.Matrix;
import flash.geom.ColorTransform;
import flash.filters.BlurFilter;
import flash.filters.BitmapFilter;
import flash.geom.Point;
import flash.geom.Vector3D;
import flash.text.TextField;


// Generative art controller
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.display.BlendMode;
class GenerativeBitmap extends Sprite{
    
    
    protected var _background:Sprite;
    
    protected var _bufferData:BitmapData;
    protected var _bitmapData:BitmapData;
    protected var _bitmap:Bitmap;
    
    // Const
    public function GenerativeBitmap( w:int, h:int ){
        
        _background = new Sprite();
        addChild( _background );
        _background.graphics.beginFill( 0x334455 );
        _background.graphics.drawRect( 0, 0, w, h );
        
        _bitmapData = new BitmapData( w, h, true, 0xFF000000 );
        _bufferData = _bitmapData.clone();
        _bitmap = new Bitmap( _bitmapData );
        _bitmap.blendMode = BlendMode.NORMAL;
        addChild( _bitmap );
        
        
    }
    
    // draw Point to Point
    public function drawPointToPoint( source:BitmapData, x1:int, y1:int, x2:int, y2:int, w:Number=1.0 ):void{
        var distance:int = Math.sqrt( Math.pow( x2-x1, 2 ) + Math.pow(y2-y1, 2) );
        var ox:Number = ( (x2-x1)/distance ) * w;
        var oy:Number = ( (y2-y1)/distance ) * w;
        var point:Point = new Point( x1, y1 );
        for( var i:int=0,count:int=distance/w;i<count;i++ ){
            point.x += ox;
            point.y += oy;
            _bitmapData.copyPixels( source, source.rect, point, source, source.rect.topLeft, true );
            // _bitmapData.merge( source, source.rect, point, 0x100, 0x100, , 0x50 );
            /*
            var matrix = [
                [1,0,0,0,5],
                [0,1,0,0,5],
                [0,0,1,0,5],
                [0,0,0,1,0]
            ];
            _bitmapData.applyFilter( source, source.rect, point, new ColorMatrixFilter( matrix) );
            */
        }
    }
    
    // 
    public function weathering( scale:Number=1.0 ):void{
        
        
        // _bufferData.copyPixels( _bitmapData, _bitmapData.rect, _bitmapData.rect.topLeft );
        _bitmapData.colorTransform( _bitmapData.rect, new ColorTransform(1,1,1,0.98) );
        
        var filter:BlurFilter = new BlurFilter( 2*scale, 2*scale );
        _bitmapData.applyFilter( _bitmapData, _bufferData.rect, new Point(), filter );
    }


}

class BaseElement{

    // position
    public var x:int;
    public var y:int;
    // source
    public var generativeBitmap:GenerativeBitmap;
    public var bitmapData:BitmapData;
    
    public function BaseElement( generativeBitmap:GenerativeBitmap, x:int=0, y:int=0){
        this.generativeBitmap = generativeBitmap;
        this.x = x;
        this.y = y;
    }



}




// Bitmap Partial
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.display.GradientType;
class BitmapDataPertial{
    
    public function BitmapDataPertial(){};
    
    // Internal generate logic
    static private function generateBitmapData( display:DisplayObject ):BitmapData{
        var bmp:BitmapData = new BitmapData( display.width, display.height, true, 0x00000000 );
        bmp.draw( display );
        return bmp;
    }
    
    // Generate Circle
    static public function generateGradientCircle( size:int, color:uint, alpha:Number=1 ):BitmapData{
        var sprite:Sprite = new Sprite();
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox( size, size, 0, 0, 0 );
        sprite.graphics.beginGradientFill( GradientType.RADIAL, [0xffffff, color, color], [1, 0.7, 0.0], [0x80, 0xc0,0xff], matrix );
        sprite.graphics.drawCircle( size/2, size/2, size/2 );
        return generateBitmapData( sprite );
    }
    
    // Generate Circle

    static public function generateCircle( size:int, color:uint, alpha:Number=1 ):BitmapData{

        var sprite:Sprite = new Sprite();
        sprite.graphics.beginFill( color, alpha );
        sprite.graphics.drawCircle( size/2, size/2, size/2 );
        return generateBitmapData( sprite );

    }


    
}



// Print Debugger
import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
class Debug extends Sprite{
    public var textField:TextField;
    public function Debug(){
        textField = new TextField();
        addChild( textField );
    }
    static private var _debug:Debug;
    static public function into(target:DisplayObjectContainer):void{
        _debug = new Debug();
        target.addChild( _debug );
    }

    static public function log(...args):void{
        _debug.textField.text = args + "\n" + _debug.textField.text;
        if( _debug.textField.text.length > 1000 ) _debug.textField.text = _debug.textField.text.substr( 0, 1000 );
    }


}

