/**
 * Copyright logicalyze ( http://wonderfl.net/user/logicalyze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h3Be
 */

/*
* 「SiONであの楽器」をフォークしようと思ったのですが鍵盤の並び等、
*　その他、変更して使いたい部分がいろいろあったので基本部分のみ
*　参考にさせていただき、スクラッチの作成としました。
*/
package {
    import flash.display.Sprite;
    	import flash.events.MouseEvent;	
	import org.si.sion.*;
	import org.si.sion.utils.SiONPresetVoice;
	import com.bit101.components.Text;
	
	[SWF(backgroundColor = 0x333333, frameRate = 30, width = 450, height = 350)]
    public class FlashTest extends Sprite {
    		
    		private var driver:SiONDriver;
		private var presetVoice:SiONPresetVoice;
		private var voice:SiONVoice;
		private var t:Text;

        public function FlashTest() {
          
            init_sion();
			setup_display();
            
        }
        		private function init_sion():void
		{
			driver = new SiONDriver();
			presetVoice = new SiONPresetVoice();
			voice = new SiONVoice();
			voice = presetVoice["valsound.piano3"];
			driver.play();
		}

		private function setup_display():void
		{
			var kb:Sprite = setup_KeyBoad();
			kb.x = stage.stageWidth*0.5 - kb.width *0.5;
			kb.y = stage.stageHeight * 0.5 - kb.height * 0.5;
			t = new Text(this, 60, 20, "Note Number : ");
			t.width = 150;
			t.height = 20;
			addChild(kb);	
		}
		
		private function setup_KeyBoad():Sprite {
			var KeyBoad:Sprite = new Sprite();
			var key_x_pos_array:Array = [0, 30, 50, 80, 100, 150, 180, 200, 230, 250, 280, 300];
			for (var i:int = 0; i < 12; i++) {
				var key:KeyRect = new KeyRect(i);
				key.note = i+60;
				key.x = key_x_pos_array[i];
				if(i==1 || i == 3 || i == 6 || i == 8 || i == 10){
						key.height = 100;
						key.width = 40;
						KeyBoad.addChild(key);
				} else {
						KeyBoad.addChildAt(key, 0);
				}
				key.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
				key.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			}
			return KeyBoad;
		}
		
		private function onMouseDown(e:MouseEvent):void 
		{
			driver.noteOn(e.target.note, voice, 0, 0, 0, 0, 0, 1, 1, true);
			e.target.alpha = .9;
			t.text= "Note Number : "+String(e.target.note);
		}
		
		private function onMouseUp(e:MouseEvent):void 
		{
			driver.noteOff(e.target.note);
			e.target.alpha = 1.0;
		}
    }
}
import flash.display.Sprite;
class KeyRect extends Sprite {
	private var _note:int;
	public function KeyRect(value:int) {
		buttonMode = true;
		graphics.clear();
		if(value==1 || value == 3 || value == 6 || value == 8 || value == 10){
			graphics.beginFill(0x000000);
		} else {
			graphics.beginFill(0xFFFFFF);
		}
		graphics.drawRect(0, 0, 50, 200);
		graphics.endFill();
		graphics.lineStyle(2, 0x000000);
		graphics.lineTo(50,   0);
		graphics.lineTo(50, 200);
		graphics.lineTo( 0, 200);
		graphics.lineTo( 0,   0);
	}
	
	public function get note():int { return _note; }
	
	public function set note(value:int):void 
	{
		_note = value;
	}

}