/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h323
 */

// forked from siouxcitizen's Away3D Gold Practice09 Torus表示
// forked from siouxcitizen's Away3D Gold Practice08 Cylinder表示実験
// forked from siouxcitizen's Away3D Gold Practice06 Cube 5つ表示
// forked from siouxcitizen's Away3D Gold Practice05 光のあて方よくわからない。。。
// forked from siouxcitizen's Away3D Gold Practice04 SphereとWireframeSphere表示
// forked from siouxcitizen's Away3D Gold Practice03 WireframePlane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice02 Plane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice01 Plane 1枚表示
//
//Away3D 4.0 Gold でPlaneにWonderflサーバ上の画像ファイルをテクスチャとして貼り付けてみました
//
//
//以下サイトを参考にさせていただきました
//
//Setting Up Your Scene 
//http://away3d.com/tutorials/Setting_Up_Your_Scene
//
//away3d-tutorials-fp11 / tutorials / scenegraph / basic_view / src / Basic_View.as
//https://github.com/away3d/away3d-tutorials-fp11/blob/master/tutorials/scenegraph/basic_view/src/Basic_View.as
//
//PlaneGeometry.doubleSided=true;RangeError: Error #3669: Bad input size.
//http://away3d.com/forum/viewthread/3125/
//
//↓あと自分作成の昔のコードも参考にしました
//http://wonderfl.net/c/izel
//
package {
    import away3d.containers.View3D;
    import away3d.containers.Scene3D;
    import away3d.cameras.Camera3D;
    import away3d.debug.AwayStats;
    import away3d.entities.Mesh;
    import away3d.materials.TextureMaterial;
    import away3d.primitives.PlaneGeometry;
    import away3d.primitives.PrimitiveBase;
    import away3d.utils.Cast;

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Vector3D;

    import flash.display.Loader;
    import flash.system.LoaderContext;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.display.Bitmap;
    import flash.display.BitmapData;

    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="465", height="465")]
    public class PlaneTextureSample extends Sprite {

        private var _bmd : BitmapData;
        private var _loader : Loader;
        private static const ZERO : Vector3D = new Vector3D(0, 0, 0);
        private var _view : View3D;
        private var _scene : Scene3D;
        private var _camera : Camera3D;
        private var _plane01 : Mesh;
        private var _plane02 : Mesh;

        private var _capture : BitmapData = new BitmapData(465, 465, false, 0x000000);

        public function PlaneTextureSample() {

            // wonderfl capture
            Wonderfl.disable_capture();
            //addChild(new Bitmap(_capture)) ;

            var url:String = "http://assets.wonderfl.net/images/related_images/7/7b/7be2/7be290bce731b60e8bceffb7f1bee308b342ad28"
            var urlReq:URLRequest = new URLRequest(url);
            _loader = new Loader();
            _loader.load(urlReq, new LoaderContext(true)); 
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete); 
        }

        private function onComplete(e:Event):void { 

            _bmd = new BitmapData(_loader.width, _loader.height, true, 0x000000);
            _bmd.draw(_loader);

            _view = new View3D();
            _scene = _view.scene;
            _camera = _view.camera;
            addChild(_view);

            _view.antiAlias = 0;
            _view.backgroundColor = 0x555555;

            _camera.y = 0;
            _camera.z = -700;

            _plane01 = new Mesh(new PlaneGeometry(500, 500), new TextureMaterial(Cast.bitmapTexture(_bmd)));
            _plane01.x = 0;
            _plane01.y = 0;
            _scene.addChild(_plane01);

            //doubleSidedプロパティがうまく設定できないのでごまかし気味に。。。
            _plane02 = new Mesh(new PlaneGeometry(500, 500), new TextureMaterial(Cast.bitmapTexture(_bmd)));
            _plane02.x = 0;
            _plane02.y = 0;
            _plane02.rotationX = 180;
            _plane02.rotationY = 180;
            _plane01.addChild(_plane02);

            addEventListener(Event.ENTER_FRAME, update);
            
            addChild(new AwayStats());
        }

        private function update(event : Event) : void {

            _plane01.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _plane01.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _camera.lookAt(ZERO);
            _view.render();
            //_view.renderer.queueSnapshot(_capture);
        }
    }
}