/**
 * Copyright Nyarineko ( http://wonderfl.net/user/Nyarineko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h2tY
 */

/*
 遊び方：キーボードと表示されてるアルファベットが対応しています
 　　　　ワンコが出てきたら対応するキーで叩きます！
 　　　　タイミングによって点数が異なる！？
 　　　　出てくるタイミングはランダムなので
 　　　　若干運に作用される感じになってます（汗
 参考：http://wonderfl.net/code/82e45099bf2f4d24451e00eb58e67835d927d405
 参考：http://wonderfl.net/code/7fddadd2d7f580140dfcf39df7d5785fe7d823fc
 ※ソース汚いので時間あったらもうちょっといじるかも
*/
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;
	import flash.net.*;
	import flash.system.*;
	
	import jp.progression.commands.*;
	import jp.progression.commands.lists.*;
	import jp.progression.commands.display.*;
	import jp.progression.commands.net.*;
	import jp.progression.commands.tweens.*;
	import jp.progression.events.*;
	
	import flash.text.TextField;
	import flash.text.TextFormat; 
	import flash.ui.Keyboard;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.events.TweenEvent;
	import org.libspark.betweenas3.tweens.ITween;
	
	import org.si.sion.*;
	
	import caurina.transitions.*;
	
	public class Main extends Sprite
	{
		public var SET_TIME:Number = 30000;
		public var mc_array:Array = new Array();
		public var mc_btn:Array = ["R","F","T","G","Y","H","U"];
		public var score:int;
		public var tx_score:TextField = new TextField();
		public var startTime:Number;
		public var time:Number;
		public var timer:Timer = new Timer(SET_TIME);
		public var flg_start:Boolean = false;
		public var tx_time:TextField = new TextField();
		public var tx_mes:TextField = new TextField();
		public var textFormat:TextFormat = new TextFormat();
		public var driver:SiONDriver = new SiONDriver();
		public var mainMelody:SiONData = new SiONData();
		public static var GRAPHICS_URL:String = "http://swf.wonderfl.net/static/assets/checkmate05/wancoProfessional.swf";
		public var domain:ApplicationDomain;
		public var _wanko : MovieClip;
		public var _copy:BitmapData;
		public var _bmp:Bitmap;
                
		public var stayMotion:MovieClip;
		public var jumpMotion:MovieClip;
		public var highJumpMotion:MovieClip;
		public var walkMotion:MovieClip;
		public var runMotion:MovieClip;
		public var squatMotion:MovieClip;
		public var questionMotion:MovieClip;
		public var exclamationMotion:MovieClip;
		public var heartMotion:MovieClip;
		public var poutMotion:MovieClip;
		public var starMotion:MovieClip;
		public var singMotion:MovieClip;
		public var sleepMotion:MovieClip;
		public var wakeMotion:MovieClip;
		
		public function Main()
		{
			super();
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			var com:SerialList = new SerialList();
			com.addCommand(
				new LoadSWF( new URLRequest( GRAPHICS_URL ) ),
				function():void {
					var loader:Loader = Loader( this.latestData );
					var domain:ApplicationDomain = loader.contentLoaderInfo.applicationDomain;
					
					stayMotion = new ( domain.getDefinition( "StayMotion" ) as Class );
					jumpMotion = new ( domain.getDefinition( "JumpMotion" ) as Class );
					highJumpMotion = new ( domain.getDefinition( "HighJumpMotion" ) as Class );
					walkMotion = new ( domain.getDefinition( "WalkMotion" ) as Class );
					runMotion = new ( domain.getDefinition( "RunMotion" ) as Class );
					squatMotion = new ( domain.getDefinition( "SquatMotion" ) as Class );
					questionMotion = new ( domain.getDefinition( "QuestionMotion" ) as Class );
					exclamationMotion = new ( domain.getDefinition( "ExclamationMotion" ) as Class );
					heartMotion = new ( domain.getDefinition( "HeartMotion" ) as Class );
					poutMotion = new ( domain.getDefinition( "PoutMotion" ) as Class );
					starMotion = new ( domain.getDefinition( "StarMotion" ) as Class );
					singMotion = new ( domain.getDefinition( "SingMotion" ) as Class );
					sleepMotion = new ( domain.getDefinition( "SleepMotion" ) as Class );
					wakeMotion = new ( domain.getDefinition( "WakeMotion" ) as Class );
					
				}
			);
			com.addEventListener(ExecuteEvent.EXECUTE_COMPLETE,onLoadSWF);
			com.execute();
			
			addEventListener(Event.ENTER_FRAME, onFrame);
			addEventListener(MouseEvent.MOUSE_UP, evMouseUp);
		}


		private function onLoadSWF(e:Event):void {
		    _init();
		}
		
		private function _init():void {
			//キーイベントセット
			stage.addEventListener(KeyboardEvent.KEY_DOWN, evKeyDown);
			//テキストフォーマット
			textFormat.size = 24;
			textFormat.color = 0x999999;
			textFormat.font = "_ゴシック";
			textFormat.align = "left";
			tx_score.defaultTextFormat = textFormat;
			textFormat.align = "right";
			tx_time.defaultTextFormat = textFormat;
			textFormat.align = "center";
			tx_mes.defaultTextFormat = textFormat;
			//タイマーをセット
			timer.addEventListener(TimerEvent.TIMER, evTimer);
			timer.reset();
			startTime = getTimer();
			trace(startTime);
			flg_start = true;
			timer.start();
			//テキスト
			tx_mes.text = "キーボードで叩け！！！";
			tx_mes.x = 0;
			tx_mes.y = 430;
			tx_mes.height = 30;
			tx_mes.width = 465;
			//タイム
			tx_time.x = 340;
			tx_time.y = 10;
			tx_time.height = 26;
			tx_time.width = 200;
			tx_time.text = "TIME:" + Math.floor(SET_TIME/1000);
			tx_time.x = 0;
			tx_time.y = 10;
			tx_time.height = 30;
			tx_time.width = 465;
			//スコア
			tx_score.text = "SCORE:" + 0;
			tx_score.x = 0;
			tx_score.y = 10;
			tx_score.height = 30;
			tx_score.width = 465;
			
			for(var i:int = 0;i < 7;i++){
				mc_array[i] = new MovieClip();
				mc_array[i] = _set_obj(i);
				addChild(mc_array[i]);
				setChildIndex(mc_array[i],i);
				//ボタン
				var tx:TextField = new TextField();
				tx.text = mc_btn[i];
				tx.x = i*50 + 75;
				tx.y = Math.floor(i%2) * 180 + 200;
				addChild(tx);
			}
			
			addChild(tx_score);
			addChild(tx_time);
			addChild(tx_mes);
			
		}
			
		private function _set_obj(i:int):MovieClip {
			
			var _set_obj:MovieClip = new MovieClip();
			//楕円
			var sp_el:Sprite = new Sprite();
			sp_el.graphics.beginFill(0x999999,1.0);
			sp_el.graphics.drawEllipse(0,160, 80, 40);
			_set_obj.addChild(sp_el);
			//ワンコ
			_set_obj.addChild(_set_wanko());
			//マスク
			var msp_el:Sprite = new Sprite();
			msp_el.graphics.beginFill(0x990000,1.0);
			msp_el.graphics.drawRect(0, 0, 80, 180);
			msp_el.graphics.drawEllipse(0, 160, 80, 40);
			_set_obj.addChild(msp_el);
			_set_obj.mask = msp_el;
			//配置
			_set_obj.x = i*50 + 40;
			_set_obj.y = Math.floor(i%2) * 180;
			
			return _set_obj;
		}
		
		private function _set_wanko():MovieClip {
			var mc_wanko:MovieClip = new MovieClip();
			//ワンコ
			var copyClass:Class;
			switch (Math.floor(Math.random() * 3))
			{
			    case 0:
		    	copyClass = stayMotion.constructor;
		    	break;
			    case 1:
		    	copyClass = starMotion.constructor;
		    	break;
			    case 2:
		    	copyClass = heartMotion.constructor;
		    	break;
				default:
		    	copyClass = wakeMotion.constructor;
					break;
		    }
			var mc_copy:MovieClip = new copyClass();
			mc_copy.x = 40;
			mc_copy.y = 120;
			mc_wanko.addChild(mc_copy);
			//トゥイ〜ン
			var tw:ITween;
			tw = BetweenAS3.delay(BetweenAS3.tween(mc_wanko,{y:50},{y:210},5,Elastic.easeOut), Math.random()*5);
			//開始
			tw.play();
			
			return mc_wanko;
		}
		
		private function _reset_obj(i:int):void {
			//５個に分裂
			for(var j:int;j < 5;j++){
				_delete_obj(i);
			}
			//音
			mainMelody = driver.compile("t200;%1@4s63l128o5b-<cr16f64");
			driver.play(mainMelody);
			
			score += Math.abs(mc_array[i].getChildAt(1).y) + 10;
			tx_score.text = "score:" + score;
			removeChild(mc_array[i]);
			mc_array[i] = new MovieClip();
			mc_array[i] = _set_obj(i);
			addChild(mc_array[i]);
			setChildIndex(mc_array[i],i);
		}
		private function _delete_obj(i:int):void {
			//消えるアニメーション
			var copyItem:MovieClip = new MovieClip();
			var copy:BitmapData=new BitmapData(465, 465, true, 0xffffff);
            copy.draw(mc_array[i].getChildAt(1), null, null);
			var bmp:Bitmap=new Bitmap(copy, PixelSnapping.NEVER, true);
			copyItem.addChild(bmp);
			copyItem.x = mc_array[i].x;
			copyItem.y = mc_array[i].y;
			addChild(copyItem);
			var ranX:Number = Math.random() * 30-10;
			var ranY:Number = Math.random() * 50-10;
			copyItem.addEventListener(Event.ENTER_FRAME,  function( e:Event ):void {
				copyItem.x += ranX;
				copyItem.y += ranY;
				copyItem.width -= 50;
				copyItem.height -= 50;
				if ( copyItem.width <= 100 || copyItem.height <= 100){
					copyItem.removeEventListener( e.type, arguments.callee );
					removeChild(copyItem);
					copyItem = null;
				}
			}, false, 1 );
		}
		
		
		private function evKeyDown(e:KeyboardEvent):void{
			//キー判定
			switch (e.keyCode)
			{
				case 82: //R
					if(mc_array[0].height < 300) _reset_obj(0);
					break;
				case 70: //F
					if(mc_array[1].height < 300) _reset_obj(1);
					break;
				case 84: //T
					if(mc_array[2].height < 300) _reset_obj(2);
					break;
				case 71: //G
					if(mc_array[3].height < 300) _reset_obj(3);
					break;
				case 89: //Y
					if(mc_array[4].height < 300) _reset_obj(4);
					break;
				case 72: //H
					if(mc_array[5].height < 300) _reset_obj(5);
					break;
				case 85: //U
					if(mc_array[6].height < 300) _reset_obj(6);
					break;
				default:
					break;
			}
		}
		
		private function evTimer(event:TimerEvent):void{
			tx_mes.text = "終了！クリックで再スタート";
			timer.reset();
			flg_start = false;
			stage.removeEventListener(KeyboardEvent.KEY_DOWN, evKeyDown);
		}
		
		private function evMouseUp(e:MouseEvent):void{
			for(var i:int = 0;i < 7;i++){
				removeChild(mc_array[i]);
			}
			timer.removeEventListener(TimerEvent.TIMER, evTimer);
			score = 0;
			_init();
		}
		
		private function onFrame(e:Event):void{
			if(flg_start){
				time = Math.floor((SET_TIME - (getTimer() - startTime))/1000);
			}else{
				time = 0;
			}
			tx_time.text = "TIME:" + time;
		}
	}
}