/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h2hE
 */

package {
    import flash.display.Sprite;
    import flash.geom.Rectangle;
    
    import flashx.textLayout.container.ContainerController;
    import flashx.textLayout.elements.Configuration;
    import flashx.textLayout.elements.ParagraphElement;
    import flashx.textLayout.elements.SpanElement;
    import flashx.textLayout.elements.TextFlow;
    import flashx.textLayout.formats.TextLayoutFormat;
    import flashx.textLayout.formats.TextAlign;
    import flash.text.engine.FontPosture;
    import flash.text.engine.Kerning;

    public class TextFlowExample extends Sprite
    {
        public var bg:Sprite;
        public var controller:ContainerController;

        public function TextFlowExample()
        {
            var config:Configuration = new Configuration();
            var textLayoutFormat:TextLayoutFormat = new TextLayoutFormat();
            textLayoutFormat.color = 0x000000;
            textLayoutFormat.fontFamily = "Arial, Helvetica, _sans";
            textLayoutFormat.fontSize = 22;
            textLayoutFormat.kerning = Kerning.ON;
            textLayoutFormat.fontStyle = FontPosture.ITALIC;
            textLayoutFormat.textAlign = TextAlign.RIGHT;
            config.textFlowInitialFormat = textLayoutFormat;
            var textFlow:TextFlow = new TextFlow(config);
            var p:ParagraphElement = new ParagraphElement();
            var span:SpanElement = new SpanElement();
            textFlow.direction = "rtl";
            span.text = "ניסיון jashd kasjd kajsh dkajsh dkajsh dkajshd kasjdh askdh שבג 456 הו.";
            p.addChild(span);
            
            bg = new Sprite;
            bg.graphics.beginFill( 0xCCCCFF );
            bg.graphics.drawRect( 0,0,300,300 );
            bg.graphics.endFill();
            addChild( bg );
            
            textFlow.addChild(p);
            textFlow.flowComposer.addController(controller = new ContainerController(bg,bg.width,bg.height));
            textFlow.flowComposer.updateAllControllers(); 
            drawBorder();
            bg.rotation = 34;
            bg.scaleX = 1.5;
			bg.x = 100;
        }

        private function drawBorder():void
        {
            // get the rectangle that makes up the bounds of the content

            var bounds:Rectangle = controller.getContentBounds();

            // retrieve the container and draw the border 
            var container:Sprite = controller.container as Sprite;
            container.graphics.lineStyle(1, 0xff0000);
            container.graphics.moveTo(bounds.left,bounds.top);
            container.graphics.lineTo(bounds.right,bounds.top);
            container.graphics.lineTo(bounds.right,bounds.bottom);
            container.graphics.lineTo(bounds.left,bounds.bottom);
            container.graphics.lineTo(bounds.left,bounds.top);
            container.graphics.drawRect(bounds.left, bounds.top, bounds.width, bounds.height );
        }

    }
}
