/**
 * Copyright melfuad ( http://wonderfl.net/user/melfuad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h2RB
 */

// forked from mousepancyo's ストレス解消銃（Hand GUN）
// forked from Event's Button
package  {
    import flash.display.Sprite;
    import flash.display.DisplayObject;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Shape;
    import flash.net.URLRequest;
    import flash.net.URLLoader;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.ProgressEvent;
    import flash.events.TimerEvent;
    import flash.filters.GlowFilter;
    import flash.filters.DropShadowFilter;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.media.Sound;
    import flash.utils.Timer;
    import flash.system.LoaderContext;
    import flash.system.ApplicationDomain;
    import flash.system.SecurityDomain;
    import flash.system.Security;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    import com.bit101.components.*;
    
    public class Main extends Sprite{
        private const W:int = 465;
        private const H:int = 465;
        private const POLICY_FILE:String = "http://www.digifie.jp/crossdomain.xml"
        private const SWF_PATH:String = "http://www.digifie.jp/files/Gun.swf"
        private var _loader:Loader;
        
        private var _gun:Sprite;
        private var _trigger:Sprite;
        private var _bodyBmd:BitmapData;
        private var _cylinderBmd:BitmapData;
        private var _slideBmd:BitmapData;
        private var _cartridgeBmd:BitmapData;
        private var _body:Bitmap;
        private var _cylinder:Bitmap;
        private var _slide:Bitmap;
        private var _cartridge:Sprite;
        private var _bullet:Sprite;
        private var _se:Sound;
        private var _filters:Array;
        
        private var _circleBmd:BitmapData;
        private var _smokeBmd:BitmapData;
        private var _smoke:Bitmap;
        private var _effectBmd:BitmapData;
        private var _effect:Bitmap;
        private var _particles:Vector.<Particle>;
        private var _ct:ColorTransform;
        private var _startX:Number;
        private var _startY:Number;
        
        private var _bar:ProgressBar;
        private var _label:Label;

        public function Main() {
            Security.loadPolicyFile(POLICY_FILE);
            _label = new Label(this, 180, 200, "Loading Wait...");
            _bar = new ProgressBar(this, 180, 220);
            _bar.maximum = 100;
            //
            _ct = new ColorTransform(1.2, 1.2, 1.2, 0.9);
            //
            _circleBmd = new BitmapData(20, 20, true, 0)
            var sp:Shape = new Shape()
            sp.graphics.beginFill(0xB7B1Ae);
            sp.graphics.drawCircle(10, 10, 10)
            sp.graphics.endFill()
            _circleBmd.draw(sp)
            //
            swfLoad(SWF_PATH)
        }
        
        //Load Swf
        private function swfLoad($swfPath:String):void{
            var context:LoaderContext = new LoaderContext(); 
            context.checkPolicyFile = true;
            context.securityDomain = SecurityDomain.currentDomain;
            context.applicationDomain = ApplicationDomain.currentDomain;
            var req:URLRequest = new URLRequest($swfPath);
            _loader = new Loader()
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, swfLoadComplete);
            _loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS,onProgressListener);
            _loader.load(req, context);
        }
        
        //Progress
        private function onProgressListener(e:ProgressEvent):void {
            var progress:int = e.bytesLoaded/e.bytesTotal*100;
            _label.text = "Loading : " + progress + " %";
            //
            if(progress >= 100){
                removeChild(_bar);
                removeChild(_label);
            }else{
                _bar.value = progress;
            }
        }
        
        //Load Complete
        private function swfLoadComplete(e:Event):void {
            _loader.contentLoaderInfo.removeEventListener(Event.COMPLETE,swfLoadComplete);
            _loader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS,onProgressListener);
            //
            var Bullet:Class = _loader.contentLoaderInfo.applicationDomain.getDefinition("Bullet") as Class;
            var Cartridge:Class = _loader.contentLoaderInfo.applicationDomain.getDefinition("Cartridge") as Class;
            var Cylinder:Class = _loader.contentLoaderInfo.applicationDomain.getDefinition("Cylinder") as Class;
            var Slide:Class = _loader.contentLoaderInfo.applicationDomain.getDefinition("Slide") as Class;
            var Body:Class = _loader.contentLoaderInfo.applicationDomain.getDefinition("Body") as Class;
            var Trigger:Class = _loader.contentLoaderInfo.applicationDomain.getDefinition("Trigger") as Class;
            var SE:Class = _loader.contentLoaderInfo.applicationDomain.getDefinition("GunShoot") as Class;
            _filters = [new GlowFilter(0x696969, 1, 4, 4, 1, 1, true), new DropShadowFilter(24, 75, 0x666666, 0.7, 10, 10, 1), new BlurFilter(0, 0)];
            _trigger = new Trigger();
            _bullet = new Bullet();
            _cartridge = new Cartridge();
            _cylinderBmd = new Cylinder();
            _slideBmd = new Slide();
            _bodyBmd = new Body();
            _se = new SE();
            _gun = new Sprite()
            _gun.filters = _filters;
            _gun.addChild(_trigger);
            _gun.addChild(_bullet)
            _gun.addChild(_cartridge)
            _gun.addChild(_cylinder = new Bitmap(_cylinderBmd, "auto", true) as Bitmap);
            _gun.addChild(_slide = new Bitmap(_slideBmd, "auto", true) as Bitmap);
            _gun.addChild(_body = new Bitmap(_bodyBmd, "auto", true) as Bitmap);
            addChild(_gun)
            _gun.x = _gun.y = W * .5;
            _trigger.x = 244 - W * .5;
            _trigger.y = 208 - H * .5;
            _bullet.x = 105 - W * .5;
            _bullet.y = 158 - H * .5;
            _bullet.filters = [new BlurFilter(10, 0)]
            _cartridge.x = 314 - W * .5;
            _cartridge.y = 187 - H * .5;
            _cylinder.x = 60 - W * .5;
            _cylinder.y = 153 - H * .5;
            _slide.x = 62 - W * .5;
            _slide.y = 133 - H * .5;
            _body.x = 120 - W * .5;
            _body.y = 180 - H * .5;
            //
            _smokeBmd = new BitmapData(W, H, false, 0xFFFFFF)
            _effectBmd = _smokeBmd.clone()
            addChild(_smoke = new Bitmap(_smokeBmd, "auto", true) as Bitmap)
            addChild(_effect = new Bitmap(_effectBmd, "auto", true) as Bitmap)
            _effect.blendMode = BlendMode.OVERLAY;
            _smoke.blendMode = BlendMode.MULTIPLY;
            _effect.alpha = 0
            //
            _trigger.buttonMode = true;
            _trigger.addEventListener(MouseEvent.MOUSE_DOWN, shoot)
        }
        
        //tween
        private function tween($target:DisplayObject, $time:Number, $xPos:Number, $yPos:Number=0, $r:Number = 0, $a:Number = 1, $delay:Number=0):void {
            var tween:ITween = BetweenAS3.tween($target, {x:$xPos, y:$yPos, rotation:$r, alpha:$a}, null, $time, Cubic.easeIn);
            tween = BetweenAS3.delay(tween, $delay)
            tween.play();
        }
        
        private function shoot(e:MouseEvent):void{
            _particles = new Vector.<Particle>();
            _smokeBmd.fillRect(_smokeBmd.rect, 0xFFFFFF);
            _effect.alpha = 1;
            _smoke.alpha = 1;
            _trigger.removeEventListener(MouseEvent.MOUSE_DOWN, shoot);
            _trigger.addEventListener(MouseEvent.MOUSE_UP, release);
            _trigger.addEventListener(MouseEvent.MOUSE_OUT, release);
            _trigger.x = 250 - W * .5;
            tween(_bullet, 0.2, -50 + -W * .5, _bullet.y, 0, 0)
            tween(_cartridge, 0.15, 290 - W * .5, 90 - H * .5, Math.random() * 120 + 120)
            tween(_slide, 0.1, 115 + -W * .5, _slide.y)
            tween(_gun, 0.1, _gun.x, _gun.y, 6, 1, 0.1)
            _gun.filters = [new GlowFilter(0x909090, 1, 12, 12, 1, 1, true), new DropShadowFilter(24, 75, 0x666666, 0.7, 12, 12, 1), new BlurFilter(2, 2)];
            _se.play(0,1)
            addEventListener(Event.ENTER_FRAME, update);
            tween(_smoke, 0.5, 0, 0, 0, 0)
            tween(_effect, 1, 0, 0, 0, 0)
             //
            var count:int = 0
            var timer:Timer = new Timer(100, 6)
            timer.addEventListener(TimerEvent.TIMER, setBulled)
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, setComplete)
            timer.start()
            function setBulled(e:TimerEvent):void{
                if(count == 1) tweenBack()
                if(count >= 3){
                    timer.removeEventListener(TimerEvent.TIMER, setBulled)
                    _gun.filters = _filters;
                }
                count++
            }
            function setComplete(e:TimerEvent):void{
                timer.removeEventListener(TimerEvent.TIMER_COMPLETE, setComplete)
                timer = null
                removeEventListener(Event.ENTER_FRAME, update);
                _bullet.x = 105 - W * .5;
                _bullet.alpha = 1;
                _trigger.addEventListener(MouseEvent.MOUSE_DOWN, shoot);
            }
            //DelayTimer
            function tweenBack():void{
                tween(_cartridge, 0.2, 314 - W * .5, 187 - H * .5, 0, 0)
                tween(_slide, 0.1, 62 + -W * .5, _slide.y, 0, 1)
                tween(_gun, 0.3, _gun.x, _gun.y, 0, 1)
            }
        }
        private function release(e:MouseEvent):void{
            _trigger.removeEventListener(MouseEvent.MOUSE_UP, release)
            _trigger.removeEventListener(MouseEvent.MOUSE_OUT, release)
            _trigger.x = 244 - W * .5;
        }

        
        //
        private function createParticle():void {
            var p:Particle = new Particle();
            var radius:Number = Math.sqrt(Math.random()) * 7;
            var angle:Number = Math.random() * (Math.PI) * 2;
            p.x = _startX;
            p.y = _startY;
            p.vx = Math.cos(angle) * radius;
            p.vy = Math.sin(angle) * radius;
            _particles.push(p);
        }
        
        private function smoke():void{
            var n:int = 500;
            _startX = 100
            _startY = 168
            while (n--) createParticle();
        }
        
        private function update(e:Event):void{
            _smokeBmd.lock();
            _smokeBmd.colorTransform(_smokeBmd.rect, _ct);
            //
            var n:int = _particles.length;
            while (n--) {
                var v:Number = Math.random() * 0.8 + 0.5;
                var p:Particle = _particles[n];
                p.vy -= 0.05;
                p.vx *= v;
                p.vy *= v;
                p.x += p.vx * 2;
                p.y += p.vy;
                _smokeBmd.copyPixels(_circleBmd, _circleBmd.rect, new Point(p.x, p.y))
            }
            _smokeBmd.applyFilter(_smokeBmd, _smokeBmd.rect, new Point(), new BlurFilter(24, 24));
            _effectBmd.copyPixels(_smokeBmd, _smokeBmd.rect, new Point())
            _smokeBmd.unlock();
            //
            smoke();
        }

    }
}


class Particle {
    public var x:Number = 0
    public var y:Number = 0
    public var vx:Number = 0
    public var vy:Number = 0
}