/**
 * Copyright gupon ( http://wonderfl.net/user/gupon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h26u
 */

// forked from mi_ku's Sphere modifier
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import flash.net.URLRequest;
    import flash.utils.getTimer;
	
    import org.papervision3d.cameras.*;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.render.*;
    import org.papervision3d.scenes.*;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.view.stats.StatsView;
    import org.papervision3d.materials.shadematerials.PhongMaterial; 
    import org.papervision3d.lights.*;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.math.*;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0x000000)]
    import flash.net.URLStream;
    import flash.geom.ColorTransform;
    public class Main extends Sprite
    {
        public function Main()
        {
        		graphics.beginFill(0);
        		graphics.drawRect( 0, 0, 465, 465 );
        		
            camera = new Camera3D( 35, 2, 5000, false, false );
            renderer = new BasicRenderEngine();
            scene = new Scene3D();
            viewport = new Viewport3D( 465, 465 );
            addChild( viewport );
            //addChild( new StatsView(renderer ) );

            var light:PointLight3D = new PointLight3D( false );
            light.x = 1000;
            light.y = 1000;
            light.z = 500;
            phongMat = new PhongMaterial( light, 0x333388, 0xAD4020, 1 );
            sphere = new Sphere( phongMat, 700, 40, 35);
            sphereStatic = new Sphere( phongMat, 500, 40, 35);
            scene.addChild( sphere );
            sphere.x = 0;
            sphere.y = 0;

            addEventListener( Event.ENTER_FRAME, loop );
            var url:URLRequest = new URLRequest( "http://scfire-ntc-aa03.stream.aol.com:80/stream/1009" );
            sound = new Sound( url );
            soundChannel = sound.play();
        }

        private function loop(e:Event):void
        {
            var rot:Number = getTimer() / 5;
            var rad:Number = ( Math.cos( rot / 60 ) + 1 ) * 2000 + 1800;
            camera.x = Math.cos( rot/100 ) * rad;
            camera.z = Math.sin( rot/100 ) * rad;
            camera.y = 0;

            camera.lookAt( DisplayObject3D.ZERO );

            var dt:Number = 0.05;
            angle1 += dt;
            angle2 += dt * 1.23;
            var lp:Number = soundChannel.leftPeak;
            var amp1:Number = Math.sin( angle1 ) * Math.max( 2, soundChannel.leftPeak * 6 );
            var amp2:Number = Math.sin( angle2 ) * Math.max( 2, soundChannel.rightPeak * 6 );
            var colorTransform:ColorTransform = new ColorTransform( .001 + lp * lp * 10, .001 + lp * lp * 10, lp*.5);
            transform.colorTransform = colorTransform;
            renderer.renderScene( scene, camera, viewport );
            var len:int = sphereStatic.geometry.vertices.length;
            for( var i:int = 0; i < len; i++ )
            {
            		var vertOrg:Vertex3D = sphereStatic.geometry.vertices[i] as Vertex3D;
            		vert.x = vertOrg.x;
            		vert.y = vertOrg.y;
            		vert.z = vertOrg.z;
            		num.x = vert.x;
            		num.y = vert.y;
            		num.z = vert.z;
            		num.normalize();
            		num.x = num.x * Math.sin( vert.x * 0.008 ) * amp1 * power;
            		num.y = num.y * Math.sin( vert.x * 0.008 ) * amp1 * power;
            		num.z = num.z * Math.sin( vert.x * 0.01 ) * amp1 * power;
            		vert.x += num.x;
            		vert.y += num.y;
            		vert.z += num.z;
            		num.x = vert.x;
            		num.y = vert.y;
            		num.z = vert.z;
            		num.normalize();
            		num.x = num.x * Math.cos( vert.y * 0.004 ) * amp2 * power;
            		num.y = num.y * Math.cos( vert.y * 0.005 ) * amp2 * power;
            		num.z = num.z * Math.cos( vert.y * 0.006 ) * amp2 * power;
            		vert.x += num.x;
            		vert.y += num.y;
            		vert.z += num.z;
            		var vertMod:Vertex3D = sphere.geometry.vertices[i] as Vertex3D;
            		
            		vertMod.x = vert.x;
            		vertMod.y = vert.y;
            		vertMod.z = vert.z;
            		vertMod.calculateNormal();
            }
            for( var j:int = 0; j < sphere.geometry.faces.length; j++ )
            {
            		sphere.geometry.faces[j].createNormal();
            		//sphere.geometry.faces[j].calculateNormal();
            }
        }

        private var sphere:Sphere;
        private var sphereStatic:Sphere;
        private var phongMat:PhongMaterial;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var scene:Scene3D;
        private var sceneForFog:Scene3D;
        private var viewport:Viewport3D;
        private var sound:Sound;
        private var soundChannel:SoundChannel;

        private var angle1:Number = 0;
        private var angle2:Number = 0;
        private var power:Number = 80;
        
        private var vert:Number3D = new Number3D();
        private var num:Number3D = new Number3D();
                
    }
}