/**
 * Copyright meemeer ( http://wonderfl.net/user/meemeer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h1MX
 */

/*
progression4でのAMFCommandでページング
頭でまとめ読みしないでページ毎に必要なデータを拾うと仮定

http://wonderfl.net/code/7e242b3283f68af7e4b4f7e9b9819fad9733aecf
ページ移動の矢印お借りしました。
すみません。
*/
package  
{
    import flash.events.*;
    import flash.net.*;
    import flash.system.Security;
    import flash.utils.*;
    import jp.progression.casts.*;
    import jp.progression.commands.lists.*;
    import jp.progression.commands.net.*;
	import jp.progression.config.BasicAppConfig;
	import jp.progression.debug.Debugger;
	
	public class FlashTest extends CastDocument
	{
		
		public function FlashTest() 
		{
			super('index', IndexScene, new BasicAppConfig());
		}
		
		override protected function atReady():void
		{
			Debugger.addTarget(manager);
			
			manager.goto(manager.root.sceneId);
		}
		
	}

}

import flash.net.*;
import flash.system.*;
import com.bit101.components.*
import jp.progression.casts.*;
import jp.progression.casts.buttons.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.commands.managers.Goto;
import jp.progression.commands.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.scenes.*;
import flash.events.MouseEvent;

class IndexScene extends SceneObject 
{
	private var page:Number;
	public static var label:Label;
	
	public function IndexScene()
	{
	}
	
	protected override function atSceneLoad():void
	{
		addCommand(
			//ページ数を取る
			new Amf('SampleController.get_page_count',
				function(res:Number):void {
					page = res;
				}, {
					//待ち処理等
					onStart:function():void { trace('amf start'); },
					onComplete:function():void { trace('amf end'); }
				}
			),
			function():void {
				//ページ数分sceneを作る
				for (var i:int = 1; i <= page; i++ ) {
					var scene:PageScene = new PageScene('Page' + i, { page_num:i } );
					addScene(scene);
				}
				
				label = new Label(container, 200, 150, "");
				var prevButton:ExPreviousButton = new ExPreviousButton( { x:50, y:50 } );
				var nextButton:ExNextButton = new ExNextButton( { x:420, y:50 } );
				prevButton.managerId = "index";
				nextButton.managerId = "index";
				prevButton.useTurnBack = true;
				nextButton.useTurnBack = true;
				
				new SerialList(null,
					new AddChild(container, prevButton),
					new AddChild(container, nextButton)
				).execute();
			}
		);
	}
	
	protected override function atSceneInit():void
	{
		manager.goto(getSceneAt(0).sceneId);
	}
}

class PageScene extends SceneObject
{
	private var page_num:int;
	
	public function PageScene(name:String = null, initObject:Object = null):void
	{
		super(name, initObject);
		
		page_num = initObject.page_num;
	}
	
	protected override function atSceneInit():void
	{
		addCommand(
			//ページのデータを取る
			new Amf('SampleController.get_page_item',
				//都合の良い様にデータ加工
				function(res:Object):Array {
					var page_data:Array = [];
					res.forEach(function(a:*, b:*, c:*):void {
						page_data.push(a);
					} );
					return page_data;
				}, {
					//待ち処理等
					onStart:function():void { trace('amf start'); },
					onComplete:function():void { trace('amf end'); }
				},
				//ページ番号を渡す
				page_num
			),
			function():void {
				//何かをする
				var test:String = '';
				this.latestData.forEach(function(a:*, b:*, c:*):void {
					test += '\n' + a;
				} );
				IndexScene.label.text = '[ ' + test + '\n]';
			}
		);
	}
	
	protected override function atSceneGoto():void
	{
		addCommand(
		);
	}
}

class ExNextButton extends NextButton {
	public function ExNextButton(initObject:Object = null) {
		super(initObject);
		
		graphics.beginFill(0x000000);
		graphics.moveTo(-25,-15);
		graphics.lineTo(0,-15);
		graphics.lineTo(0,-25);
		graphics.lineTo(25,0);
		graphics.lineTo(0,25);
		graphics.lineTo(0,15);
		graphics.lineTo(-25,15);
		graphics.lineTo(-25,-15);
		graphics.endFill();
		
		buttonMode = true;
		useHandCursor = true;
		
	}
}

class ExPreviousButton extends PreviousButton {
	public function ExPreviousButton(initObject:Object = null) {
		super(initObject);
		
		graphics.beginFill(0x000000);
		graphics.moveTo(-25,0);
		graphics.lineTo(0,-25);
		graphics.lineTo(0,-15);
		graphics.lineTo(25,-15);
		graphics.lineTo(25,15);
		graphics.lineTo(0,15);
		graphics.lineTo(0,25);
		graphics.lineTo(-25,0);
		graphics.endFill();
		
		buttonMode = true;
		useHandCursor = true;
	}
}

import flash.events.Event;
import flash.net.Responder;
import jp.progression.casts.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.commands.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.scenes.*;

/**
 * ...
 * @author m_emem
 */
class Amf extends Command 
{
	private var _amf:AmfConnect;
	private var _func:String;
	private var _args:Object;
	private var _callback:Function;
	
	/**
	 * 新しい AmfCommand インスタンスを作成します。
	 */
	public function Amf( func:String, callback:Function, initObject:Object = null, ... args:Array ) 
	{
		_func = func;
		_callback = callback;
		_args = args;
		
		// 親クラスを初期化します。
		super( _execute, _interrupt, initObject );
	}
	
	/**
	 * 実行されるコマンドの実装です。
	 */
	private function _execute():void 
	{
		_amf = AmfConnect.instance;
		_amf.dispatcher.addEventListener(Event.COMPLETE, _complete, false, 0, true);
		
		var params:Array = [_func, _callback];
		params.push.apply(params, _args);
		_amf.execute.apply(_amf, params);
		
		// 
		//executeComplete();
	}
	
	/**
	 * 中断されるコマンドの実装です。
	 */
	private function _interrupt():void 
	{
	}
	
	private function _complete(e:Event):void
	{
		_amf.dispatcher.removeEventListener(Event.COMPLETE, _complete);
		latestData = _amf.data;
		
		_amf.data = null;
		_func = null;
		_callback = null;
		_args = null;
		
		if (_amf.error != null) {
			super.throwError(this, new Error(_amf.error));
		} else {
			super.executeComplete();
		}
	}
	
	/**
	 * インスタンスのコピーを作成して、各プロパティの値を元のプロパティの値と一致するように設定します。
	 */
	public override function clone():Command 
	{
		return new Amf( _func, _callback, this, _args );
	}
}

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IEventDispatcher;
import flash.events.NetStatusEvent;
import flash.net.NetConnection;
import flash.net.ObjectEncoding;
import flash.net.Responder;

/**
 * ...
 * @author m_emem
 */
class AmfConnect
{
	private static var _instance:AmfConnect;
	public var dispatcher:IEventDispatcher;
	public var nc:NetConnection;
	public var error:Object;
	
	//private var gatewayUrl:String = 'http://localhost:13000/rubyamf/gateway';
	private var gatewayUrl:String = 'http://afternoon-spring-97.heroku.com/rubyamf/gateway';
	private var callback:Function;
	public var data:Object;
	
	public function AmfConnect() 
	{
		if (_instance === null) {
			_instance = this;
			init();
		} else {
			throw new Error('Singleton class');
		}
	}
	
	public static function get instance():AmfConnect
	{
		if (_instance === null) {
			_instance = new AmfConnect();
		}
		return _instance;
	}
	
	private function init():void
	{
		dispatcher = new EventDispatcher();
		error = null;
		
		nc = new NetConnection();
		nc.objectEncoding = ObjectEncoding.AMF3;
		nc.addEventListener(NetStatusEvent.NET_STATUS, onNetStatus);
		nc.connect(gatewayUrl);
	}
	
	private function onNetStatus(e:NetStatusEvent):void 
	{
		trace("Connection error, error code: (" +e.info.code + ")", "System message");
	}
	
	public function execute(_func:String, _callback:Function, ... _args:Array):void
	{
		callback = _callback;
		
		var params:Array = [_func, new Responder(onResultHandler, onFaultHandler)];
		params.push.apply(params, _args);
		nc.call.apply(nc, params);
	}
	
	private function onResultHandler(result:Object):void
	{
		if (callback != null) {
			data = callback.call(null, result);
		} else {
			data = result;
		}
		dispatcher.dispatchEvent(new Event(Event.COMPLETE));
	}
	
	private function onFaultHandler(fault:Object):void
	{
		data = fault;
		error = 'discription: ' + fault.description + ' code: ' + fault.code + ' details: ' + fault.details + ' level: ' + fault.level + ' line: ' + fault.line;
		dispatcher.dispatchEvent(new Event(Event.COMPLETE));
	}
	
}
