/**
 * Copyright fujiopera ( http://wonderfl.net/user/fujiopera )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h1Cy
 */

package {
    import flash.display.Sprite;
    import flashx.textLayout.container.ContainerController;
    import flashx.textLayout.elements.ParagraphElement;
    import flashx.textLayout.elements.SpanElement;
    import flashx.textLayout.elements.TextFlow;
    import flashx.textLayout.formats.TextLayoutFormat;
    
    public class TextLayoutFormat_applyExample extends Sprite
    {
        public function TextLayoutFormat_applyExample()
        {
            // create a container and add it to the stage
            var container:Sprite = new Sprite();
            this.stage.addChild(container);
            // create TextFlow, ParagraphElement, and SpanElement objects
            var textFlow:TextFlow = new TextFlow();
            var p:ParagraphElement = new ParagraphElement();
            var span:SpanElement = new SpanElement();
            // create two TextLayoutFormat objects
            var textLayoutFormat:TextLayoutFormat = new TextLayoutFormat();
            var textLayoutFormat2:TextLayoutFormat = new TextLayoutFormat();
            // set format attributes in the first one
            textLayoutFormat.textIndent = 8;
            textLayoutFormat.color = 0x336633;
            textLayoutFormat.fontFamily = "Arial, Helvetica, _sans";
            textLayoutFormat.fontSize = 24;
            // set some of the same attributes on the second one
            textLayoutFormat2.color = 0x0000CC;
            textLayoutFormat2.fontSize = 12;
            textLayoutFormat2.textIndent = 24;
            // add text to the span, the span to the paragraph, and the paragraph to the text flow.
            span.text = "Notice that fontFamily is unchanged because it was undefined in textLayoutFormat2.";
            p.addChild( span);
            textFlow.addChild(p);
            // use apply() to apply textLayoutFormat2 format settings; assign format to the text flow
            textLayoutFormat.apply(textLayoutFormat2);  
            textFlow.hostFormat = textLayoutFormat;  
            // add paragraph to textFlow and update controller to display it
            textFlow.addChild(p);
            var controller:ContainerController = new ContainerController(container, 200, 200 );
            textFlow.flowComposer.addController(controller);
            textFlow.flowComposer.updateAllControllers();  
        }
    }
}
